<?php

//Performance Functions
/*Perf related queries */
//PSAT Functions
function mxrAS_makeMonthYear($inputDate,$makePreviousMonth=false){
	$monthCats = array('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
	
	$dparts = explode('-',$inputDate);
	$oYear = $dparts[0]+0;
	$oMonth  = $dparts[1]-1;
	
	if ($makePreviousMonth){
		//We may just want to get last month...
		if($oMonth==0){
			$oMonth=12;
			$oYear--;
		} else {
			$oMonth--;
		}
	}	
	return array('month'=>$monthCats[$oMonth],'year'=>"{$oYear}",'monYear'=>"" . $monthCats[$oMonth] . "-{$oYear}");
}
function mxrAS_calcMonthlyNAV($dailyNavs,$attr = false){
	//First lets loop over all the rows and create a monthly NAV series...
	//We just sample from the NAVs so it's just replacing with the latest date...
	$monthlyNAV = array();
	switch ($attr){
		case false:
			//We have been sent the total NAV data
			foreach ($dailyNavs as $dDate=>$nav){
				$mc = mxrAS_makeMonthYear($dDate);
				$monthlyNAV[$mc['year']][$mc['month']] = array('navDate'=>$dDate,'nav'=>$nav,'plotDate'=>$mc['monYear']);
			}
			break;
		
		case true:
			//We have been sent the attribtuion NAVs...
			foreach($dailyNavs as $dDate=>$navRow){
				$mc = mxrAS_makeMonthYear($dDate);
			
				foreach($navRow as $id=>$data){
					$monthlyNAV[$mc['year']][$mc['month']][$id] = array('navDate'=>$dDate,'nav'=>$data['nav'],'plotDate'=>$mc['monYear']);		
				}
			}
			break;
		}
	return $monthlyNAV;
}
function mxrAS_getStreamAttribution($sdate, $edate, $streamChoice, $streamID, $pStartDate, $aggBool =  0){

	//We allow these functions to handle single instruments too.
    $baseFXVector = ['usdID' => 132, 'proxyID'=> 132];

    $keyRets =  mxrAS_getMSeriesForStreamByAsset($sdate, $edate, $streamChoice, $streamID, $baseFXVector);

	$keyHolds = mxrAS_getLatestHoldings($sdate,$edate,$streamChoice,$streamID,false);

	$stopAdjustments = mxrAS_getStopAdjustments($streamChoice, $streamID);


    //$stopAdjustments = array();
    //We want the function below to handle the fact that if the first perf day is the last day of the month then that day isn't in the perf history.

    //So here we may have specified an aggregation method.
    switch ($aggBool){
        case 1:
            $aggRowsArray = mxrAS_getAggNames($streamChoice, $streamID);
            break;
        case -1:
        //So we don't want to look one up BUT we may wish to deduce an aggRowsArray...

            $aggRowsArray = mxrAS_getOldIDSInThisView($streamChoice, $streamID);
            break;
        default:
            $aggRowsArray = array();
    }

    return mxrAS_portfolioReturns($keyHolds, $keyRets, $pStartDate, $aggRowsArray, $stopAdjustments);
}

function mxrAS_getStopAdjustments($typeID, $deptID){
    //Grab a stop list with each stop details attached -
    //However we only grab the stops that are triggered (or non-zero adjustments)...

    //No stops on portfolios, signals or instruments.
	if ($typeID==2) {
		//1 Grab the stops we want.
		$ddateMaster = new DateTime('now');
		$ddate = $ddateMaster->format('Y-m-d');

		//Create a list of triggered stops that have adjustments to make, UT is the full list, T the list with
		// adjustments...i.e. those stops that have been mapped to views.
		$myStopList = new AlphaSelect\StopList($deptID, $typeID, $ddate, 'T');

		//So we go get the adjustments...
		$adjs = $myStopList->getAdjustmentDetails();
	} else {
		$adjs=[];
	}
    return $adjs;

}

function mxrAS_getFHCmonthlyNAV($sDate, $eDate, $sID, $pDate){
    //grab the NAVs direct from the database.
    $SQL = "select ts,value from rets_series_data d join fhc_classes c on c.series_id = d.series_id where c.classID = {$sID} and ts>='{$sDate}' and ts<='{$eDate}' order by ts";
    $rows = mxrAS_db_grabRows('AS', $SQL, true);

    //We have two jobs now.
    //1 - remove any pre-incep dates.
    //2 - divide the series by the NAV on the incep date.
    $incepNAV = 1;
    $NAV=[];
    foreach($rows as $r){
        if($pDate == $r['ts']){
            $incepNAV = $r['value'];
        }

        if($r['ts'] >= $pDate){
            $NAV[$r['ts']] = $r['value']/$incepNAV;
        }
    }

    return array('attribtuion'=>[], 'dailyNAV'=> $NAV, 'agg'=>1);

}

function mxrAS_getMonthlyAttribution($endDate, $streamChoice, $streamID, $aggData = 0){
	//So we need to build the regular monthly data AND the drill down data. 
    echo('/and here/');
	//First pick up the full data...
	$perfStartDate = mxrAS_getPerfStartDate($streamChoice, $streamID, $endDate);
    echo(".");
	//So we have the attribution start date but probably want to pick up the data a bit 
	//before this to avoid weird attribution.
	$startDate = date('Y-m-d', strtotime('-3 month', strtotime($perfStartDate)));

    if($streamChoice != 5) {
        $attArray = mxrAS_getStreamAttribution($startDate, $endDate, $streamChoice, $streamID, $perfStartDate, $aggData);
        //Now the attribution monthly figures...

        $attrNAV = mxrAS_calcMonthlyNAV($attArray['attribution'], true);
		$attrRet = mxrAS_getReturnsFromNAV($attrNAV, true);

    } else {
        //It's an FHC NAV stream.
        $attArray = mxrAS_getFHCmonthlyNAV($startDate, $endDate, $streamID, $perfStartDate);
        $attrRet = 0;
    }

    //So we have no stats but we want the returns now...
    //Now we must create the monthly total data and stats...
    $monthlyNAV = mxrAS_calcMonthlyNAV($attArray['dailyNAV'], false);
	$monthlyRet = mxrAS_getReturnsFromNAV($monthlyNAV);
	//We can compute the statistics too...
	$monthlyStats = mxrAS_calcMonthlyStats($monthlyRet, false); //false as it's just totals...

	$dOut = array('totals'=>$monthlyRet,'attribution'=>$attrRet,'summary'=>$monthlyStats,'mNAV'=>$monthlyNAV);

	//For now we'll return these two and skip the stats part...
	return $dOut;
}

function mxrAS_calcMonthlyStats($mRets,$modelName){
	//Some vars we'll need.
	$unkeyedRets = array(); //A list of the returns
	$negMonths = 0; //Negative months.
	$nS2 = 0; //negative Sum of square returns.
	$tLoss = 0; //12 Month Losses.
	
	$lastNAV = 1;
	$navs = array();//Nav array.
	$dd = array();//Drawdown array.
	
	$tMonthRets = array();//12 Month returns.
	$iMonth = 0;
	$rollRets = array();//Rolling returns.
	$S2 = 0;//Sum of returns squared.
	
	$lastRoll = 1;


	//Loop over the returns.
	$firstFlag = true;
	foreach($mRets as $y=>$rets){
		foreach($rets as $m=>$r){
					
			$unkeyedRets[] = $r;
			
			//Negative Returns
			if($r<0){
				$negMonths ++;
				
				//Downside Calculations.
				$nS2 += pow($r,2);
				$tLoss += $r;		
			}
			
			//Rolling returns
			$idx = $iMonth % 12;
			$dropOut = ($iMonth<12) ? 0 : $tMonthRets[$idx];
			
			$lastRoll = $lastRoll*(1 + $r) / (1 + $dropOut);
			$rollRets[] = $lastRoll -1;
			
			$tMonthRets[$idx] = $r;
			$iMonth ++;
					
			//Sum of squares
			$S2 += pow($r,2);
			
			//NAVs and max drawdown.
			$lastNAV = $lastNAV*(1 + $r);
			$navs[] = $lastNAV;
			$dd[] = $lastNAV/max($navs) - 1;
			
			$lastMonth = $m;
            if($firstFlag){
                //$firstMonth = $m;
                //$firstYear = $y;
                $firstFlag = false;
                $sDate = "{$m}-{$y}";
            }
		}
		$lastYear = $y;

        $eDate = "{$m}-{$y}";


	}

	//TotalMonths
	$nMonths = count($unkeyedRets);
	
	//Max drawdown and total return
    $maxDD = min($dd);//Because drawdowns are -ve.
	$totalReturn = end($navs)-1;
	
	//exPostRisks
	$allRet = array_sum($unkeyedRets);
	$exPostRisk = sqrt(12*($S2 - (pow($allRet,2)/$nMonths))/($nMonths - ($nMonths>1 ? 1 : 0) ));
	
	if ($negMonths>0){
		$downSideRisk = sqrt(12 * ($nS2 - (pow($tLoss,2)/$negMonths))/($negMonths - ($negMonths>1 ? 1 : 0)));
	} else {
		$downSideRisk = 0;
	}
	
	//Rolling returns
	//We'll strip off the first 11 values as the 12th and onward are rolling 12 month numbers.
	//If we haven't had 12 months of data yet - so we just take the last value as the rolling array.
	$stripIdx =  ( count($rollRets) >= 12 ) ? 11 : (count($rollRets)-1);
	
	//Unset them
	if ($stripIdx>0){
		for( $i=0;$i<$stripIdx;$i++){
			unset($rollRets[$i]);
		}
	}
		
	$max12Ret = max($rollRets);
	$min12Ret = min($rollRets);
	
	$tMean = array_sum($tMonthRets)/12;
	$rollRisk = 0;
	foreach($tMonthRets as $t){	
		$rollRisk += pow($t-$tMean,2);
	}
	$rollRisk = sqrt($rollRisk);//We annualise by sqrt(12) but also divide the variance by N(the population) = 12 
	
	//Update my new series...
	$SI = 12*$allRet/$nMonths;

    $avgCash = 0;
    $targetReturn = 0;
	$sortino = ($downSideRisk == 0) ? 0 : ($SI-$targetReturn)/$downSideRisk;
	$calmar = ($maxDD == 0) ? 0 : -$SI/$maxDD;
	$sharpe = ($exPostRisk == 0) ? 0 : ($SI-$avgCash)/$exPostRisk;

	//grab key array info
	return array(	'eDate'=>$eDate,
				    'sDate'=>$sDate,
					'pMonths'=>100*($nMonths-$negMonths)/$nMonths,
					'rolling12MRet'=>$lastRoll,
					'max12MRet'=>$max12Ret,
					'min12MRet'=>$min12Ret,
					'maxMonth'=>max($unkeyedRets),
					'minMonth'=>min($unkeyedRets),
					'exTE12M'=> $rollRisk,
					'downSideRisk'=>$downSideRisk,
					'exPostRisk'=>$exPostRisk,
					'meanRet'=>$allRet/$nMonths,
					'aAlpha'=> 12*$allRet/$nMonths,
					'modelName'=>$modelName,
					'sortino'=>$sortino,
					'sharpe'=>$sharpe,
					'calmar'=>$calmar,
					'maxDD'=>$maxDD,
					'retSI'=>$lastNAV - 1,
					'roll12'=>$rollRets
				);

}
function mxrAS_getReturnsFromNAV($navArray,$attr = false){
	//So again we can check if we have the attribution or not...
	$monthlyRet = array();
	switch ($attr){
		case false:
			//No attribution. 
			//We take the navArray and build a ret array...We assume chronologically filled.
			$lastNAV = 1;
			foreach($navArray as $year=>$monthData){
				foreach($monthData as $month=>$data){
					$monthlyRet[$year][$month] = $data['nav']/$lastNAV - 1;
					$lastNAV = $data['nav'];
				}
			}
			break;
			
		case true:
			//Attribution.
			$lastNAV = array();
			foreach($navArray as $year=>$monthData){
				foreach($monthData as $month=>$data){
					foreach($data as $id=>$ndata){
						if(!isset($lastNAV[$id])){
							$lastNAV[$id]=1;
						}
						$monthlyRet[$year][$month][$id] = $ndata['nav']/$lastNAV[$id] - 1;
						$lastNAV[$id] = $ndata['nav'];
				}
				}
			}
			break;
	}
	return $monthlyRet;
}

function mxrAS_buildAggRowsArray($aggData){

    $aggRowIDs = [];
    foreach($aggData['aggRows'] as $kName=>$aggRow){
        $aggRowIDs[$kName] = mxrAS_getIDSFromAggGroup($aggRow, $aggData['excludeIDs']);
    }
    return $aggRowIDs;
}

function mxrAS_portfolioReturns($keyHolds, $keyRets, $perfStDate, $aggData = array(), $stopAdjData=array()){
	//So for every return in the rets we build the array to include weight and weight*ret too...
    //What are the holdDates?


    //March 2015 - so we pass the $stopAdjData where ['date']['secID'] = adjustment...
    //We look up a date and id to adjust our nav accordingly.

    $holdDates = array_keys($keyHolds);

	//Just check the holdDates and reset the perfStDate to the earliest holdDate if it's before.
    if(min($holdDates)>$perfStDate){
        $perfStDate = min($holdDates);
    }

	//So we need to loop over every return and assign a weight to it.
	//Keep track of the current NAV
	$currentNAVbyID = array();
	foreach ($keyHolds[$holdDates[0]] as $id=>$v){
		$currentNAVbyID[$id]=1;
	}
	
	$currentNAVbyDate = 1;
	$runningNAV = array();
	
	//Populate the attribution.
	/************************
	** LOG RETURNS FROM DB **
	*************************/

    //We map any USD_USD_30DFWD to the BASE FX ID which is the proxyID as USD_USD is in fact BASE_USD

    $attribution = array();

	foreach ($keyRets as $dDate=>$ret){
		//Pick up the date of the latest holdings.
		$latestHoldDate = mxrAS_holdDates($holdDates,$dDate);

        if (isset($keyHolds[$latestHoldDate])) {
			$kHold = $keyHolds[$latestHoldDate];
			//We have a holding to loop over the assets
		} else {
			$kHold[-999] = 0;
		}

		foreach ($ret as $id=>$r){
			if(!isset($currentNAVbyID[$id])){
				$currentNAVbyID[$id] = 1;
			}

			$w = (isset($kHold[$id])) ? $kHold[$id] : 0;

            //If the $date is before the perfStDate then the navbyID should be 1.
            $sAdj = isset($stopAdjData[$dDate][$id]) ? $stopAdjData[$dDate][$id]*.01 : 0;

			//The adjust is made or not and we carry on!
            $tempFac = ($dDate<$perfStDate) ? 1 : exp($w*$r + $sAdj);

			$currentNAVbyID[$id] *= $tempFac;
			$attribution[$dDate][$id] = array('ret' =>$r,'pos'=>$w,'attr'=>$w*$r + $sAdj,'nav'=>$currentNAVbyID[$id],'posDate'=>$latestHoldDate);
				
			//This current date NAV
			$currentNAVbyDate *= $tempFac;
		}
			

		//Store the new NAV by Date
		$runningNAV[$dDate] = $currentNAVbyDate;
		
	}
	
	//If any holds are before perfSt then unset them.
    foreach($runningNAV as $keyDate=>$val){
        if($keyDate<$perfStDate){
            unset($runningNAV[$keyDate]);
            unset($runningNAV[$keyDate]);
        }
    }

    //We put in here a risk yes/no flag or perf flag.

    //So we get here and have not aggregated anything yet.
    //$aggData is passed so is a horizontal Aggregate;
    $outputX = mxrAS_aggIDs($aggData, $attribution, $runningNAV);
    $outputX['holds']=$keyHolds;
    //print_r (mxrAS_getZeroPosIDs($outputX['attribution']));
    return $outputX;
}

function mxrAS_getRiskMat($sd, $holds){
	//Get the unique ses in a holds[d]
    $sids = [];
	foreach($holds as $h){
		foreach($h as $k=>$v){
			$sids[]=$k;
		}
	}
	$s = implode(",", array_unique($sids));
    echo ($s);
	$mySQL = "select * from ccp_exantecovar where applicable_date>='{$sd}' and secid1 in (" . $s . ") and secid2 in (" . $s . ") order by applicable_date;";
	return mxrAS_db_grabRows("AS", $mySQL);
}

function mxrAS_makeHTE($runningNAV, $myHolds, $riskMat){
    //Assumption is a daily NAV
    $tempH = array();

	//Set up the last working array
	$lastArray= array();
	$lastArray['S2'] = 0;
	$lastArray['MSum'] = 0;


	$threshold = 12;
	$tCount = 0;
	$oldVal = 0;

	//Key values
	$holdDates = array_keys($myHolds);
	$riskDates = array_keys($riskMat);

    foreach ($runningNAV as $keyDate => $val) {

		//Store the return.
		$r = $tCount == 0 ? 0 : $val / $oldVal - 1;
		$tCount++;

		//Rolling key vars
		$lastArray['S2'] += $r * $r;
		$lastArray['MSum'] += $r;

		//Store the ex-post TE
		if ($tCount >= $threshold) {
			$tempH['HTE'][$keyDate] = pow(260 * ($lastArray['S2'] - pow(($lastArray['MSum'] / $tCount), 2)) / ($tCount - 1), 0.5);
		};

		//Store the NAV...
		$oldVal = $val;

		//Now the Ex-Ante bit.
		//assuming the holdings are there for me to tackle $holdings[$date][$secID]=pos
		//and we have to grab the exante risks for (i) securities and (ii) dates and call it $riskMat[$d][$s1][$s2]=$r
		//note the riskMat has no s1>s2 so you have to switch it as it's symmetrical.

		//We have a date so which $myHolds[$d] do we use, and which $riskMat do we use?

		$d = mxrAS_holdDates($holdDates,$keyDate);
		$currentHolds = $myHolds[$d];

		$rd = mxrAS_holdDates($riskDates,$keyDate);
		$currentRM = $riskMat[$rd];

		$uniqueSecs = array_keys($currentHolds);

		$rSum = 0;
		foreach ($uniqueSecs as $s1) {
			foreach ($uniqueSecs as $s2) {
				$rSum += ($s1 < $s2) ? 2 * $currentHolds[$s1] * $currentHolds[$s2] * $currentRM[$s1][$s2] : 0;
			}
			$rSum += pow($currentHolds[$s1], 2) * $currentRM[$s1][$s1];
		}
		$tempH['EXA'][$keyDate] = pow(260 * $rSum, 0.5);

	}//The dates
	echo $tempH;
}

function mxrAS_aggIDs($aggData, $attribution, $runningNAV){
    //$aggData is simply a list of aggregates and then a set of asset_ids that belong to that aggregate.
    //i.e. aggData['OLD POSITIONS'] = array (102,124,256);
    //
    if(!empty($aggData)){

        //$aggRowsIDArray = mxrAS_buildAggRowsArray($aggData);
        $attributionNew = mxrAS_aggregateAttribution($attribution, $aggData, $runningNAV);
        $aggFlag = true;
    } else {
        $attributionNew = $attribution;
        $aggFlag = false;
    }
    return array('attribution'=>$attributionNew, 'dailyNAV'=>$runningNAV, 'agg'=>$aggFlag);
}
function mxrAS_getZeroPosIDs($attribution){
    //attribution is the output of _aggregateAttribution
    //reorganize the output to save columns...
    $newAggName='Older Pos';

    //We use aggregateRows by identifying the IDs to aggregate - these are IDs with 50 consecutive days of pos 0
    $nDaysOfZero = 50;
    $idsArray=[];

    //We think about the last nDaysOfZero number of days.
    //So strip out the last nDaysOfZero dates - how do we do that?

    //What are the last nDaysOfZero in the array?
    $newAttribution = array_slice($attribution,-$nDaysOfZero);
    $zeroPos=[];

    foreach ($newAttribution as $keyDate=>$kArray) {
        foreach ($kArray as $id=>$posArray)

        if (!isset($zeroPos[$id])){
            $zeroPos[$id] = 0;
        }
        $zeroPos[$id]+= $posArray['pos']==0 ? 0:1;
    }

    //Assuming we just looked at the horizon of interest - we then figure out all keys in zeroPos that are 0;
    foreach ($zeroPos as $kName=>$val){
        if ($val == 0){
            $idsArray[]=$kName;
        }
    }
    //print_r($idsArray);
    return $idsArray;
}
function mxrAS_aggregateAttribution($attribution, $aggRowIDArray, $runningNAV){
    foreach($aggRowIDArray as $k=>$v){
        $aggNAV[$k] = 1;
    }

    //Run over the dates.
   $newAttribution = array();
    foreach ($runningNAV as $keyDate => $val){

        //Run over each agg group.
        foreach($aggRowIDArray as $kName=>$aggRowIDs){

            //For this date keyDate we need to total up any aggregate IDs in this row.
            //We reset the row total, but carry forward the NAV
            $aggRowPerf[$kName] = 0;
            $aggRowPos[$kName] = 0;
            $aggRowRet[$kName] = 0;

            foreach($aggRowIDs as $rowID){
                if (isset($attribution[$keyDate][$rowID])){
                    $aggRowPerf[$kName] += $attribution[$keyDate][$rowID]['attr'];
                    $aggRowPos[$kName] += $attribution[$keyDate][$rowID]['pos'];
                    $aggRowRet[$kName] += $attribution[$keyDate][$rowID]['ret'];
                    $inAgg[$rowID] = true;
                }
            }

            // Deduce the new NAV
            $aggNAV[$kName] *= exp($aggRowPerf[$kName]);

            // Now put in the new attribution.
            $newAttribution[$keyDate][$kName] = array('ret' =>$aggRowRet[$kName], 'pos'=>$aggRowPos[$kName], 'attr'=>$aggRowPerf[$kName], 'nav'=>$aggNAV[$kName],'posDate'=>$keyDate);
        }

        //Now there are just the agg groups in the array.
        //So put in the IDs not covered in the aggregate.
        foreach($attribution[$keyDate] as $kID=>$v){

            if(!in_array($kID,$aggRowIDs)){
                //Put in the array.
                $newAttribution[$keyDate][$kID] = $v;
            }
        }
        //Loop over the next date.
    }
    return $newAttribution;
}

function mxrAS_getIDSFromAggGroup($aggRow, $excludes){
    //aggRow is the iaa_aid2
    if (!empty($excludes)){
        $isInSql = " and asset_id NOT IN (" . implode(',', $excludes) . ")";
    } else {
        $isInSql = "";
    }

    $rows =  mxrAS_db_grabRows('AS', "select asset_id as id from ccp_instruments where iaa_aid2 = '{$aggRow}'" . $isInSql, false);
    $output=[];
    foreach($rows as $r){
        $output[] = $r['id'];
    }
    return $output;
}

function mxrAS_holdDates($holdDates,$dDate){
	$minD = array();
	$minD[] = '1900-01-01';
	foreach($holdDates as $hd){
		if ($hd<$dDate){
			$minD[] = $hd;
			}
	}
	return max($minD);
}

function mxrAS_filterPerfOutputForOldPositions(){
    
}

function mxrAS_makePSATTableArray($retsArray,$streamChoice,$streamID,$pName,$cmdName){
	$fhcFlag = ($cmdName == 'FHCP') ? true : false;

	$tables = array();
	$tables[] = mxrAS_makeTotalsTable($retsArray['totals'],$pName,"{$cmdName}totals", $fhcFlag);

	//Present monthly or annualised figures
	$aFac = (count($retsArray['totals'])>=12) ? 12:1;

	//TODO May 2017 we want to make a ID/Position/PNL for the month...
	//If the position is 0 but the monthly PNL non zero it's ok we keep otherwise it's zero/zero.
	//When we make the table 0/0 are hidden.
	//So we will have all these little tables...perhaps figure out which data to show...

	if($fhcFlag==false) {
		$tables[] = mxrAS_makeAttributionTable($retsArray, $pName, "{$cmdName}attribution");

		$tables[] = mxrAS_makeAttributionTable($retsArray, $pName, "{$cmdName}miniAttribution", 1);//Final attribute is the flag to rejig the output array.

	}


	$tables[] = mxrAS_makeSummaryTable($retsArray['summary'],$pName,"{$cmdName}summary",mxrAS_getBaseCcy($streamID,$streamChoice), $fhcFlag, $aFac);
	
	return $tables;
}

function mxrAS_makePSATSummary($retsData, $fhcFlag, $aFac = 12){
	if ($fhcFlag){

		//If the series has less than 12 months then we don't do annualised.

		$tableDataArray = array(
			array(
			    $retsData['pName'], $retsData['retSI'], number_format($aFac*$retsData['meanRet']*100,2), $retsData['maxMonth'], $retsData['minMonth'], $retsData['maxDD'], number_format($retsData['exPostRisk']/sqrt(12/$aFac), 2),
				number_format($retsData['downSideRisk']*100,2), $retsData['sharpe'], $retsData['sortino'], $retsData['calmar']
			)
		);

	} else {
		$tableDataArray = array(
			array('Annualised Average Return %?mxrAS_total' => $retsData['aAlpha'], 'Annualised Volatility %?mxrAS_total' => number_format($retsData['exPostRisk'], 2)),
			array('Positive Months %' => number_format($retsData['pMonths'], 0), 'Volatility : Last 12 Months %' => $retsData['exTE12M']),
			array('Negative Months %' => number_format(100 - $retsData['pMonths'], 0), 'Performance Period' => $retsData['sDate'] . " to " . $retsData['eDate']),
			array('Best Month %' => $retsData['maxMonth'], '<i>Sharpe Ratio</i>' => $retsData['sharpe']),
			array('Worst Month %' => $retsData['minMonth'], '<i>Sortino Ratio</i>' => $retsData['sortino']),
			array('Max Drawdown %' => $retsData['maxDD'], '<i>Calmar Ratio</i>' => $retsData['calmar']),
			array('Best Rolling 12 Month %' => $retsData['max12MRet'], '' => ''),
			array('Worst Rolling 12 Month %' => $retsData['min12MRet'], 'Base Currency' => $retsData['baseFX']),
			array('Total Return?mxrAS_total' => $retsData['retSI'], 'Return Perspective?mxrAS_total' => 'Pure Alpha (Excess over cash).')
		);
	}

	return $tableDataArray;
}

function mxrAS_makePSATCols($fhcFlag, $aFac=12){
	if($fhcFlag) {
		//The FHC Perf Flag...
		if ($aFac == 12) {
			$aLabel = "Annualized";
			$bLabel = "";
		} else {
			$aLabel = "Monthly";
			$bLabel = "Average ";
		}

		$cols = array('Fund', 'Total Return', $bLabel . $aLabel . ' Return', 'Best Month', 'Worst Month', 'Max Drawdown', $aLabel . ' Volatility', 'Downside Volatility', 'Sharpe Ratio', 'Sortino Ratio', 'Calmar Ratio');
	} else {
		//Regular Performance Sheet
		$cols = array('Return Statistics','','Risk Statistics','');
	}
	return $cols;
}
function mxrAS_makeSummaryTable($retsData,$pName,$gName,$baseFX = 'USD', $fhcFlag = false, $aFac = 12){
	
	//tableFields
	
	//% and 2dp
	$xFormat = array('aAlpha'=>100,'exTE12M'=>100,'exPostRisk'=>100,'maxMonth'=>100,'minMonth'=>100,'sortino'=>1,'maxDD'=>100,'calmar'=>1,'max12MRet'=>100,'min12MRet'=>100,'retSI'=>100,'sharpe'=>1);
	foreach($xFormat as $f=>$v){
		$retsData[$f] = number_format($retsData[$f]*$v,2);
	}

	$retsData['baseFX'] = $baseFX;
	$retsData['pName'] = $pName;
	$tableDataArray = mxrAS_makePSATSummary($retsData, $fhcFlag, $aFac);
	      					
	$tableFields = mxrAS_makePSATCols($fhcFlag);
	
	//Build the fields and header...

    $align = $fhcFlag ? "align='center'" : "";
	$tableHtml = "<table id='mxrAS_{$gName}' class='display compact'><thead><tr>";
	foreach($tableFields as $f){
		$tableHtml .= "<th {$align}>{$f}</th>";
	}
	$tableHtml .= "</tr></thead><tbody>";
		
	//Populate the values in the table. 
	//The data is in different formats depending on the fhcFlag.

	$tableHtml .= mxrAS_makeSummaryDataTable($tableDataArray, $fhcFlag) . "</tbody></table>";
	
	//We have all we need so return the table...
	//$msg = ".";
	$msg = " : {$pName} for period " . $retsData['sDate'] . " to " . $retsData['eDate'] . ".";

	return array(
			'msg'=>"<h3>Summary Statistics (% Values) :</h3>" . $msg,
			'divID'=>"mxrAS_{$gName}_id",
			'tDOM'=>"mxrAS_{$gName}",
			'data'=>$tableHtml,
			'dTableParams'=> mxrAS_defaultDataTableParams([],$fhcFlag)
			);
}
function mxrAS_getPMDetails($streamID){
	//Get the various details for streamChoice 5;
	$SQL = "select p.pmname, p.pmbio, p.titles, c.classdescshort, c.classdescfull, c.objective, c.inception,p.webpik from fhc_pms p join fhc_classes c on p.pmid = c.pmid where c.classid = {$streamID}";
	$rows = mxrAS_db_grabRows('AS',$SQL, false);

	if(count($rows)>0) {
		$details = array(
			'pmName' => $rows[0]['pmname'] . ", Portfolio Manager.",
			'pmBio' => $rows[0]['pmbio'],
			'pmTitle' => $rows[0]['titles'],
			'classDesc' => $rows[0]['classdescshort'],
			'invObjectivesShort' => $rows[0]['classdescfull'],
			'invObjectivesLong' => $rows[0]['objective'],
			'inceptionDate' => $rows[0]['inception'],
			'pikLink' => "The PM Picture",
			'docLinks' => "Document Links",
			'feeSchedule' => "Fee Schedule Goes Here.",
			'webPik' => "<img id='mxrAS_pmpik' src='http://alphaselect.marketxray.net/wp-content/uploads/2016/05/" . $rows[0]['webpik'] . "_web.jpg' alt='" . $rows[0]['webpik'] . "'/>",
			'useMe' => true
		);
	} else {
		$details = array('useMe' => false);
	}
	//Need to refactor this...
	return $details;

}
function mxrAS_makeSummaryDataTable($tableDataArray,$fhcFlag){
	$tableHtml = "";

	if ($fhcFlag){
		// New way of doing it.
		// The data is just in rows per array...
		foreach($tableDataArray as $row){
			$tableHtml .="<tr>";
			foreach($row as $r){
				if(is_numeric($r)){
					$class = $r<0 ? "mxrAS_negRet" : "";
				} else {
					$class = "";
				}

				$tableHtml .= "<td align='center' class='{$class}'>{$r}</td>";
			}
			$tableHtml .= "</tr>";
		}
	} else {
		//PSAT way.
		foreach($tableDataArray as $row){
			$tableHtml .="<tr>";
			foreach($row as $k=>$r){
				if(is_numeric($r)){
					$class = $r<0 ? "mxrAS_negRet" : "";
				} else {
					$class = "";
				}

				$tableHtml .= mxrAS_formatCellElement($k, $r, $class);

			}
			$tableHtml .= "</tr>";
		}
	}
	return $tableHtml;
}

function mxrAS_formatCellElement($k,$r,$class){
	$parts = explode('?',$k);

	if(count($parts)>1){
		$td =  "<td class='{$parts[1]}'>{$parts[0]}</td><td class='{$class} {$parts[1]}'>{$r}</td>";
	} else {
		$td =  "<td>{$k}</td><td class='{$class}'>{$r}</td>";
	}
	return $td;
}
function mxrAS_makeTotalsTable($retsData,$pName,$gName,$fhcFlag = false){
	//Now build the grid from the precomputed totals...r[year][month]
	$tableGrid = "<table id='mxrAS_{$gName}' class='display compact'><thead><tr><th>Year</th>";
	
	//We need pre ordered column data - i.e 12 cols plus annual totals.
	$monthCats = array('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
	
	foreach($monthCats as $m){
		$tableGrid .= "<th>{$m}</th>";
	}
	$tableGrid .= "<th>Total</td></tr></thead><tbody>";
	
	//Now we need a grid...
	$startDate = "No Data Found";
	$setFlag = false;
	$endDate = "No Data Found";

    $ndp = $fhcFlag ? 2:3;

	foreach($retsData as $year=>$rets){
		//We have all the data we need now.
		$tableGrid .= "<tr><td align='center' class='mxrAS_total'>{$year}</td>";
		
		//Keep track of the yearly return.
		$eoyNav = 1;
		foreach($monthCats as $m){
			if (isset($rets[$m])){
				//Organise Plot Dates.
				$endDate = "{$m}-{$year}";

				$myClass = ($rets[$m]<0) ? " class='mxrAS_negRet mxrAS_tot'" : " class='mxrAS_tot'";

				//Add element to table
				$tableGrid .= "<td id = '" . "mxrAS_tot_{$endDate}" . "' align='center' $myClass>" . number_format($rets[$m]*100,$ndp) . "</td>";
				$eoyNav = $eoyNav*(1 + $rets[$m]);
				
				//Organise Plot Dates.
				$endDate = "{$m}-{$year}";
				if(!$setFlag){
					$setFlag = true;
					$startDate = $endDate;
				}
				
			} else {
				$tableGrid .= "<td></td>";
			}
		}
		
		//End of year total
		$myClass = ($eoyNav<1) ? " class='mxrAS_negRet mxrAS_total'" : " class='mxrAS_total'";
		$tableGrid .= "<td align='center' $myClass><b>" . number_format(($eoyNav - 1)*100,$ndp) . "</b></td></tr>";
	}
	
	//Complete the table
	$tableGrid .= "</tbody></table>";
	$msg = $fhcFlag ? "" : " : {$pName} for period  {$startDate} to {$endDate}";
	$mNameMsg = ($setFlag) ? "<h3>Monthly % Performance Grid Since Inception : </h3>" . $msg : "No holdings found for {$pName}";
	
	$dTableParams = mxrAS_defaultDataTableParams([],$fhcFlag);
					
	return array('msg'=>$mNameMsg,
				 'divID'=>"mxrAS_{$gName}_id",
				 'tDOM'=>"mxrAS_{$gName}",
				 'data'=>$tableGrid,
				 'dTableParams'=> $dTableParams
				);
	
}

function mxrAS_defaultDataTableParams($xParams = array(), $fhcFlag = false){
	$params =  array(
		'bJQueryUI'=> false,
		'bPaginate'=> false,
		'bFilter'=> false,
		'bInfo'=> false,
		'bSort'=> false
		);

	if(!$fhcFlag){
		$params['oTableTools']=array('sSwfPath'=>plugin_dir_url(__FILE__) . 'js/DataTables-1.9.4/extras/TableTools/media/swf/copy_csv_xls_pdf.swf');
		$params['sDom'] = "Tlfrtip";
	} else {
        $params['columnDefs'] = array('className'=>"dt-centre", 'targets'=> "_all");
    }

	if(!empty($xParams)){	
		foreach ($xParams as $key=>$param){
			$params[$key] = $param;
		}
	}
	return $params;
}

function mxrAS_makeAttTableHtml_Full($gName, $pName, $tableRow, $ids,$tagFlag = false){
	//Header first
	$ndp = 3;
	$tableGrid = "<table id='mxrAS_{$gName}' class='display compact cell-border'><thead><tr><th>Date</th>";

	foreach ($ids as $k => $id) {
		$tableGrid .= "<th>{$id}</th>";
	}

	$tableGrid .= "<th>Total</th></tr></thead><tbody>";

	//Then Body
	$ids['Total']='x';

	foreach($tableRow as $date=>$row){
		$html = "<tr><td class='mxrAS_total'>{$date}</td>";

		$cellDOMclass = 'mxrAS_att_' . $date;

		$rowHtml = array();
		foreach($row as $id=>$elem){
			//Handle the total too...


			$myClass = array();
			if($elem<0) { $myClass[] = "mxrAS_negRet";}
			if($id=='Total'){ $myClass[] = "mxrAS_total";}

			$myClass[] = "{$id}";
			$myClass[] = "{$cellDOMclass}";

			$thisR = number_format($elem*100,$ndp);
			if (count($myClass)>0){
				$rowHtml[$id]= "<td align='center' mxrAS_name = '" . $ids[$id] . "' class='" . implode(" ", $myClass) . "'>{$thisR}</td>";
			} else {
				$rowHtml[$id] = "<td align='center'>{$thisR}</td>";
			}
		}


		foreach ($ids as $k=>$dumm){
			if(!isset($rowHtml[$k])){
				$rowHtml[$k]="<td align='center'>" . number_format(0,$ndp) ."</td>";
			}
			$html .= $rowHtml[$k];
		}

		$tableGrid .= $html . "</tr>";
	}

	$tableGrid .= "</tbody></table>";
	$d = array_keys($tableRow);

	return array('TG'=>$tableGrid, 'msg'=>"Monthly % Performance Attribution : {$pName} For Period " . $d[0] . " to " . $d[count($d)-1]);
}

function mxrAS_makeAttTableHtml_Modal($gName, $pName, $tableRow, $ids){
	//So this prepares all the possible modals....

}

function mxrAS_makeAttributionTable($retsArray,$pName,$gName, $forModal = 0){
	//So we go build a table...
    //$ndp = 3;
	$tableRow = array();
	//Add the instruments we need...
	foreach($retsArray['totals'] as $year=>$attrByMonth){

        foreach($attrByMonth as $month=>$dummyret){
            $attrByID = $retsArray['attribution'][$year][$month];

			foreach($attrByID as $id=>$ret){
				$tableRow["{$month}-{$year}"][$id] = $ret;
				
				if (!isset($ids[$id])){
					$ids[$id]="SecName = {$id}";
				}
			}
			$tableRow["{$month}-{$year}"]['Total'] = $retsArray['totals'][$year][$month];
		}
	}
	
	//Get the sec names
	$ids = mxrAS_getSecNames(array_keys($ids),true,true);

	$myTable = mxrAS_makeAttTableHtml_Full($gName, $pName, $tableRow, $ids);

	//Return the output table
	return array('msg'=>$myTable['msg'],
				 'divID'=>"mxrAS_{$gName}_id",
				 'tDOM'=>"mxrAS_{$gName}",
				 'data'=>$myTable['TG'],
				 'dTableParams'=>mxrAS_defaultDataTableParams(
                     array(
                         'sScrollY'=> "600",
                         'sScrollX'=>true,
                         'bScrollCollapse'=>true
                     )
                 )
				 );
}

//PSS Functions
function mxrAS_getMonthlyReturns(&$radioDate,$streamChoice,$streamID){
	//Grab the rows from the perf tables
	$rows = mxrAS_getFullSeriesReturns($radioDate,$streamChoice,$streamID);
	
	//Set the model name
	$modelName = $rows[0][5];
	
	//Get the monthly NAVs with all the data you need...
	return  mxrAS_calcMonthlyReturns($rows,$modelName);
}
function mxrAS_getFullSeriesReturns(&$radioDate,$streamChoice,$streamID){

	if ($streamChoice<4){
		//From the Perf Tables.
		$rows = mxrAS_getTSeriesByTypeID($radioDate,$streamChoice,$streamID,27);
		
	} else {
		//We pick up the rows direct for the securities...for last 5 years?
		$rows = mxrAS_getTSeriesForSecID($radioDate,$streamID);
		//Now we turn these log returns into a NAV
		$lastNAV = 1;
		
		foreach ($rows as $k=>&$r){
			$r[1] = $lastNAV*exp($r[1]);
			$lastNAV = $r[1];
		}
	}
	
	return $rows;
}
function mxrAS_calcMonthlyReturns($rows,$modelName){
	//So we assume a series of data here in some higher frequency format...Plus the data is a NAV already...
	
	//Pick up the first NAV and date...
	$dparts = explode('-',$rows[0][0]);
	$sMonth = $dparts[1]-1;
	$sYear = $dparts[0]+0;
	
	if ($sMonth<1){
		$sMonth = 12;
		$sYear = $sYear-1;
	} 
	
	//Set up the months
	$monthCats = array('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
	
	//Build out the array
	$monthlyNAV = array();
	$mc = $monthCats[$sMonth-1];
	$monthlyNAV["{$sYear}"][$mc]= array('navDate'=>$rows[0][0],'nav'=>$rows[0][1],'plotDate'=>"{$mc}-{$sYear}");
	
	$minYear = $sYear;
	$maxYear = $sYear;
	
	//Then we convert into monthly nav
	foreach ($rows as $row){
		$dparts = explode('-',$row[0]);
		$sMonth = $dparts[1];
		$sYear = $dparts[0];
		
		$mc = $monthCats[$sMonth-1];
		if (isset($monthlyNAV["{$sYear}"][$mc])){
			if($dparts[2]>$monthlyNAV["{$sYear}"][$mc]['navDate']){
				$monthlyNAV["{$sYear}"][$mc]= array('navDate'=>$row[0],'nav'=>$row[1],'plotDate'=>"{$mc}-{$sYear}");
			}
		} else {
			$monthlyNAV["{$sYear}"][$mc]= array('navDate'=>$row[0],'nav'=>$row[1],'plotDate'=>"{$mc}-{$sYear}");
		}

		$minYear  = ($sYear<$minYear)  ? $sYear : $minYear;
		$maxYear = ($sYear>$maxYear) ? $sYear : $maxYear;
	}
	
	
	//Now a monthly return...
	$totalReturn = 0;
	$nMonths = 0;
	$rets = array();
	
	//Rolling 12 
	$tempRoll = 0;
	$max12Ret = -999;
	$min12Ret = +999;
	$S2 = 0;//For risk purposes..
	
	//Min/Max months
	$maxMonth = -999;
	$minMonth = +999;
	
	//Downside risks
	$totalLoss = 0;
	$negMonths = 0;
	$exPostRisk = 0;
	$downSideRisk = 0;
	$dRisk = 0;
	
	$firstNav = -999;
	
	$maxNav = -999;
	$maxDD = 999;
	
	//Now tidy up the series...
	$monthlyNAVSeries = array();
	$tempMret = array();
	
	for($iYear=$minYear;$iYear<=$maxYear;$iYear++){
		for($iMonth=0;$iMonth<12;$iMonth++){
			
			//End NAV Easier
			$endMonthCat = $monthCats[$iMonth];
			
			//Start NAV
			if($iMonth==0){
				$stMonthCat = $monthCats[11];
				$zY = $iYear-1;
			} else {
				$stMonthCat = $monthCats[$iMonth-1];
				$zY = $iYear;
			}
			
			//Do we have data for this month-year?
			if(isset($monthlyNAV["{$iYear}"][$endMonthCat]) && isset($monthlyNAV["{$zY}"][$stMonthCat])){
				$nMonths++;
				
				//First NAV
				if($firstNav==-999){
					$firstNav = $monthlyNAV["{$zY}"][$stMonthCat]['nav'];
				}
				//Set the end and start NAV
				$endNav = $monthlyNAV["{$iYear}"][$endMonthCat]['nav'];
				$stNav = $monthlyNAV["{$zY}"][$stMonthCat]['nav'];
				
				//Deduce Drawdown now...
				$maxNav = ($endNav>$maxNav) ? $endNav : $maxNav;
				$thisDD = ($endNav/$maxNav)-1;//was log
				
				$maxDD = $thisDD < $maxDD ? $thisDD : $maxDD;
				
				//And the current return
				$zRet = ($endNav/$stNav)-1;//was log
				$pDate = $monthlyNAV["{$iYear}"][$endMonthCat]['plotDate'];
				$tempMRet[$pDate]=$zRet;
				
				//Risk partial sums.
				$exPostRisk += pow($zRet,2);
				
				$SI = ($endNav/$firstNav)-1;//was log
				$zOff = $nMonths>1 ? 1:0;
				$tRisk = sqrt(12)*sqrt(($exPostRisk - pow($SI,2)/$nMonths)/($nMonths-$zOff));
	
				//Keep track of negative periods.
				if($zRet<0){
					$totalLoss = ($totalLoss+1)*(1+$zRet)-1;
					$downSideRisk += pow($zRet,2);
					$negMonths++;
					
					$dRisk = sqrt(12)*sqrt(($downSideRisk - pow($totalLoss,2)/$negMonths)/($negMonths-($negMonths>1 ? 1:0)));
				}
				
				//Rolling Return
				$lastYear = $iYear-1;
				if(isset($tempMRet["{$endMonthCat}-{$lastYear}"])){
					$tempRoll = (1+$tempRoll) *(1+$zRet)/(1+$tempMRet["{$endMonthCat}-{$lastYear}"])-1;
					
					$max12Ret = ($tempRoll>$max12Ret) ? $tempRoll : $max12Ret;
					$min12Ret = ($tempRoll<$min12Ret) ? $tempRoll : $min12Ret;
					
					$S2 += pow($zRet,2) - pow($tempMRet["{$endMonthCat}-{$lastYear}"],2);
					$rollRisk = sqrt(12)*sqrt(($S2 - pow($tempRoll,2)/12)/11);
					
				} else {
					$tempRoll = (1+$tempRoll)*(1+$zRet)-1;
		
					$max12Ret = $tempRoll;
					$min12Ret = $tempRoll;
					
					$S2 += pow($zRet,2);
					
					$rollRisk = sqrt(12)*sqrt( ($S2 - pow($tempRoll,2)/$nMonths)/($nMonths-($nMonths>1 ? 1:0)));
					
				}
				
				//Min/max months
				$maxMonth = ($zRet > $maxMonth) ? $zRet : $maxMonth;
				$minMonth = ($zRet < $minMonth) ? $zRet : $minMonth;
				
				//$rollRisk = sqrt(($S2 - pow($tempRoll,2)/12)/11);
				
				//Update my new series...
				$sortino = ($dRisk == 0) ? 0 : 12*$SI/($nMonths*$dRisk);
				$calmar = ($maxDD == 0) ? 0 : -12*$SI/($nMonths*$maxDD);
				$sharpe = ($tRisk ==0) ? 0 : 12*$SI/($nMonths*$tRisk);
				
				$monthlyNAVSeries[]=array('plotDate'=>$monthlyNAV["{$iYear}"][$endMonthCat]['plotDate'],
										  'navDate'=>$monthlyNAV["{$iYear}"][$endMonthCat]['navDate'],
										  'nav'=>$monthlyNAV["{$iYear}"][$endMonthCat]['nav'],
										  'mRet'=>$zRet,
										  'retSI'=>$SI,
										  'pMonths'=>($nMonths-$negMonths)/$nMonths,
										  'rolling12MRet'=>$tempRoll,
										  'max12MRet'=>$max12Ret,
										  'min12MRet'=>$min12Ret,
										  'maxMonth'=>$maxMonth,
										  'minMonth'=>$minMonth,
										  'exTE12M'=> $rollRisk,
										  'downSideRisk'=>$dRisk,
										  'exPostRisk'=>$tRisk,
										  'meanRet'=>$SI/$nMonths,
										  'aAlpha'=> 12*$SI/$nMonths,
										  'modelName'=>$modelName,
										  'sortino'=>$sortino,
										  'sharpe'=>$sharpe,
										  'calmar'=>$calmar,
										  'drawdown'=>$thisDD,
										  'maxNAV'=>$maxNav,
										  'maxDD'=>$maxDD
										  );
			}
		}
	}
	
	//Print the output...
	return $monthlyNAVSeries;
}
function mxrAS_makeMonthlyPerfChart($monthlyNAVSeries,$thresholdMonths=5000){

$mNS = array_values($monthlyNAVSeries);
$firstRow = reset($mNS);
$lastRow = end($mNS);

if(count($monthlyNAVSeries>$thresholdMonths)){
	//We'll make it quarterly data...
	$thisSeries = array();
	$tempRow = array();
	$eoQ = false;
	$rret = 0;
	foreach($monthlyNAVSeries as $r){
		$month = explode($r['plotDate'],'-');
		
		$rret +=$r['mRet'];
		$tempRow = array('plotDate'=>$r['plotDate'], 'mRet'=> $rret);
		
		if (in_array($month[0],array('Mar','Jun','Sep','Dec'))){
			$thisSeries[] = $tempRow;
			$eoQ = false;
			$rret = 0;
		}
	}
} else { 
	$thisSeries = $monthlyNAVSeries;
}

//Make the numbers more readable...
$chartData = array();
$chartCats = array();
$cumData = array();
$cumCats = array();

foreach ($monthlyNAVSeries as $r){
	$chartData[] = (double)1*(number_format($r['mRet']*100,2));
	$chartCats[] = $r['plotDate'];
	
	$cumData[] = (double)1*(number_format(100*($r['nav']-1),2));
}

$stepSize = (count($chartCats)>50) ? 3 : 1;
	
$chartColors = mxrAS_HCgetColors(-1);//Gets all of them...
$colIndx=0;
$cumIndx=2;

$jsCharts = array();

//Arrange the bar and line data...
$seriesData = array();
$seriesData[] = array(
					'name'=>$firstRow['modelName'] . " Monthly",
					'type'=>'column',
					'data'=>$chartData,
					'color'=>$chartColors[$colIndx],
					'tooltip'=>array('valueSuffix'=>' %'),
                	);
$seriesData[] = array(
                	'name'=>$firstRow['modelName'] . " Cumulative",
                	'type'=>'spline',
                	'data'=> $cumData,
                	'color'=>$chartColors[$cumIndx],
                	'yAxis'=>1,
                	'marker'=>array('enabled'=>false),
                	'tooltip'=>array('valueSuffix'=> ' %')
                	);
                	
$jsCharts[]=array(
			'chartOptions'=>array(
				'chart'=>array('zoomType'=>'xy'), //'type'=>'column'),
				'title'=>array('text'=>"Monthly Returns For {$firstRow['modelName']} From {$firstRow['navDate']} To {$lastRow['navDate']}"),
				'subtitle'=>array('text'=>"Pinch/Click area to zoom"),
				'xAxis'=>array('categories'=>$chartCats,
							   'labels'=>mxrAS_HCGetLabels('xaxis',-75,$stepSize)),
				'yAxis'=> mxrAS_HCGetLabels('dualYaxis',
								array(
									array('text'=>"Monthly Returns %",
										  'format'=>'{value} %',
										  'color'=>$chartColors[$colIndx],
										  'opposite'=>false),
									array('text'=>"Cumulative Return %",
										  'format'=>'{value} %',
										  'color'=>$chartColors[$cumIndx],
										  'opposite'=>true))),									  
				'tooltip'=>array('shared'=>true),
				'credits'=>mxrAS_HCGetCredits(),
				'exporting'=>mxrAS_HCGetExporting()
				),
			'chartData'=>$seriesData
			);
			
return $jsCharts;

}
function mxrAS_getNAVDates($navArray,$attr = false){
	$sortDates = array();
	switch ($attr){
		case false:
			foreach($navArray as $y=>$nData){
				foreach($nData as $m=>$data){
					$sortDates[] = $data['navDate'];
				}
			}	
			break;
			
		case true:
			foreach($navArray as $y=>$nData){
				foreach($nData as $m=>$data){
					$ids = array_keys($data);
					$sortDates[] = $data[$ids[0]]['navDate'];
				}
			}
			break;
		}
	return $sortDates;
}
function mxrAS_makePerfStatsSummaryTable($retsData,$options){
	//We actually just make a JSON object and let the client handle the rest to format the table. 
	$rd = array_values($retsData);
	$startData = reset($rd);
	$endData = end($rd);
	
	//Covert the numeric fields to My Number Format
	$eData = array();
	$special = array('sharpe','calmar','sortino','maxNav','nav');
	foreach($endData as $k=>$e){
		if(is_numeric($e)){
			$sf = in_array($k,$special) ? 1 : 100;
			$eData[$k] = (double)1*number_format($e*$sf,2);
		} else { 
			$eData[$k] = $e;
		}
	}
	
	//tableFields
	$tableDataArray = array( array('Annualised Average Return %?mxrAS_total'=>$eData['aAlpha'],'Annualised Volatility %?mxrAS_total'=>$eData['exPostRisk']),
	      					 array('Positive Months %'=>$eData['pMonths'],'Volatility : Last 12 Months %'=>$eData['exTE12M']),
	      					 array('Negative Months %'=>(100-$eData['pMonths']),'Performance Period'=>$startData['plotDate'] . " to " . $endData['plotDate']),
	      					 array('Best Month %'=>$eData['maxMonth'],'<i>Sharpe Ratio</i>'=>$eData['sharpe']),
	      					 array('Worst Month %'=>$eData['minMonth'],'<i>Sortino Ratio</i>'=>$eData['sortino']),
	      					 array('Max Drawdown %'=>$eData['maxDD'],'<i>Calmar Ratio</i>'=>$eData['calmar']),
	      					 array('Best Rolling 12 Month %'=>$eData['max12MRet'],''=>''),
	      					 array('Worst Rolling 12 Month %'=>$eData['min12MRet'],'Base Currency'=>$options['baseFX']),
	      					 array('Total Return?mxrAS_total'=>$eData['retSI'],'Return Perspective?mxrAS_total'=>'Pure Alpha (Excess over cash).')
	      					);
	      					
	$tableFields = array('Return Statistics','','Risk Statistics','');
	$tID = "mxrAS_PSSdatatable";
	
	//Build the fields and header...
	$tableHtml = "<table id='" . $tID . "'><thead><tr>";
	foreach($tableFields as $f){
		$tableHtml .= "<th>{$f}</th>";
	}
	$tableHtml .= "</tr></thead><tbody>";
		
	//Populate the values in the table. 
	foreach($tableDataArray as $row){
		$tableHtml .="<tr>";
		foreach($row as $k=>$r){
			if(is_numeric($r)){
		 		$class = $r<0 ? "mxrAS_negRet" : "";
		 	} else {
		 		$class = "";
		 	}
		 	
		 	$parts = explode('?',$k);
		 	if(count($parts)>1){
				$tableHtml .= "<td class='{$parts[1]}'>{$parts[0]}</td><td class='{$class} {$parts[1]}'>{$r}</td>";
		 	} else {
		 		$tableHtml .= "<td>{$k}</td><td class='{$class}'>{$r}</td>";
		 	}
		 	 
		}
		$tableHtml .= "</tr>";
	}
	$tableHtml .= "</thead></table>";
	
	//Now build the grid...
	$tableGrid = "<table id='mxrAS_PSSdatagrid'><thead><tr><th>Year</th>";
	$monthCats = array('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
	
	foreach($monthCats as $m){
		$tableGrid .= "<th>{$m}</th>";
	}
	$tableGrid .= "<th>Total</td></tr></thead><tbody>";
	
	//Now we need a grid...
	$dateParts = explode('-',$startData['plotDate']);
	$sYear = $dateParts[1]*1;
	
	$dateParts = explode('-',$endData['plotDate']);
	$eYear = $dateParts[1]*1;
	
	//Loop over everything...
	$lastDate = true;
	
	//better reshape of the array.
	$retsForGrid = array();
	foreach($retsData as $r){
		$parts = explode('-',$r['plotDate']);
		$kY = $parts[1];
		$kM = $parts[0];
		$retsForGrid[$kY][$kM]=$r['mRet'];
	}
	
	for($iYear=$sYear;$iYear<=$eYear;$iYear++){
		$tableGrid .= "<tr><td align='center' class='mxrAS_total'>{$iYear}</td>";
		$eoyRet = 1;
		foreach($monthCats as $m){
			if(isset($retsForGrid["{$iYear}"][$m])){
				$thisRet = $retsForGrid["{$iYear}"][$m];
				$myClass = ($thisRet<0) ? " class='mxrAS_negRet'" : "";
				
				$tableGrid .= "<td $myClass>" . (double)1*number_format($thisRet*100,2) . "</td>";
				$eoyRet = $eoyRet*exp($thisRet);
			} else { 
				$tableGrid .= "<td></td>";
			}
		}
		//Now the end of Year adjustment
		$myClass = ($eoyRet<1) ? " class='mxrAS_negRet mxrAS_total'" : " class='mxrAS_total'";
		$tableGrid .= "<td $myClass><b>" . (double)1*number_format(log($eoyRet)*100,2) . "</b></td></tr>";
	}
	$tableGrid .= "</tbody></table>";	
		 
	return array('hasSummary'=>true,
				 'hasGrid'=>true,
				 'tHtml'=>array('divID'=>'mxrAS_PSS_summary','tDOM'=>'mxrAS_PSSdatatable','data'=>$tableHtml),
    			 'mName'=>$endData['modelName'] . " for period " . $startData['plotDate'] . " to " . $endData['plotDate'],
    			 'tGrid'=>array('divID'=>'mxrAS_PSS_grid','tDOM'=>'mxrAS_PSSdatagrid','data'=>$tableGrid)
    			 );
}

function mxrAS_calcDrillDownMonthlyReturns($drillDown){

	//Array is in daily format and we want monthly...
	//Set up the months
	$monthlyNAV = array();
	
	//loop over everything and build up the array
	foreach ($drillDown as $ddate=>$data){
		$thisID = mxrAS_makeMonthYear($ddate);
		foreach ($data as $id=>$nav){
			$monthlyNAV[$thisID][$id] = $nav; //Puts the latest NAV in for each ID.
		}
	}
	
	//Now we generate the returns by looping over the monthly NAVs...Could we speed up by having 2 less loops...
	//Here we have nDays*nIDs + nMonths*nIDs which is approx nIDs*nDays*1.08 calcs plus nMonths*nIDs if statements. 
	//The other way would only have about 8% less calcs but many more ifs. 
	
	$lastNAV = array();
	foreach ($monthlyNAV as $thisID=>$data){
		foreach($data as $id=>$nav){
			if (!isset($lastNAV[$id])){
				$lastNAV[$id]=1;
			}
			$monthlyNAV[$thisID][$id] = $nav/$lastNAV[$id]-1;
		}
		$lastNAV[$id] = $nav;
	}
	return $monthlyNAV;
}

function mxrAS_makeDrillDownAttChart($retsArray, $titles, $dualAxis = true, $risk = false){
	//Prep the data...
	//$chartCats = array();//What are the chart categories...
	
	$chartData = array();
	$cumData = array();
	
	foreach($retsArray['totals'] as $year=>$attrByMonth){

		foreach($attrByMonth as $month=>$retDummy){
			$cat = "{$month}-{$year}";
			$chartData[] = array('name'=>$cat,'y'=>(double)1*(number_format($retsArray['totals'][$year][$month]*100,2)),'drilldown'=>$cat);
			
			//Cumulative 
			$cumData[] = (double)1*(number_format(($retsArray['mNAV'][$year][$month]['nav']-1)*100,2));
		}
	}
	
	//Make the numbers more readable...
	return mxrAS_makePerfChart($chartData, $cumData, $titles, $dualAxis);
}

function mxrAS_createDualAxisChart($titles, $stepSize, $chartColors, $seriesData){
    //We organise the data for the highchart for dualAxis
    $jsCharts = array();

    $chartOptions = array(
        'chart' => array('zoomType' => 'xy', 'height' => 500),
        'title' => array('text' => $titles['main'][0]),
        'xAxis' => array('type' => 'category', 'labels' => mxrAS_HCGetLabels('xaxis', -75, $stepSize)),
        'yAxis' => mxrAS_HCGetLabels('dualYaxis',
            array(
                array('text' => "Monthly Returns %", 'format' => '{value} %', 'color' => $chartColors[0], 'opposite' => false),
                array('text' => "Cumulative Return %", 'format' => '{value} %', 'color' => $chartColors[2], 'opposite' => true)
            )),
        'legend' => array('align' => 'left', 'x' => 80, 'verticalAlign' => 'top', 'y' => 50, 'floating' => true, 'borderColor' => '#CCC', 'borderWidth' => 1, 'shadow' => false, 'layout' => 'vertical'),
        'tooltip' => array('shared' => true),
        'credits' => mxrAS_HCGetCredits(),
        'exporting' => mxrAS_HCGetExporting(),
        'plotOptions' => array('series' => array('datalabels' => array('enabled' => true)))
    );


    $jsCharts[] = array(
        'chartOptions' => $chartOptions,
        'chartData' => $seriesData
    );

    return $jsCharts;
}

function mxrAS_createDoubleChart($titles, $stepSize, $chartColors, $seriesData){
    //We organise the data for the highchart for dualAxis
    $jsCharts = array();

    //We do two charts - monthly
    //Requires a refactor of the seriesData
    $categories = array();
    $yValues = [];
    foreach ($seriesData[0]['data'] as $col){
           $categories[] = $col['name'];
           $yValues[] = $col['y'];
    }

    $jsCharts[] = mxrAS_buildDualChart('column', $titles['main'][0], $categories, $stepSize, $yValues, $chartColors[7], "Monthly Returns %");

    //Now the cumulative data
    //Organise the data
	$dataArray[] = $seriesData[1]['data'];

	foreach($seriesData[1]['data'] as $p){
		$x[] = $p-0.05;
	}
	$dataArray[] = $x;
    $jsCharts[] = mxrAS_buildDualChart('spline', $titles['main'][1], $categories, $stepSize, $dataArray, $chartColors[7], 'Cumulative Performance %', array('areaspline'=> array('fillOpacity'=>0.5)));

    return $jsCharts;
}

function mxrAS_buildDualChart($type,$title, $cats, $step, $data, $colors,$axisName){
    return array(
        'chartOptions' => array(
            'chart' => array('type'=> $type, 'height' => 500),
            'title' => array('text'=> $title),
            'xAxis' => array('categories'=>$cats, 'labels' => mxrAS_HCGetLabels('xaxis', -75, $step)),
            'yAxis' => mxrAS_HCGetLabels('yaxis', $axisName),
            'tooltip' => array('shared' => true),
            'exporting' => mxrAS_HCGetExporting()
        ),
        'chartData' => array(
            'name' => $axisName,
            'data' => $data,
            'color' => $colors,
            'tooltip' => array('valueSuffix' => ' %'))

    );
}

function mxrAS_getRiskRatingAndBMK($streamID) {
	$SQL = "select ";
}
function mxrAS_getManagerComment($streamID, &$radioDate, $userObj){

	$SQL = "select r.repfordate, d.comment from fhc_monthlyreportdetails d join fhc_monthlyreport r on r.commentid = d.commentid where r.classid = {$streamID} and r.repfordate<='{$radioDate}' and r.status = 'L' order by r.repfordate desc";
	$rows = mxrAS_db_grabRows('AS',$SQL, false);
	
	if (count($rows)>0){
		$radioDate = $rows[0][0];
		$comment = $rows[0][1];
	} else {
		$comment = "No reports were found...";
	}
	return $comment;
}
function mxrAS_makePerfChart($chartData, $cumData, $titles, $dualAxis = true){
	//Make the numbers more readable...
	//Try the default...
	$stepSize = (count($chartData)>20) ? round(count($chartData)/10) : 1;

	//Make the chart...
    $chartColors =mxrAS_HCGetColors(-1);

	//If it's dual we create a dual axis chart, otherwise we create 2 individual charts.
	//We must put the drilldown in here to make it work...
	$seriesData = array();

    //Monthly column chart
	$seriesData[] = array('name'=>'Monthly Attribution Totals %','type'=>'column','data'=>$chartData,'tooltip'=>array('valueSuffix'=>' %'));

	//The spline values for the cumulative data...
	$seriesData[] = array('name'=>'Cumulative Performance %','type'=>'spline','data'=> $cumData,'color'=>$chartColors[2],'yAxis'=>1,'marker'=>array('enabled'=>false),'tooltip'=>array('valueSuffix'=> ' %'));

    //Return a jsChart back to the controller.
     return  ($dualAxis) ? mxrAS_createDualAxisChart($titles, $stepSize, $chartColors, $seriesData) : mxrAS_createDoubleChart($titles, $stepSize, $chartColors, $seriesData);
}

function mxrAS_getBaseCcy($streamID,$streamChoice){
	
	$sd = mxrAS_getStreamDetails($streamChoice);
	$rows = mxrAS_db_grabRows('AS',$sd['baseSQL'] . 1*$streamID,false);
	
	return $rows[0]['bfx'];
}

function mxrAS_arrayFilter_holdDates($d){
	return function ($e) use ($d) {return $e<$d;};
}

function mxrAS_getMultiplePerfTypeSeries($cmd,$streamChoice,&$radioDate,$id,$lambda,$title,$yAxis){
	//Figure out which stream we need...
	$streamDetails = mxrAS_getStreamDetails($streamChoice);
	
	$mySQL = "SELECT p.applicable_date as pdate, p.type, x.type_description as pdesc, p.value as pval, z." . $streamDetails['fieldName'] . "_name 
			  FROM ccp_" . $streamDetails['tableNameRoot'] . "_perf p 
			  JOIN ccp_perf_types x ON p.type=x.ptype 
			  JOIN ccp_perf_types_groups g ON p.type=g.ptype 
			  JOIN ccp_" . $streamDetails['tableNameRoot'] . " z ON p." . $streamDetails['fieldName'] . "_id = z." . $streamDetails['fieldName'] . "_id 
			  WHERE g.cmdgroup='" . $cmd . "' AND p." . $streamDetails['fieldName'] . "_id=" . $id . " 
			  ORDER BY x.type_description, p.applicable_date ASC";
	
	//necessary for the dateTime format of the charts to display timeSeries properly.
	date_default_timezone_set('UTC'); 
	
    //Go get the raw rows.
    $rows = mxrAS_db_grabRows('AS',$mySQL,false);
    
     //Now we set up the data for each series...
    $uniquePatterns = mxrAS_uniqueByKeyName($rows,'pdesc');
    
    $deptName = $rows[0][4];
    
    //...and build out the return options...Loop number 2...
    $seriesData = array();
    foreach($uniquePatterns as $up){
    	//Filter the data for all rows with this pattern:
    	$thisData = array();
    	for($i=0;$i<count($rows);$i++){
    		if($rows[$i]['pdesc'] == $up){
    			$thisData[] = array(strtotime($rows[$i][0])*1000,$lambda*(double)(number_format($rows[$i][3],4)));
    		}	
    	}
    	
    	$seriesData[]=array('name' => $up,
    					    'data' => $thisData
    						);
    	
    }
    //Adjust the radioDate to the earliest date found.
    $radioDate = $rows[0][0];
    $jsCharts=array();
    
    $jsCharts[]=array(
		'chartOptions'=>array(
			'rangeSelector'=>array('selected'=>4),
		 	'title'=>array('text'=>"$title For $deptName"),
		 	'yAxis'=>array('title'=>array('text'=>$yAxis)),
		 	'credits'=>mxrAS_HCGetCredits(),
		 	'exporting'=>mxrAS_HCGetExporting(),
		 	'legend'=>array('enabled'=>true,'layout'=> 'horizontal')
            ),
		 'chartData'=>$seriesData
		);
	
	return $jsCharts;
	
}
?>