//Setup the mxrAS Javascript Functions and Event Handlers.

//Register Event Handlers.
jQuery(document).ready(function () { 
    //We need to use a global variable
	window.mxrAS_Global_add2WL = "";
	
	//Main functions
	mxrAS_setUpJS(); 
});

//Set Up Functions.
function mxrAS_setUpJS(){

	//Hide all class hidden
	jQuery('.hidden').hide();
	
	//Any tabs we'll set up too...
	jQuery('.mxrAS_tabs').tabs();
	
	//Radios -  Will pop the stream choice 
	jQuery('.mxrAS_radioButtons').buttonset();
	//Select the first button with a click...
	jQuery('.mxrAS_radioButtons').each(function(){
		jQuery('input[type=radio]:first', this).click(); 
	});
	
	
	//Stream choice show/hide event - on some things we need to hide...
	jQuery('.mxrAS_noPS').hide(); //We will always show the views...
	jQuery("input[name='mxrAS_streamChoiceRadio']:radio").change(function(){
		if(jQuery('#mxrAS_streamChoiceRadio-2').attr('checked')){
			//Looking at views
			jQuery('.mxrAS_noPS').show();
		} else {
			jQuery('.mxrAS_noPS').hide();
		}
	});

	//Date picker initialise and set all dates to key values in their value box...
	jQuery('input.mxrAS_dateRange').datepicker({
    	changeMonth: true,
      	changeYear: true,
      	dateFormat:'yy-mm-dd',
        beforeShowDay: mxrAS_populateCalendar
    }).filter('.mxrAS_today').datepicker("setDate",new Date());
	
	//Populate the drop downs - do after the above as data not in yet...
	jQuery('span.mxrAS_dropDown').each(mxrAS_loadStreamDropDown);
	
	
	//White labelled buttons and controls need the CMD putting to something real. 
	var myH = jQuery('#mxrAS_title');
	var cmd = myH.attr('mxrAS_cmd');
	jQuery('.mxrAS_CMD').each(function(){
		var t = jQuery(this);
		
		//Alter the id
		var q = t.attr('id').split('mxrAS_CMD');
		t.attr('id', cmd + q[1]);
		
		//If it has the URL attr then change it
		var url = t.attr('mxrAS_ajaxURL');
		if (typeof url !== 'undefined' && url !== false){
			t.attr('mxrAS_ajaxURL', cmd);
		}
	});

    jQuery('button').button();
	mxrAS_setUpButtonClicks();


    //We set up element clicks in performance tables.
    jQuery('body').on("click",'td.mxrAS_tot', mxrAS_setTDClicks);
    //Sets up the Y or R postscript to handle new positions in WLT...
    jQuery('body').on("change", 'input.mxrAS_wPosVal', mxrAS_checkWatchInput);

	jQuery('ul.mxrAS_streamList').on("click",'.mxrAS_remStreamLink', mxrAS_remStreamClick);
		
	//Register Radio Button Changes
	jQuery('input[type=radio]').change(mxrAS_radioChange);
	
	//Wire up the onchange event for parent class dropdowns.
	jQuery('body').on('change','.mxrAS_parentDropDown > select', mxrAS_parentDDChange);
    jQuery('body').on('stopFormChange','.mxrAS_parentDropDown > select', function(event, secIDVal){

        var ddName = jQuery(this).parent('span.mxrAS_dropDown').attr('mxrAS_childDD');
        mxrAS_getAjaxPost(jQuery('#'+ ddName), false, {"secID" : secIDVal });
        //Now adjust the child to have the new id.
        //var idArr= me.attr('id').split(tok1);
        //jQuery('#' + tok2 + idArr[1]).val(secID*1);//.change();
    });
	
	//Make resizeable objects - well resizable
	jQuery('.resizable').resizable();

    //Multiple choice boxes "pickLists"
	//jQuery('#mxrAS_StreamList').pickList();
	
	//Which controls to show on choices widget.
	mxrAS_showWidgetControls(myH,'#mxrAS_choiceArea','mxrAS_wshow');
}


/*****************************************
** Main JS Library						**
******************************************/

//JS Library Functions For Control Events
//Button Clicks

function mxrAS_setTDClicksOld(e){
  //Grab the id which gives us a class that we need for the performance row....
    var id = jQuery(this).attr('id');
    var ss = id.split("_");
    var d = "mxrAS_att_" + ss[2];//gets the date part

    //Create the table data...
    var thisAtt = "<table id='mxrAS_mBreakout'><thead><tr><th>Instrument</th><th>% Performance</th></tr></thead><tbody>";

    //Now go grab the data from the attribution table that corresponds to this class...
    var myElement = jQuery("#mxrAS_monthlyAtt");


    var prefix = "% Performance Breakout For " + ss[2] ;
    myElement.html("Was clicked");
    jQuery('table td.' + d).each(function(index){
        var me = jQuery(this);
        var instrument = me.attr("mxrAS_name");

        var val = me.text();

        if (instrument == "x"){
            prefix =  val + prefix;
        }
        if (val!="0.000" && instrument !="x") {
            thisAtt += "<tr><th>" + instrument + "</th><td>" + val*1.0 + "</td></tr>";
        }
    });
    thisAtt += "</tbody></table>";

    jQuery("#mxrAS_monthlyAtt").html(thisAtt);
    //jQuery("#mxrAS_monthlyAttTitle").html(prefix);

    mxrAS_buildAttChart("#mxrAS_monthlyAttChart","mxrAS_mBreakout",prefix);
}
function mxrAS_sorter(a,b){
    if(a[1]==b[1]) return 0;
    return a[1]>b[1] ? 1:-1;
}
function mxrAS_setTDClicks(e){

    jQuery('#mxrAS_monthlyAtt').show();
    var attID = "mxrAS_name";

    //Grab the id which gives us a class that we need for the performance row....
    var ss = jQuery(this).attr('id').split("_");
    var d = "mxrAS_att_" + ss[2];//gets the date part

    var prefix = "% Performance Breakout For " + ss[2] ;


    //Pick the data off the tabulated data
    var myArray = [];
    jQuery('table td.' + d).each(function(index){
        var me = jQuery(this);

        if (me.attr(attID)!="x" && me.text()!="0.000") {
            myArray.push([me.attr(attID), me.text() * 1.0]);
        } else if(me.attr(attID)=="x"){
            prefix =  me.text() + prefix;
        }

    });

    //Quick sort of the data...
    myArray.sort(mxrAS_sorter);

    //repurpose the data...
    var xValsData = [];
    var seriesData = [];
    jQuery.each(myArray,function(i,v){
        xValsData.push(v[0]);
        seriesData.push(v[1]);
    });

    //Create the table data...
    Highcharts.chart('mxrAS_monthlyAttChart',{
        chart: {
            type:'column'
        },
        title: {
            text: prefix
        },
        yAxis: {
            title: {
                text: "% Performance"
            }
        },
        xAxis: {
            categories: xValsData
        },
        series: [{
            name: 'Breakout',
            data: seriesData
        }]

    });

}

function mxrAS_buttonClick(e){
    var me=jQuery(this);

    //First we click any preAjaxButtons.
    jQuery('.preAjaxClicks').each(function(){
        jQuery(this).click();
    });

	mxrAS_getAjaxPost(me,true);

    //Check if the button wants to hide anything afterwards.
    //We show probably allow all buttons to do this...

    //mxrAS_hideShowElementsCleanUp(me, 'mxrAS_showParams', 'mxrAS_hideParams');
}

// Set up button clicks
function mxrAS_setUpButtonClicks(){
//Register Button Clicks
	//Dynamic
    jQuery('body').on('click','button.mxrAS_ajaxlinks', mxrAS_AjaxLinkClick);

    jQuery('body').on('click','a.mxrAS_deleteStopInstrument', mxrAS_deleteStopInstrument);

    //Static
    jQuery('.mxrAS_updateButton').click(mxrAS_buttonClick);
	
	jQuery('.mxrAS_linkButton').click(mxrAS_linkButtonClick);
		
	jQuery('.mxrAS_showButton').click(mxrAS_showButtonClick);
		
	jQuery('.mxrAS_addStratButton').click(mxrAS_addStratButtonClick);
		
	jQuery('.mxrAS_clearButton').click(mxrAS_clearButtonClick);
		
	jQuery('.mxrAS_clearListButton').click(mxrAS_clearListButtonClick);
	
	jQuery('.mxrAS_addStreamButton').click(mxrAS_addStreamClick);

    jQuery('.mxrAS_addStopButton').click(mxrAS_addStopClick);

    jQuery('.mxrAS_addStopInstrument').click(mxrAS_addStopInstrument);

    jQuery('.mxrAS_cancelStopButton').click(mxrAS_cancelStop);

    jQuery('.mxrAS_hidemydiv').click(mxrAS_hidemydiv);

   }

//ShowButton Clicks
function mxrAS_hidemydiv(e){
    jQuery(this).parent().hide();
}

function mxrAS_showButtonClick(e){
	//Overrides a href - 
	if(e.preventDefault){
		e.preventDefault();
	} else {
		event.returnValue = false;
	}
	var me = jQuery(this);
	
	//These buttons often have to cancel another...
	cancelBut = me.attr('mxrAS_clear');
	if(cancelBut!="N"){
		jQuery('#'+cancelBut).click();
	};
	
	//Grab the params to show...
    jQuery('#'+me.attr('mxrAS_hideParams')).hide();
    jQuery('#'+me.attr('mxrAS_params')).show();

}


function mxrAS_cancelStop(e){
    //Remove the added instruments and reset the number of instruments to 1.
    var divIDName = jQuery(this).attr('mxrAS_stopDiv').split(" ");
    var divID = jQuery('#' + divIDName[0]).attr('mxrAS_nSec',"1");

    if (divIDName.length>1){
        for(var n = 1;n<=divIDName.length; n++){
            jQuery('#' + divIDName[n]).show();
        }
    }

    jQuery('.mxrAS_stopExtras').remove();

    //Hide the form
    divID.hide();

    //If we cancelled then we change the name of the addButton to add (in case it was update).
    mxrAS_changeAddStopbuttonText(false);

}

function mxrAS_changeAddStopbuttonText(updateFlag, stopid, triggeredText, filltype){

    var titleText = 'Create New Stop';
    var butText = 'Add Stop';
    var hideSelector = '#mxrAS_addStop, #mxrAS_addStopInstrument';

    //Hides edit buttons for triggered stops.
    if (triggeredText=='Triggered'){
        //We don't show the add/update buttons(only the cancel).
        jQuery(hideSelector).hide();
    } else {
        jQuery(hideSelector).show();
    }

    //assign a 0 to the stop_id...
    if (typeof(stopid) == undefined){
        stopid=0;
    }

    if (typeof(updateFlag) !== undefined){
        if (updateFlag) {
            butText = 'Update Stop';
            titleText = 'View Existing Stop - ' + triggeredText;
        }
    }

    var button = jQuery('#mxrAS_addStop');
    button.text(butText);
    button.attr('mxrAS_XP','b-add2StopL stop_id-' + stopid);

    jQuery('#mxrAS_stopTitle').html(titleText);

    //We also wish to set the 'Stop/Limit' option.
    var filltypeButton = jQuery('input:radio[name=mxrAS_StopLimitRadio]');

    if(typeof (filltype) === undefined){
        filltype=1;
    }

    var idRadio = filltype == 1 ? '#mxrAS_StopLimitRadio-1':'#mxrAS_StopLimitRadio-2';
    jQuery(idRadio).prop("checked",true).change();
}

function mxrAS_addStopClick(e){
    //So we want to show a form of data and add the stop.
    //So the add just shows a div.
    var thisEle = jQuery(this);
    var formDiv = thisEle.attr('mxrAS_params').split(" ");

    //Just before we show it
    if (formDiv.length==1){
        jQuery('#' + formDiv).show();
    }
    else {
        jQuery('#' + formDiv[0]).show();
        for (var n = 1; n<=formDiv.length; n++){
            jQuery('#' + formDiv[n]).hide();
        }
    }

}

function mxrAS_addStopInstrument(e){
    //So we have to do several things.
    //First grab a couple of useful DOM elements.
    //var divIDName = jQuery(this).attr('mxrAS_stopDiv');
    var divID = jQuery('#mxrAS_addStopDiv');// + divIDName);

    //1 - how many instruments in our list?
    var nsecs = parseInt(divID.attr('mxrAS_nsec'))+1;
    //nSecs = parseInt(nSecs)+1;

    //2 - we must add a line to the form.
    //We can do this as we set up the HTML to have a few divs of class mxrAS_stopFirst
    //Lets grab them and work on each one...
    jQuery("div.mxrAS_ss_1").each(function (index){
        var me = jQuery(this);
        var divHtml = me.html().split("_1").join("_" + nsecs.toString());

        //Add this to the end of the this...
        me.parent().append("<div class='mxrAS_stopExtras mxrAS_ss_" + nsecs.toString() + "'>" + divHtml + "</div>");
    });

    //So we just added a button and need to jQuery-fy it.
    jQuery("div.mxrAS_stopExtras > button").button();

    //Update the latest security number
    divID.attr('mxrAS_nsec', nsecs.toString());
}

function mxrAS_deleteStopInstrument(e){

    if(e.preventDefault()){
        e.preventDefault();
    } else {
        event.returnValue = false;
    }
    var ssClass = 'mxrAS_ss_';
    var nSecID = 'mxrAS_nsec';

    //So we drop the row we dealing with - easy.
    //But wait! We need to check if we delete the master row. If that's the case we need to do two things.
    var me = jQuery(this);

    //Grab all elements with the class mxrAS_x
    var myIDArray = me.attr('id').split('_');
    var myIndex = parseInt(myIDArray[2]);

    //var divIDName = me.attr('mxrAS_params');
    var maxSecDiv = jQuery('#mxrAS_addStopDiv');
    var maxSecs = parseInt(maxSecDiv.attr(nSecID));

    //First delete everything that's connected to the button.
    if(maxSecs > 1){
        jQuery("." + ssClass + myIndex.toString()).remove();

        //Now reduce the _x indices by 1 that are higher than _x
        for(var i = (myIndex + 1); i <= maxSecs; i++){
            //Reduce the ids _x to _x-1
            jQuery("div." + ssClass + i.toString()).each(function(){
                var me2 = jQuery(this)
                me2.html( me2.html().split('_' + i.toString()).join('_' + (i-1)));

                //So we do this but the div.class needs updating
                me2.removeClass(ssClass + i.toString());
                me2.addClass(ssClass + (i-1).toString());

            });
        }

        //Update the maxSecs (only here as we removed a security).
        maxSecDiv.attr(nSecID, (maxSecs-1).toString());
    } else {
        //We want to delete _1 and it's the only one so we clear it
        jQuery('div.' + ssClass + '1 > input').val("");
    }
}

function mxrAS_AjaxLinkClick(e){
    if(e.preventDefault()){
        e.preventDefault();
    } else {
        event.returnValue = false;
    }

    //So we click an AjaxLink - part of it's params is the URL to follow and an a set of params.
    var me = jQuery(this);
    mxrAS_getAjaxPost(me, false);

    //HideShowStuff...
    jQuery('#' + me.attr('mxrAS_hideParams')).hide();
    jQuery('#' + me.attr('mxrAS_showParams')).show();
}

//Put special dates in the calendar tools.
function mxrAS_populateCalendar(date){
    //So depending on what we do....We'll know from the page what the calendar is supposed to do...

    //So we need to figure out how the dates to populate got here...
    var specialDates = ['2012-06-12', '2012-06-26', '2012-10-20', '2012-07-10', '2012-02-10'];
    var chkDate = jQuery.datepicker.formatDate('yy-mm-dd',date);

    if(jQuery.inArray(chkDate, specialDates) != -1){
        return [true, 'dateHighlighted', 'Traded'];
    }
    return [true, ''];
}

//Clear UL list
function mxrAS_clearListButtonClick(e){
	if(e.preventDefault){
		e.preventDefault();
	} else {
		event.returnValue = false;
	}
	
	//Clear html of params
	var obj2Clear = jQuery('#mxrAS_' + jQuery(this).attr('mxrAS_params'));
	obj2Clear.attr('mxrAS_IDs',"");
	obj2Clear.html("");
	
	//hide XP - only one for now...
	jQuery('#mxrAS_' + jQuery(this).attr('mxrAS_XP')).hide();

}

//Clear Button Click
function mxrAS_clearButtonClick(e){
	if(e.preventDefault){
		e.preventDefault();
	} else {
		event.returnValue = false;
	}
	
	var me = jQuery(this);
	
	//Pick up the emelemets we need to handle.
	var p2Hide = me.attr('mxrAS_params');
	
	z = me.attr('mxrAS_XP').split(" ");
	
	if(z.length>0){
		clearClass = z[0];
		
		if(z.length>1){
			sNameDiv = jQuery('#'+z[1]);
		} else {
			sNameDiv = "";
		}
		
		mxrAS_clearThisWatchDiv(jQuery("#" + p2Hide),clearClass,sNameDiv);
	} else {
		mxrAS_clearThisWatchDiv(jQuery("#" + p2Hide),"","");
	}
	
	var p2Show = me.attr('mxrAS_hideParams');
	jQuery('#'+ p2Show).show();
}

function mxrAS_hideShowElementsCleanUp(domEle, showAtt, hideAtt){
    var hp = domEle.attr(hideAtt);
    jQuery('#' + hp).hide();

    var sp = domEle.attr(showAtt);
    jQuery('#' + sp).show();
}

//This is a link Button
function mxrAS_linkButtonClick(e){
	//Overrides a href - 
	if(e.preventDefault){
		e.preventDefault();
	} else {
		event.returnValue = false;
	}
	var me = jQuery(this);
	alert ("alphaselect.marketxray.net/" + me.attr('mxrAS_href'));
	
	//So we need the location param and go there...
	window.location.href = "http://alphaselect.marketxray.net/" + me.attr('mxrAS_href');
	
}

//Add a strat on WLT
function mxrAS_addStratButtonClick(e){
//Overrides a href - 
	if(e.preventDefault){
		e.preventDefault();
	} else {
		event.returnValue = false;
	}
	var me = jQuery(this);

	//So we need to copy the existing boxes from the page and put into new boxes in the <div "mxrAS_addSecDiv"></div>
	/*In the post we have an addSecDiv with wPos-x and mxrAS_secIDListWrapper-x
	in the latter we can go off and populate from DB or rename the html to what we want before we insert...*/
	
	var mySecDiv = jQuery('#mxrAS_addSecDiv');
	var wCount = parseInt(mySecDiv.attr('mxrAS_nWatch'))+1;
	mySecDiv.attr('mxrAS_nWatch', wCount.toString());
	
	//We assign the tempWatchField class so we can remove them later easily...
	
	//Add a circle to denote the new position.
	jQuery('#mxrAS_wrapperA').append("<p><span class='mxrAS_tempWatchField'><strong>" + wCount + "</strong></span></p>");
	
	//Copy Dropdown Box...Renaming on the way.
    var appendArr = ['B', 'C', 'D'];
    for(var i=0;i<appendArr.length;i++){
        var newSecDiv = jQuery('#mxrAS_p' + appendArr[i]).html().split("_1").join("_" + wCount);
        jQuery('#mxrAS_wrapper' + appendArr[i]).append("<p class='mxrAS_tempWatchField'>" + newSecDiv + "</p>");
    }

    //So we need to add code that sets the drop down
    jQuery('#mxrAS_atypeList_' + wCount).change();
}
//Add a stream on the Correlation Page
function mxrAS_addStreamClick(e){
	//We need to pull in some data from the list box and then to determine what it was...
	var myElem = jQuery(this);
	var streamInfo = mxrAS_passParamsFromElement(myElem);
	var valsInfo = mxrAS_passParamsFromElement(myElem,true);
	
	//Add the list item.
	var ID = streamInfo['streamChoiceRadio'] + "_" + streamInfo['streamListWrapper'];
	
	//Quickly check if the list already has this ID...
	var outputUL = jQuery('#' + streamInfo['xOut'] + ' ul');
	
	var idList = outputUL.attr('mxrAS_IDs').split(" ");
	
	//indexOf not supported in IE<9
	if(jQuery.inArray(ID,idList)==-1){
	//if(idList.indexOf(ID)==-1){
	
		var delLinkText = "";//"<a class='mxrAS_remStreamLink' href=''>Delete</a>";
		var outputUL = jQuery('#' + streamInfo['xOut'] + ' ul');
		outputUL.append("<li id='" + ID + "'><b>" + valsInfo['streamChoiceRadio'] + "</b> - " + valsInfo['streamListWrapper'] + " " + delLinkText + "</li>");
		idList.push(ID);
		outputUL.attr('mxrAS_IDs',idList.join(" "));
		
		if(idList.length>2){
			jQuery('#mxrAS_SCM_buildCovMat').show();
		}
	} else {
		jQuery('#mxrAS_noDuplicateInList').fadeIn(1000).fadeOut(3000);
	}
}

function mxrAS_remStreamClick(e){
	//Overrides a href - 
	if(e.preventDefault){
		e.preventDefault();
	} else {
		event.returnValue = false;
	}
}

//Radio Button Changes
function mxrAS_radioChange(e){
	var myElem = jQuery(this);
	
	switch (myElem.attr('mxrAS_type')){
		case 'viewChoiceRadio':	
			//toggle the atype div
			
			break;
		case 'streamChoiceRadio':
			//Find all the span tags that are dropDowns AND have a param that is equal to this case.
			//If we change to instruments we show the types stream else hide it...
			//jQuery('#mxrAS_atypediv').toggle();
			if(myElem.val()==4){
				jQuery('#mxrAS_atypediv').show();
			} else {
				jQuery('#mxrAS_atypediv').hide();
			}
			jQuery("span.mxrAS_dropDown[mxrAS_params*='streamChoiceRadio']").each(mxrAS_loadStreamDropDown);
			break;
		
		case 'EXPEXARadio':
			//Change the title to say Ex-Post or Ex-Ante
			var pre = myElem.next().text();
			jQuery("#mxrAS_title").html(pre + " Alpha Stream Correlations");
			break;
		default:
			//alert('The radio selection for type ' + myElem.attr('mxrAS_type') + ' is not handled yet.');
			//console.log("default",this);
		}
}

//Parent Drop Down box changes
function mxrAS_parentDDChange(e){
	//So we pick up this param that tells us the child DD name 
	//We then reload that dropDown that should be back wired to this box param. 
	//In the DOM it's the span parent of the select we just changed that has the attribute.

	var ddName = jQuery(this).parent('span.mxrAS_dropDown').attr('mxrAS_childDD');

    jQuery('#' + ddName).each(mxrAS_loadStreamDropDown);
}


//Handle Ajax Params and Request
function mxrAS_getAjaxPost(domEle,showLoading, additionalObj){
	var ajaxData = mxrAS_passParamsFromElement(domEle);

    if(typeof (additionalObj) != "undefined"){
        for( var aName in additionalObj){
            ajaxData[aName] = additionalObj[aName];
        }
    }

    var me = jQuery(domEle);
    if(me.hasAttr('mxrAS_ajaxToggler')){

        ajaxToggler = jQuery(domEle).attr('mxrAS_ajaxToggler').split(" ");

    } else {
        ajaxToggler = "";
    }

    mxrAS_ajaxHandler(domEle, ajaxData, showLoading, ajaxToggler);
}

//Drop Down Reloads
function mxrAS_loadStreamDropDown(e){
	//Run an ajax request to reload the drop down box.
    mxrAS_getAjaxPost(jQuery(this),false);
}

//Library Functions
function mxrAS_destroyTable(tableElement){
	tableElement.dataTable({
    	"bDestroy": true
  	});
  	tableElement.parent('div').html("Retrieving Data...");
	
}

function mxrAS_checkWatchInput(e){
    var me = jQuery(this);
    var posText = me.val().toLowerCase();

    //Duration or Risk?
    var splitText = posText;

    //We rely on a drop down box having the 'correct' attribute and the drop down is tagged to the watch value inputted.
    //the mxrAS_DDTag gives the id of the box we need...
    var myAtt = "";
    var myY = "";
    var updateFlag = false;

    if(posText.indexOf('y') > -1){
        splitText = posText.split('y');
        myAtt = 'duration';
        myY = 'years';
        updateFlag = true;

    } else if (posText.indexOf('r') > -1){
        splitText = posText.split('r');
        myAtt = 'risk';
        myY = '%';
        updateFlag = true;
    }

    if(updateFlag){
        //This is the span tag of the dropdown
        var ddParam = jQuery('#' + me.attr('mxrAS_DDTag') + ' option:selected').attr('mxrAS_' + myAtt);

        //So we pick up the selected item in the child dropdown...
        me.val(mxrAS_returnWatchPos(splitText, ddParam, myAtt, myY));
    }

    return true;

}

function mxrAS_returnWatchPos(splitInputText, riskDuration, myAtt, myY){
    //Assumes you passed the split text and the second param is either the risk or duration.
    var outSF = 2;
    //var splitInputText = posText.toLowerCase().split('y');
    var inputWeight = parseFloat(splitInputText[0]);

    var riskDurSF = 0.01;
    var newVal = (inputWeight / (riskDurSF*riskDuration)).toFixed(outSF);

    alert (mxrAS_buildWatchCallBackAlertMsg(0, inputWeight, newVal, newVal, riskDuration, myAtt, myY))
    // ('Convert ' + myAtt + ' of ' + inputWeight + ' to % weight.\nUse ' + myAtt + ' : ' + riskDuration + '\nConverts to : ' + newVal + '% Watch Position.');
    return newVal;

}
//Should be different types of table...starting to get messy...
function mxrAS_addEditCallBacks(tableElement, criteria, nsf, cvCheck){

		//This function is called to add editable cells to the table. 
		//We add editable fields on those selectors determined by criteria.
		tableElement.find(criteria).editable(function(sValue){

            //Which cell did we click on and edit?
			var thisTD = jQuery(this);

			//Where is it in the table?
			var rcIDArray = thisTD.attr('id').split("C");
		    var cValue = parseInt(rcIDArray[1]); //the col number

            //Set up some useful variables that we can reuse in the position calculations.
            var destOffset = (cValue==cvCheck) ? 1:2;

		    //TODO there are now 4 possible cases: edit the position directly cValue = 4, or the effective trade (5) or we have input a duration with a y or Y suffix...

            //Check on whether a duration or risk was entered. That is - did we add a duration like 0.25y or 0.25Y?

            var splitInputText = sValue.toLowerCase().split('y');
            var yFlagObj = mxrAS_setCallBackRiskDurObject(splitInputText.length > 1, 'y');

            if (!yFlagObj.yFlag){
                splitInputText = sValue.toLowerCase().split('r');
                yFlagObj = mxrAS_setCallBackRiskDurObject(splitInputText.length > 1, 'r');
            }

            //var yFlag = (splitInputText.length > 1);

            //Either way the input value weight is the first element of the array.
            var inputWeight = parseFloat(splitInputText[0]);

            //The duration to use - if we edited the watch we need 2 along, else 1 along.
            //var durSF = (yFlag) ? 0.01 : 1;

            //The currentPos and newWeight
            var currentPos = parseFloat(jQuery(thisTD).prevAll().eq(destOffset - 1).text());

            var durationRisk  = (yFlagObj.yFlag) ?  parseFloat(jQuery(thisTD).nextAll().eq(yFlagObj.offset - destOffset).text()) : 1;/// yFlagObj.pSF : 1;

            var reportWeight = inputWeight/(yFlagObj.durSF*durationRisk);

            /*
            var repDuration = parseFloat(jQuery(thisTD).nextAll().eq(2 - destOffset).text());
            var reportWeight = mxrAS_returnWatchPos(sValue, repDuration);
            */


            //What's the new weight for the table?
            var newWeight = reportWeight + (currentPos * (cValue==cvCheck ? -1:1));

		    //Insert into the new cell as determined by the destOffset.
		    if (destOffset == 1){
		    	jQuery(thisTD).next().text(newWeight.toFixed(nsf));
		    } else {
		    	jQuery(thisTD).prev().text(newWeight.toFixed(nsf));
		    }
		    
		    jQuery(this).closest('tr').addClass('mxrAS_updated');


            if (yFlagObj.yFlag){
                alert (mxrAS_buildWatchCallBackAlertMsg(destOffset, inputWeight, newWeight.toFixed(nsf), (reportWeight).toFixed(nsf).toString(), durationRisk.toFixed(nsf), yFlagObj.dname, yFlagObj.unit));
            }

            return parseFloat(reportWeight).toFixed(nsf).toString();
			},{
			submit: "OK",
			cancel: "Cancel",
			tooltip: "Click to edit add y to express duration..."
		});
}

function mxrAS_setCallBackRiskDurObject(flag, myChar){
    var obj = {
        yFlag: false,
        durSF: 1,
        offset: 0,
        pSF : 1
    };

    if (flag){

        switch (myChar){
            case 'r':
                obj =  {
                    yFlag: true,
                    durSF: 0.01,
                    offset:3,
                    dname:'risk',
                    unit: '%',
                    pSF: 0

                };
            break;

            default:
                obj = {
                    yFlag: true,
                    durSF: 0.01,
                    offset: 2,
                    dname:'duration',
                    unit:'years',
                    pSF: 1
                }
        }
    }

    return obj;
}

function mxrAS_buildWatchCallBackAlertMsg(dOff, inputW, newW, reportW, dIn, typeW, typeY){
    var watchText1 = "Final Watch Position : ";
    var watchText2 = "Effective Trade Position : ";

    if (dOff == 1) {
        var temp = watchText2;
        watchText2 = watchText1;
        watchText1 = temp;
    }

    return  "Desired " + typeW + " exposure : " + inputW + " " + typeY + ".\nIndex " + typeW + " : " + dIn + " " + typeY + ".\n" + watchText1 + newW + "%\n" + watchText2 + reportW + "%";
}

function mxrAS_checkCalendar(calID, chkDate,infoSelector,preMsg){
	var cal = jQuery(calID);
	var info = jQuery(infoSelector);
	
	if (chkDate != cal.val()){
		info.html(preMsg+"Requested " + cal.val() + " but using data from " + chkDate + " as the closest date.");
		//cal.val(chkDate);
	} else {
		info.html(preMsg+"Found data for " +  cal.val());
	}
	
	info.removeClass('hidden');
}

function mxrAS_ajaxHandler(outputElem, ajaxData, showLoading, ajaxToggler){

    var myBody = jQuery('body');   	
	//Output Info Msg
	//get the phpUrl request which returns a JSON object
	if (ajaxData.action !=""){
		jQuery.ajax({
		type:"post",
		dataType: "json",
		url: mxrAS_Ajax.ajaxurl,
		
		//Show a gif for loading...
		beforeSend: function(){

            jQuery('.kptemp').hide();
			if(showLoading) myBody.addClass("mxrAS_isLoading");

		},
		
		data: ajaxData,
		
		success: function(response){
			//Unhide the gif after ...

			if (showLoading) myBody.removeClass("mxrAS_isLoading");

            if (ajaxToggler!="") {
                jQuery.each(ajaxToggler, function (i, v) {
                    jQuery('#' + v).toggle();
                });
            }

			var infoMsg="#mxrAS_infoMsg";
			var snapShotDOM = "input[name='mxrAS_snapshotDate']";

            //OK there is a meta tag that appends to the title.
            if(response.meta!==undefined){
                if (response.meta.rationaleMsg!==undefined){
                    jQuery('#mxrAS_rationaleMsg').html(response.meta.rationaleMsg);
                }

                if(response.meta.hasOwnProperty("titleAppend")){
			        var titleText = jQuery('#mxrAS_title').html().split(" :");
					jQuery('#mxrAS_title').html(titleText[0] + " : " + response.meta.titleAppend);
				}

                //Any other Message
                if(response.meta.hasOwnProperty("otherMsg")){
                    jQuery('#mxrAS_otherMsg').html(response.meta.otherMsg);
                }

				//We build several switches and then job out the response to figure out what to do...
				switch(response.meta.controlType){

			    case "chart":
				    mxrAS_ajaxChart(response, ajaxData.action);
                    mxrAS_checkCalendar(snapShotDOM, response.meta.passedParams.snapshotDate, infoMsg, response.meta.preMsg);
                    break;
					
                case "dropdown":
                    mxrAS_popDropDown(outputElem, response.dropDown);
                    if(ajaxData.hasOwnProperty("secID")){
                        //Then we set the dropdown with the value in secID
                        jQuery('#' + response.meta.passedParams.ddName).val(ajaxData.secID);
                    }
					if (response.meta.passedParams.streamChoiceRadio==4){
					    jQuery('#' + response.meta.passedParams.ddName + 'Wrapper').show();
					}
					break;

                case "chart_multiPaneStock" :
                    //Currently used for HPOS but we build for a Hi-Stock chart but the ouput here is a multipanel high stock chart.
                    mxrAS_ajaxChart(response, ajaxData.action);
                    break;

				case "chart_table" :
				    //TODO May 2014 - we should fix this up to use chart_tableArray
					//First step build the ajaxChart...

					mxrAS_ajaxChart(response, ajaxData.action);

					//We should check if we had 2 tables...
					mxrAS_summaryTable(response);
					mxrAS_gridBuilder(response);

					break;

                case "chart_tableArray" :
				    //Build our chart
				    mxrAS_ajaxChart(response, ajaxData.action);
                    //Falls through to the tableArray...

                case "tableArray" :
                    //The tables are in an array and should be extracted that way.
                    mxrAS_tableArray(response);
                    break;

                case "stopUpdateForm" :
                    //Populate the 'addStop' details form with all the server data.
                    //This is where we must also send back a stop ID - we must reset the stop id to 0 on a cancel...or after update.
                    mxrAS_fillInStopUpdateForm(response.data);

                    //Then show the form.
                    jQuery('#mxrAS_LSTP_addStopButton').click();
                    break;

                case "error" :
				    jQuery('#mxrAS_error').html(response.meta.preMsg);
                    break;
							
        		case "covMatrix":
        			jQuery('#' + response.table.ID).html(response.table.dataTable);
                    break;
        			
        		case "message":
                    jQuery(infoMsg).html(response.meta.preMsg);
                    //Anything to remove?
                    jQuery('#' + response.meta.clear).html("");
        			break;

                case "DASHBOARD":
                    jQuery(infoMsg).html(response.meta.preMsg);
                    //So we have a number of objects to display...
                    mxrAS_addTables(response.TRSUM);
                    mxrAS_ajaxChart(response.CPOS, 'mxrAS_CPOS');
                    mxrAS_tableArray(response.STOP);

                    mxrAS_ajaxChart(response.PSAT, 'mxrAS_PSAT');
                    mxrAS_tableArray(response.PSAT);

                    break;

                default:
				    //alert('controlType');
                }
            }
        }
        });
    }

}

function mxrAS_chartTable(myResponse,myAction){
    mxrAS_ajaxChart(myResponse, myAction);

    //We should check if we had 2 tables...
    mxrAS_summaryTable(myResponse);
    mxrAS_gridBuilder(myResponse);
}

function mxrAS_gridBuilder(myResponse){
    if(myResponse.table.hasGrid){
        jQuery('#' + myResponse.table.tGrid.divID).html("<h4>Monthly % Performance Grid for " + myResponse.table.mName + "</h4>" + myResponse.table.tGrid.data);
        var oTable = jQuery('#' + myResponse.table.tGrid.tDOM).dataTable({
            "bJQueryUI": false,
            "sScrollY":"600px",
            "bPaginate": false,
            "bFilter": false,
            "bInfo" : false,
            "bSort": false,
            "sDom": 'Tlfrtip',
            "oTableTools":{"sSwfPath":"http://www.alphaselect.net/wp-content/plugins/mxrAlphaSelect/includes/js/DataTables-1.10.7/extras/extensions/TableTools/swf/copy_csv_xls_pdf.swf"}
        });
    }
}

function mxrAS_summaryTable(myResponse){
    if(myResponse.table.hasSummary) {
        jQuery('#' + myResponse.table.tHtml.divID).html("<h4>Summary for " + myResponse.table.mName + "</h4>" + myResponse.table.tHtml.data);

        var oTable = jQuery('#' + myResponse.table.tHtml.tDOM).dataTable({
            "bJQueryUI": false,
            "bPaginate": false,
            "bFilter": false,
            "bInfo": false,
            "bSort": false,
            "sDom": 'T<"clear">lfrtip',
            "oTableTools": {"sSwfPath": "www.alphaselect.net/wp-content/plugins/mxrAlphaSelect/includes/js/DataTables-1.10.7/extensions/TableTools/swf/copy_csv_xls_pdf.swf"}
        });
    }
}

function mxrAS_tableArray(myResponse){
    //Append tMsg to the title
    if (typeof myResponse.tMsg !== 'undefined'){
        if(myResponse.tMsg.length>0) {

            //remove any preexisting title.
            jQuery('#mxrAS_tMsg,#mxrAS_fhclogo').remove();

            //Add the new title.
            var t = jQuery('h1.entry-title');
            t.prepend("<img id='mxrAS_fhclogo' src='http://alphaselect.marketxray.net/wp-content/uploads/2016/05/FHC-Logo-Main-crop-e1463770875121.png' alt='Logo'/><br>");
            t.append("<h2 id='mxrAS_tMsg'>" + myResponse.tMsg + "</h2>");
            jQuery('#mxrAS_title').html("");
        }
    }

    if(typeof myResponse.cDetails !== 'undefined'){
        //We assume if we have a comment then we have the other things.
        if (myResponse.cDetails.useMe) {
            jQuery('#mxrAS_FHCPmonthlycomment_id').html('"' + myResponse.cDetails.managerComment + '"' + " - <strong>" + myResponse.cDetails.pmName + "</strong>");
            //About the fund
            jQuery('#mxrAS_FHCPaboutTitle').html("<h2>" + myResponse.cDetails.pName + "</h2><h3>Fund Inception : " + myResponse.cDetails.inceptionDate + "</h3>");
            jQuery('#mxrAS_FHCPaboutfund').html("<p>" + myResponse.cDetails.invObjectivesShort + "</p>");
            jQuery('#mxrAS_FHCPmoreonfund').html(myResponse.cDetails.invObjectivesLong);

            //Fees
            jQuery('#mxrAS_FHCPfeeSchedule').html(myResponse.cDetails.fees);

            //About the pm
            jQuery('#mxrAS_FHCPpmpik').html(myResponse.cDetails.webPik);
            jQuery('#mxrAS_FHCPpmbio').html("<h3>" + myResponse.cDetails.pmName + "</h3><strong>" + myResponse.cDetails.pmTitle + "</strong><p>" + myResponse.cDetails.pmBio + "</p>");
            jQuery('#mxrAS_FHCPfeeSchedule').html("<h3>Fund Fee Schedule: </h3>" + myResponse.cDetails.feeSchedule);


        }
    }

    for(var i=0; i<myResponse.table.length;i++){
        jQuery('#' + myResponse.table[i].divID).html(myResponse.table[i].msg + myResponse.table[i].data);//Insert the html to build the table into the div with a msg
        jQuery('#' + myResponse.table[i].tDOM).dataTable(myResponse.table[i].dTableParams);//Make the datatable

        //And add the editable fields if necessary
        if(jQuery('#' + myResponse.table[i].tDOM).hasClass('mxrAS_dataTableEdit')){
            //Here we add the edits to the table...
            //It's kind of set up for WLT...
            mxrAS_addEditCallBacks(jQuery('#' + myResponse.table[i].tDOM), 'td:not(.read_only)' , 3, 4);
        }
    }

    if(typeof(myResponse.meta.passedParams.hasStops)!=='undefined'){

        if(myResponse.meta.passedParams.hasStops==1){
            jQuery('#mxrAS_hasActiveStops').show();
        } else {
            jQuery('#mxrAS_hasActiveStops').hide();
        }

    } else {
        jQuery('#mxrAS_hasActiveStops').hide();
    }

    //Kluge job for KP aggregate for EMMA Combine
    if(myResponse.meta.passedParams.streamChoiceRadio*1 == 1 && myResponse.meta.passedParams.streamListWrapper*1 == 18){
        jQuery('.kptemp').show();
        jQuery('#mxrAS_PSATtabs').tabs('option', 'active', 2);
    } else {
        jQuery('.kptemp').hide();
    }

    jQuery('#mxrAS_PSATtabs').tabs('option', 'active', 0);
}

function mxrAS_addTables(myResponse){
    for(var i=0; i<myResponse.table.length;i++){
        jQuery('#' + myResponse.table[i].divID).html(myResponse.table[i].msg + myResponse.table[i].data);//Insert the html to build the table into the div with a msg
        jQuery('#' + myResponse.table[i].tDOM).dataTable(myResponse.table[i].dTableParams);//Make the datatable

        //And add the editable fields if necessary
        if(jQuery('#' + myResponse.table[i].tDOM).hasClass('mxrAS_dataTableEdit')){
            //Here we add the edits to the table...
            //It's kind of set up for WLT...
            mxrAS_addEditCallBacks(jQuery('#' + myResponse.table[i].tDOM), 'td:not(.read_only)' , 3, 4);
        }
    }
}

function mxrAS_StopFormReduceToSingleRow(){
    jQuery('a.mxrAS_deleteStopInstrument').each(function(index){
        //So we keep the first row only.
        var me = jQuery(this);
        if(me.attr('id')!='mxrAS_deleteStopInstrument_1'){
            //We click the delete button.
            me.click();
        }
    });
}

function mxrAS_StopFormHeadlineData(stopData){
    //Then populate the remaining fields.
    var zzLength = 2;
    var zz = [
        ['#mxrAS_rationale', stopData.rationale],
        ['#mxrAS_startdate', stopData.startdate]
    ];

    for (var k=0; k<zzLength; k++){
        jQuery(zz[k][0]).val(zz[k][1]);
    }
}

function mxrAS_fillInStopUpdateForm(stopData){
    //Change the button text.

    mxrAS_changeAddStopbuttonText(true, stopData.stopid, stopData.status, stopData.filltype);

    //So we need to add the first row then figure out what to do.

    var nRows = stopData.add2StopL.length;

    //Perhaps we have too many rows already - let's go back to one row
    mxrAS_StopFormReduceToSingleRow();


    //First job - add all the "blank instruments" we need.
    for (var j=0; j<nRows; j++){
        if(j!=0){
            jQuery('#mxrAS_addStopInstrument').click();
        }

        //So the form has all the elements on screen. (There's no AJAX call as they are copied so they are "there").
        //Our next task is to set the gLike boxes first so let's do that. Then the amounts etc.
        var thisRow = stopData.add2StopL[j];
        //console.log('gL[' + j + ']::' + thisRow.gLike);

        jQuery('#mxrAS_atypeList_' + (j+1)).val(thisRow.gLike).trigger('stopFormChange', thisRow.secID);

        var txtNum = "_" + (j+1);
        jQuery('#mxrAS_stopamount' + txtNum).val(thisRow.sAmt);
        jQuery('#mxrAS_stopprice' + txtNum).val(thisRow.sPrice);

        var pnlTxt = "N/A";
        var fac = 1;
        var lbl = " %";
        var domEle = '#mxrAS_stoppnl' + txtNum;
        var addClass = "";
        if (stopData.status == 'Triggered' && thisRow.adj!=='undefined'){
            if (Math.abs(thisRow.adj)<0.1){
                fac = 100;
                lbl = " bp";
            }
            pnlTxt = (thisRow.adj*fac).toFixed(2).toString() + lbl;
            if (thisRow.adj<0){
                addClass = 'mxrAS_neg';
            }
        }
        if (addClass!=""){
            jQuery(domEle).html(pnlTxt);
        } else {
            jQuery(domEle).addClass(addClass).html(pnlTxt);
        }
    }

    mxrAS_StopFormHeadlineData(stopData);
}

function mxrAS_ajaxChart(response,ajaxDataAction){
	var nCharts = response.meta.nCharts;
	template = '#'+ ajaxDataAction + '_chartContainer';

	//Hide all the class of mxrAS_charts first...we may wish to remove the contents then hide it...
	//Check add security part of code - I've got this done in a generic way...Although think the chart wouldn't 
	//draw to a run time div...
	for(var i=1;i<=5;i++){
		jQuery(template + i.toString()).hide();
	}
	
	// We reference at container1 not 0 hence the indexing in the loop.
	for(var i=1;i<=nCharts;i++){
		//Add the div to the chartContainer area...
		jQuery(template + i.toString()).show();
		mxrAS_buildHighChart(template + i.toString(),response.charts[i-1],response.meta);	
	}

}
//Build a high chart...
function mxrAS_buildHighChart(containerID,chart,meta){
	// This function gets as much of the data pre-packaged 
	// from server to reduce the coding with client. 
	
	//Slightly fudged behaviour if multiple lines
    dd= chart.chartData;
	myObj=chart.chartOptions;
	if (meta.multiSeries==0){
        myObj.series=[];
		myObj.series.push(chart.chartData);
		
	} else {
		myObj.series = chart.chartData;
	}

    // Now we need to decide how to pass myObj...The StockChart way or the HighChart way...
	if(meta.chartType == 'StockChart'){
        //console.log(myObj);
        jQuery(containerID).highcharts('StockChart', myObj);
	} else {
		// We do it the HighCharts, not HighStock way...
		//myObj.chart=meta.chartType;
		jQuery(containerID).highcharts(myObj);
	}
}

//Handle Drop Down Boxes
function mxrAS_popDropDown(ddl, myHtml){
   var preHtml=ddl.html().split('?');

	//Figures out if we need to populate the first time or it's a refresh...
	if(preHtml.length==1){
		preHtml=ddl.html().split('<select');
		if(preHtml.length==1){
			//IE7
			preHtml=ddl.html().split('<SELECT');
		}
        preHtml[1]="";
	}
	
	ddl.html(preHtml[0] + myHtml + preHtml[1]);
}

function mxrAS_passParamsFromElement(myElem,withParamVals){
	
	if (withParamVals===undefined) withParamVals = false;
	
	//We pick up any parameters needed by the control for a possible ajaxCommandRequest. 
	//So the dom element is all the 'coding' we need to wire up the control. 
	//In some controls the attributes are lower-cased as part of the jQuery process. We need to capture this. 
	var attsArray = ['mxrAS_ajaxURL','mxrAS_params','mxrAS_XP']; //XP must be last...
	for (var i=0;i<attsArray.length;i++){
		//var test_attr = myElem.attr(attsArray[i]);
		if(!myElem.hasAttr(attsArray[i])) {
			//Can't find it
			attsArray[i] = attsArray[i].toLowerCase();
		}
	}
	
	//Initialise myData
	var myData = [];
	
	//So attsArray is now lower if couldn't find on first pass.
 	//var ajaxAttr = myElem.attr(attsArray[0]);
 	if (myElem.hasAttr(attsArray[0])) {
    	myData = {action: myElem.attr(attsArray[0])};
	}
	
 	//Complete the other params
 	for(var i=1;i<attsArray.length;i++){
 		//Test if the attribute exists.
 		if (myElem.hasAttr(attsArray[i])){
			
			//Split the space separated elements to find values for every set except XP it looks like this
			// xxx yyy zzz, but XP is like this.... a-xxx, b-yyy, c-zzz
			var theseAtts = myElem.attr(attsArray[i]).split(' ');
			for (var j=0;j<theseAtts.length;j++){
				
				thisAtt = theseAtts[j];
				
				if(i!=(attsArray.length-1)){
					//The value we assign needs to be the value of the control...which will depend on what we are dealing with.
					
					//Fudge if we are sending atypeListWrapper_x as thisAtt we trim the val 
					varName = thisAtt.split("_",1);
					myData[varName[0]] = mxrAS_getObjectValue(thisAtt,withParamVals);
					
				} else {
					//Include the key-value dom defined pairs and a check if there is something special to pick up from the screen...
					thisXP = thisAtt.split('-');
					myData[thisXP[0]] = thisXP[1];
					var temp = mxrAS_getSpecialAjaxData(thisXP[1]);
					if (temp!=thisXP[1]){
						myData[thisXP[1]]=temp;
					}
					
				}
			}	//end for j
		} // end if
	}	//end for i
	
	//Possible that myData is empty right now so pass a further param...the commands should check this and nparams=0 force defaults.
	myData['nparams']=myData.length;
	
	return myData;
}

function mxrAS_getSpecialAjaxData(param){
	//Depending on the param we send back extra data...
	
	switch (param) {
        case 'sendWL':
		
			//We need to send potentially multiple watches...
			//We'll let server side handle daft numbers etc...
			
			//Needs to handle a stratID. 
			var updateClass = 'mxrAS_updated';
			
			//Set up the datatable
			//var tableElement = jQuery('table');//.dataTable - used to be this way but stopped working?
						
			//Wonder if we can make this generic...
			var secIDCol = 0;
			var wPosCol = 4;
			//var stratIDCol = 10;//Fix this. TODO 2014-10-15 We now pick this up from the text in the cell on the table. We can now free up a column.
			var snameIDCol = 11;
			
			//So we want to send the edited rows from the dataTable on the post...
			var rows = jQuery('table tr.' + updateClass);
			var temp = [];
			rows.each(function(index){
				//So we grab the td children of this tr
				var mySelector = jQuery(this);
				//var rowData = tableElement.fnGetData( this );
				//var rowData = rowData[secIDCol])

                //TODO 2014-10-15 Think we can pick up the stratID here - we can but should
                // be taken from the first column text secID | stratID then doesn't need it's own column...
                // and then don't have to send back...

                var myStratIDTestTextArray = mySelector.children('td.C' + secIDCol).text().split('|');



				temp.push({	secID: parseInt(myStratIDTestTextArray[0]),
							wPos: parseFloat(mySelector.children('td.C' + wPosCol).text()),
							stratID: parseInt(myStratIDTestTextArray[1]),
							sname: mySelector.children('td.C' + snameIDCol).text()
						});
			});
			
			//Old strat and secID data jQuery(this).children("td.C" + stratIDCol).html() 
			
			//Handle the fact that no watches were sent back...
			if (temp.length==0){ temp = 'NO DATA';}
			break;
		
        case 'add2WL':
			//So this just runs the modal form and stores the output as a new row to the table...
			//We'll need to populate the form with default values first...including the form dropdownBox...//This only an issue once we get the universes in there...
			//Get the value of the dropdown box...
			
			//There are potentially multiple rows here --- all belonging to one strat.
			//We'll give a dummy stratID and trust the Ajax call sends the strat Name - 
			//On call back the strat is saved to the db and we pick up the new stratID in the table...
			
			//Get the currently updated lines
			var temp = mxrAS_getSpecialAjaxData('sendWL'); //Some recursive nature here...
			if(temp=='NO DATA'){
				temp = new Array();
			}
			
			var nWatchLabel = 'mxrAS_nWatch';
			var tempStratLabel = 'mxrAS_tempStratID';
			var sNameDiv = jQuery('#mxrAS_stratName');
			
			//How many watches?
			var secDiv = jQuery('#mxrAS_addSecDiv');
			var nWatch = parseInt(secDiv.attr(nWatchLabel));
			
			//tempStrat ID
			var tempStratID = parseInt(secDiv.attr(tempStratLabel));
			
			//Strat name
			var sName = sNameDiv.val();
			if (sName==""){
				tempStratID=0;
			} else {
				var tempStratID = parseInt(secDiv.attr(tempStratLabel));
				secDiv.attr(tempStratLabel,tempStratID+1);
			}
			for(var iCount=1;iCount<=nWatch;iCount++){
				
				temp.push( {	secID: parseInt(mxrAS_getObjectValue("secIDList_" + iCount)), 
								wPos:jQuery("#mxrAS_wPos_" + iCount).val(),
								stratID: -tempStratID,
								sname: sName
						});
						
			}
			
			//Hide the box - clean up?
			mxrAS_clearThisWatchDiv(secDiv,"mxrAS_tempWatchField",sNameDiv);
			break;

        case 'add2StopL':
            //We will reuse this code to edit stops too. Edited stops here and we will need the
            //the stop id if exists - that must be picked up somewhere...Store it on the div perhaps
            var mxrWrapper = "mxrAS_"
            //New stop and stopID = 0; existing and we use the stopID.
            //The server will know what to do with the stopID and data.

            var stopDiv = jQuery('#' + mxrWrapper + 'addStopDiv');

            var stopID = parseInt(stopDiv.attr(mxrWrapper + 'stopID'));
            var nSecs = parseInt(stopDiv.attr(mxrWrapper + 'nsec'));//number of stop securities.


            //Go grab the data - there's probably a quicker way than this...
            temp = [];

            //DOM names.
            var dropDownName = "secIDList_";
            var sAmountName = mxrWrapper + "stopamount_";
            var stopPriceName = mxrWrapper + "stopprice_";

            for(var i = 1; i<=nSecs; i++){
                //We want all the mxrAS_ss_i data
                var iStr = i.toString();
                temp.push({ secID: parseInt(mxrAS_getObjectValue(dropDownName + iStr)),
                            sAmt: jQuery("#" + sAmountName + iStr).val(),
                            stopPrice: jQuery("#" + stopPriceName + iStr).val()
                });
            }

            break;

		default:
			//Nothing special about the param so just return it.
			var temp = param;
	}
	return temp;
}

function mxrAS_clearThisWatchDiv(secDiv,className,sNameDiv){
		//Bit clunky this but it is reused..
			secDiv.hide();
			
			if (className!="N"){
				jQuery("." + className).remove();
				//Reset the nWatch...but keep the tempStratID.
				secDiv.attr('mxrAS_nWatch',1);
				sNameDiv.val("Sub Strategy Name");
			}
}

function mxrAS_getObjectValue(elemName,dispVal){
	//We grab a dom element and get it's value depending on what it is.
	
	if(dispVal === undefined) dispVal = false;
	
	//This may seem weird but it stops us accessing a bug element that isn't inside the choice area. 
	//var myElem = jQuery('#mxrAS_choiceArea').children('#mxrAS_' + elemName);
	var myElem=jQuery('#mxrAS_' + elemName);
	
	//What type is it. 
	var myType = myElem.attr('mxrAS_type');
	
	switch (myType){
		case 'date':
		//Have an input text box.
		rVal = myElem.children("input[name=mxrAS_" + elemName + "]").val();
		break;
		
		case 'dateRange':
		//Will need to do something like name=mxrAS+elemName+d1 or d2 or something...
		break;
		
		case 'radio':
		//Have a radio selection to determine.
		if(!dispVal){
			rVal= myElem.children("input[name=mxrAS_" + elemName +"]:checked").val();
		}else{
			rVal= myElem.children("input[name=mxrAS_" + elemName +"]:checked + label").text();
		}
		break;
		
		case 'dropDown':
		if(!dispVal){
			rVal = myElem.children("").val();
		} else {
			var id = myElem.attr("id").split("Wrapper");
			rVal = jQuery("#"+ id[0] + " option:selected").text();
		}
		break;
		
		case 'ulList':
			//The UL has a attr called mxrAS_IDs which is what we'll handle server side.
			rVal = myElem.attr("mxrAS_IDs");
		break;
		
		case 'chk':
			//It's a mxr checkbox...
			if (myElem.children(".mxrAS_chkbox").is(':checked')==true){
				rVal = 1;
			} else {
				rVal = 0;
			}
		break;
		
		default:
		//Just the value of the element...
		if(!dispVal){
			rVal = myElem.val();
		} else {
			rVal = myElem.text();
		}
	}
	return rVal;
	
}

function mxrAS_showWidgetControls(myElem,wAreaID,wTypeName){

	wElems=jQuery(wAreaID);
	
	if(!myElem.hasAttr(wTypeName)){
		//show all - they start as hidden in the choice area.
		//wElems.children('.hidden').removeClass('hidden');
	} else {
		//show some
		var wShow = myElem.attr(wTypeName).split(' ');
		pSel = wAreaID;
		tok = " ";
		for(var i=0;i<wShow.length;i++){
			
			switch (wShow[i]){
				case "b":
				pType = 'button';
				break;
				
				case "r":
				pType = 'radio';
				break;
				
				case "l":
				pType = 'dropDown';
				break;
				
				case "d":
				pType = 'date';
				break;
			}
			pSel = wAreaID + "[mxrAS_type='" + pType + "']";
			//jQuery(pSel).removeClass('hidden');
		}
		
	}
}

jQuery.fn.hasAttr = function(a) { 
	var aVal = this.attr(a); 
	return (aVal !== undefined) && (aVal !== false); 
}
