<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-08-25
 * Time: 3:02 PM
 */


add_action("wp_ajax_mxrAS_EXPA", "mxrAS_EXPA");
function mxrAS_EXPA(){
    //Produces the ex-post and ex-ante risk measures...
    //POST Vars sent By AJAX Request
    $streamChoice = $_POST['streamChoiceRadio'];
    $streamID = $_POST['streamListWrapper'];

    $radioDate = $_POST['snapshotDate'];

    //This just works fro instruments (think)
    $exaChart = mxrAS_timeSeriesFromPerfTable($streamID,$streamChoice,$radioDate,27); //26 for the data, 27 for the risk
    $p = $exaChart['charts'][0]['chartData']['name'];

    $exaChart['charts'][0]['chartData']['name'] = $p . " Ex-Ante Risk";

    //scale up the ex-ante
    foreach($exaChart['charts'][0]['chartData']['data'] as $k=>$v){
        $exaChart['charts'][0]['chartData']['data'][$k][1] =  round($exaChart['charts'][0]['chartData']['data'][$k][1]*100,4);
    }

    //Let's add the ex-post...
    $sDate = date('Y-m-d',$exaChart['charts'][0]['chartData']['data'][0][0]/1000);

    $attArray = mxrAS_getStreamAttribution($sDate, $radioDate, $streamChoice, $streamID, $sDate);
    $expData = mxrAS_makeHTE($attArray['dailyNAV'], $attArray['holds'], [], 1, 1, 20, 1);

    //print_r($expData['EXP']);
    $z=$exaChart['charts'][0]['chartData'];
    $exaChart['charts'][0]['chartData']=[];
    $exaChart['charts'][0]['chartData'][0] = $z;
    $exaChart['charts'][0]['chartData'][1]['name']= $p . " Ex-Post Risk";
    $exaChart['charts'][0]['chartData'][1]['data']= $expData['EXP'];

    $exaChart['meta']['multiSeries']=1;
    echo (json_encode($exaChart));
    die();
}

//Build Ex-Ante Correlations...
add_action("wp_ajax_mxrAS_SCM","mxrAS_SCM");
function mxrAS_SCM(){
    //So we are sent 2 items.

    //This should be a passed param
    $exAnte = $_POST['EXPEXARadio'] == "1" ? true : false;
    $drillDown = $_POST['UNDERLRadio'] == "1" ? false : true;

    $radioDate = $_POST['snapshotDate'];

    //and the list of streams and depts...
    $unparsedChoiceArray = explode(" ",trim($_POST['covIDList']));

    //Each Entry is now a sChoice_sDept pairing...we want to build the array..
    $myChoices = array();
    foreach($unparsedChoiceArray as $zPair){
        $zChoice = explode("_",$zPair);
        $myChoices[]=array('streamChoice'=>$zChoice[0],'streamID'=>$zChoice[1]);
    }

    //So now send off to deduce the matrix...
    if($exAnte){
        $corrMatrix = mxrAS_buildExAnteStreamCov($radioDate, $myChoices,true,$drillDown);
        $msg = "Built Ex-Ante Matrix on $radioDate";
        $type = "Ex-Ante";
    } else {
        $corrMatrix = mxrAS_buildExPostStreamCov($radioDate, $myChoices,6,true,$drillDown);
        $dataMsg = " : Uneven data series - used pairwise analysis.";
        $msg = "Built Ex-Post on $radioDate " . $dataMsg;
        $type = "Ex-Post";
    }

    //return the response...
    $metaData = mxrAS_HCMakeMeta('covMatrix','',array('snapshotDate'=>$radioDate),'',0,$msg);
    //Output the data
    echo (json_encode(
        array('meta'=> $metaData,
            'table'=>array('dataTable'=>mxrAS_covTable($corrMatrix,'SCM',$type),
                'ID'=>'mxrAS_SCM_dataTable'))));
    die();
}

//Scenarios and Stress Tests
add_action("wp_ajax_mxrAS_SSA", "mxrAS_SSA");
function mxrAS_SSA(){
    //This creates the historical time series of Scenario Analyses...

    //POST Vars sent By AJAX Request
    $streamChoice = $_POST['streamChoiceRadio'];
    $streamID = $_POST['streamListWrapper'];

    $radioDate = '1900-01-01'; //By reference call in the SQL call will overwrite this date.

    //get the rows from the sql statement.array('pointFormat'=>'<span style="color:{series.color}">{series.name}</span>: <b>{point.y}</b><br/>','valueDecimals'=>2)
    $charts = mxrAS_getMultiplePerfTypeSeries('SSA',$streamChoice,$radioDate,$streamID,100,'Scenario Analysis % PnL','PnL %');
    $pParams = array('snapshotDate'=>$radioDate,'streamChoiceRadio'=>$streamChoice,'streamListWrapper'=>$streamID);

    $otherMsg =  mxrAS_getSSADefsInList();

    $metaData = mxrAS_HCMakeMeta('chart','StockChart', $pParams,$charts,1,"Multiple Stress Tests Found. ", "", $otherMsg);

    $charts[0]['chartOptions']['tooltip'] = array('valueSuffix'=>'%');
    echo (json_encode(array('meta'=> $metaData,'charts'=>$charts)));
    die();
}

add_action("wp_ajax_mxrAS_HTE", "mxrAS_HTE");
function mxrAS_HTE(){
    //This creates the historical tracking error with the earliest date set by the user....
    //POST Vars sent By AJAX Request
    $streamChoice = $_POST['streamChoiceRadio'];
    $streamID = $_POST['streamListWrapper'];
    $radioDate = $_POST['snapshotDate'];


    //First off we can get the ex-ante - this needs to change for the non-instruments...

    $expRows = mxrAS_getTSeriesForSecID($radioDate,$streamID, 26,$nYears = 15, 'line');

    //This handles instruments.
    //Dates...
    $perfStartDate = mxrAS_getPerfStartDate($streamChoice, $streamID, $radioDate);


    $startDate = date('Y-m-d', strtotime('-3 month', strtotime($perfStartDate)));

    //Get holdings and returns
    $attArray = mxrAS_getStreamAttribution($startDate, $endDate, $streamChoice, $streamID, $perfStartDate);

    //Grab the risk data
    $riskMat = mxrAS_getRiskMat($startDate, $attArray['holds']);

    //Do the calculations
    $xData = mxrAS_makeHTE($attArray['dailyNAV'], $attArray['holds'], $riskMat);

    $jsCharts=[];
    $jsCharts[]=array(
        'chartOptions'=>array(
            'rangeSelector'=>array('selected'=>4),
            'title'=>array('text'=>"Ex-Post and Ex-Ante Time Series"),
            'yAxis'=>array('title'=>array('text'=>"Risk %")),
            'credits'=>mxrAS_HCGetCredits(),
            'exporting'=>mxrAS_HCGetExporting(),
            'legend'=>array('enabled'=>true,'layout'=> 'horizontal')
        ),
        'chartData'=>$xData
    );


    $pParams = array('snapshotDate'=>$startDate,'streamChoiceRadio'=>$streamChoice,'streamListWrapper'=>$streamID);
    $metaData = mxrAS_HCMakeMeta('chart','StockChart', $pParams,$jsCharts,1,"Historical Ex-Ante and Ex-Post Risks Found. ");

    echo (json_encode(array('meta'=> $metaData,'charts'=>$jsCharts)));
    die();
}