<?php
/**
 * Created by PhpStorm.
 * User: NLaxton
 * Date: 25/03/2015
 * Time: 1:54 PM
 */
add_action("wp_ajax_mxrAS_LSTP","mxrAS_LSTP");
function mxrAS_LSTP($cleanVars = true){
    //We will simply load all the existing stops for this department.
    //We could ultimately (and very easily) show all the stops...
    //We simply need to POST that information as -1 will get everything in the StopList.

    if($cleanVars){
        mxrAS_cleanPOSTvars();
    }

    //This should be in the stop class...

    echo json_encode(mxrAS_prepareStopListOutput($_POST['streamListWrapper'], $_POST['streamChoiceRadio'], $_POST['snapshotDate'], $_POST['KILLTRIGRadio']));
    die();
}


add_action("wp_ajax_mxrAS_KSTP", "mxrAS_KSTP");
function mxrAS_KSTP(){
    //We kill a stop and therefore know it's ID passed as stopID. We then reload the table.

    mxrAS_cleanPOSTvars();
    $killedStop = new AlphaSelect\Stop($_POST['stop_id']);
    $killedStop->killStop();
    mxrAS_LSTP(false);
    die();

}

add_action("wp_ajax_mxrAS_TSTP", "mxrAS_TSTP");
function mxrAS_TSTP(){
    //We trigger the stop using the kill stop method
    mxrAS_cleanPOSTvars();
    $triggeredStop = new AlphaSelect\Stop($_POST['stop_id']);
    $triggeredStop->triggerStop($_POST['snapshotDate']);
    mxrAS_LSTP(false);
    die();
}

add_action("wp_ajax_mxrAS_VDSTP", "mxrAS_VDSTP");
function mxrAS_VDSTP(){
    //We want to grab the data for the stop we want and return it back to the client.
    mxrAS_cleanPOSTvars();

    //Grab the stop
    $stop2View = new AlphaSelect\Stop(($_POST['stop_id']));

    //Now prepare the stop2View text to send back.
    echo json_encode($stop2View->getUpdateStopFormObject());
    die;
}

function mxrAS_USTP(){
    //We update a stop with various params supplied in an array...
    mxrAS_cleanPOSTvars();

    //Grab the stop
    $stop2update = new AlphaSelect\Stop($_POST['stop_id']);

    //Set the stop params to new values.
    $buttonVarName = $_POST['b'];
    $stopEdits['details'] = $_POST[$buttonVarName];


    $keyMap = array(
        'streamChoiceRadio'=>'stype_id',
        'streamListWrapper'=>'dept_id',
        'rationale'=>'rationale',
        'startdate'=>'startdate',
        'triggeredon'=>'triggeredon',
        'killedon'=>'killedon',
        'StopLimitRadio'=>'filltype'
    );

    foreach($keyMap as $k=>$v){
        $stopEdits[$v] = $_POST[$k];
    }


    //Now somehow need to send these edits to the stop to rebuild itself.
    //We also need to know that the stop has different edit names.
    $stop2update->setStopParams($stopEdits);
    $stop2update->updateStop();

    //Now rebuild the list.
    mxrAS_LSTP(false);
}

add_action("wp_ajax_mxrAS_NSTP", "mxrAS_NSTP");
function mxrAS_NSTP(){
    //Create a new stop but the edit stop is directed here as well.
    mxrAS_cleanPOSTvars();

    //Now we simply add the stop with the params
    $stop2Add = new AlphaSelect\Stop(0);

    //If we are updating then we simply connect the two stops together.

    if (isset($_POST['stop_id'])) {
        //We've been sent either new parameters or edits.
        //Are we editing or creating?
        //Editing

        //Editing is actually killing the old stop
        //Which can still be triggered 'today'...
        //Then you can you add a new stop.
        if($_POST['stop_id']!=0){
            $kStop = new AlphaSelect\Stop($_POST['stop_id']);
            //Now we simply add the stop with the params
            $kStop->pendingKill($stop2Add->getStopID());
        }
    }

    //We update the stopParams with those from the user.

    //Just before we do that though we change the date to today
    $_POST['startdate']=date('Y-m-d');
    $stop2Add->setNewStopParams();

    //Commit to the db
    $stop2Add->insertStop();

    //We didn't send the snapshotDate so simply put it as today?
    //$_POST['snapshotDate'] = $radioDate = date_format(date_create("now"), 'Y-m-d');

    //Now rebuild the list.
    //mxrAS_LSTP(false);
    echo json_encode(mxrAS_prepareStopListOutput($stop2Add->getDeptID(), $stop2Add->getStypeID(), date_format(date_create("now"), 'Y-m-d')));//$_POST['snapshotDate']));
    die();
}