<?php

/*This is a class represents a Holdings snapshot for a Stream. */

namespace AlphaSelect;

class Holdings 
{
	
	private $stream;
	private $keyHolds;
	private $endDate;
	private $hasHolds;
    private $startDate;
	
	const CASHID = '207';
	const CONNAME = 'AS';
	
	//We will always want the key details from the _streamType table. 
	function __construct(IStream $stream, $sDate = null){
		//Set the stream ID
		$this->stream = $stream;

        $eDate = $stream->getPerfStartDate();
		$this->setDates($eDate, $sDate);//Saves a call to the database.
	}
	
	//Handle the start and end dates for the holdings...
	public function getEndDate() { 
		return $this->endDate;
	}
	
	public function getStartDate(){

		$perfStartDate =  $this->stream->getPerfStartDate();
        if ($perfStartDate > $this->startDate){
            //We must use the later date...
            $rdate = $perfStartDate;
        } else {
            $rdate = $this->startDate;
        }

        return $rdate;
	}
	
	public function setDates($ed, $sd = null){
		if (isset($sd) && !is_null($sd)){
			$this->stream->setperfStartDate($sd);
		}
		$this->endDate = $ed;
		
		//Check holdings...
		$this->setHasHolds();
	}
	
	//Retrieve the Stream - it's a private set - if you change the stream you basically have to change everything. 
	public function getHoldStream(){
		return $this->stream;
	}

    public function hasHolds(){

    }

	//Check holdings of the Stream
	private function setHasHolds(){
		//If it's an instrument the hasHolds is automatically true...
		$rFlag = true;

        $sql = $this->stream->getStreamSQL();
        $sic = $this->stream->getStreamInputChoice();

		if($sql->getAlias() != 'Instrument'){
			$SQL = "SELECT count(date_created) FROM ccp_{$sql->getTableHolds()}  WHERE {$sql->getFieldName()}_id={$sic->getStreamID()} AND date_created<='{$this->getEndDate()}' and date_created>='{$this->getStartDate()}'";
			
			//Grab the holdings.
			$nHolds = mxrAS_db_grabRows(self::CONNAME,$SQL,false);
			if($nHolds[0][0]<=0){
				$rFlag = false;
			}
		}
		
		$this->hasHolds = $rFlag;
	}

    private function setHoldingsSQL($verbose = false){
        //verbose means we get the SQL to have more of the descriptors.
        if($verbose){
            $holdingsSQL = "SELECT * FROM
                            ccp_";
        } else {

            $holdingsSQL = "SELECT applicable_date as ddate, timestamp, asset_id as aid, value as pos FROM
	    	    	    	    (SELECT applicable_date, timestamp, asset_id, value, RANK() OVER
	        	    	    	(PARTITION BY applicable_date, asset_id ORDER BY timestamp DESC) mts
	            	    		FROM ccp_{$this->stream->tblHolds}
								WHERE applicable_date>='{$this->getStartDate()}' AND applicable_date<='{$this->getEndDate()}'
						 		AND {$this->stream->fName}_id = {$this->stream->id} ) AS ww
								WHERE ww.mts=1";
        }

        return $holdingsSQL;
    }
    public function getHoldings($refresh = true){
	
		if($refresh){
			
			$this->keyHolds = array();
	
			//So we check if it's not an instrument...
            $sic = $this->stream->getStreamInputChoice();
            $sql = $this->stream->getStreamSQL();

			if($sql->getAlias() == 'Instruments'){
				// The holdings are easy.
				$this->keyHolds['1900-01-01'][$sic->id] = 1;
			} else {
	

				//Return holdings['ddate']['timestamp']['aid']['pos']					
				$holds =   mxrAS_db_grabRows(self::CONNAME, $this->setHoldingsSQL(), false);
		
				//What if there aren't any rows...
				if (count($holds)<1) { 
					$keyHolds[$startDate][self::CASHID] = 1; 
				} else {
		
				//Now populate the keyHolds vector.
					foreach($holds as $hold){
						$ddate = $hold['ddate'];
						$aid = $hold['aid'];
		
						$this->keyHolds[$ddate][$aid]=$hold['pos'];
					}
				}
			}
		}
		
		return $this->keyHolds;
	}	

}
