<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-05-27
 * Time: 12:03 PM
 *
 * SINGLE USE PROPOSITION:
 * Positions are a single weight (current position) associated with a security ID.
 * Hence Holdings are collections of positions, and risks are associated with positions/holdings objects.
 * They are very simple and the exposed parts of the class let you change the strategyName it's associated with
 * and it's position size. You cannot change the security ID of position because that means it's changed into another position
 * which doesn't make sense...
 */

namespace AlphaSelect;

class Position {

    private $secID; //The security ID - an integer often used as a string for key values.
    private $assetName; //The asset name - string
    private $currentPosition; //The current position - float
    private $subStrategy; //View positions belong to a sub strategy...portfolio positions don't, and signals belong to a signal strat... - string

    /* New instances get setup using internal encapsulated functions */
    public function __constructor($secID, $assetName, $currentPosition, $subStrategy = 'Single Position'){
        $this->setupPosition($secID, $assetName, $currentPosition, $subStrategy);
    }

    /* GETter functions */

    public function getSecID(){
        return $this->secID;
    }

    public function getAssetName(){
        return $this->assetName;
    }

    public function getPosition(){
        return $this->currentPosition;
    }

    public function getSubStrategy(){
        return $this->subStrategy;
    }

    /* Change position size OR strategy
     * Likely 'events' for a position - it won't change it's name here or ID
     *
     */
    public function changeSubStrategy($val){
        $this->subStrategy = $val;
    }

    public function changePositionSize($val){
        $this->currentPosition = $val;
    }

    /* Private set function */
    private function setupPosition($secID, $assetName, $currentPosition, $subStrategy){
        $this->secID = $secID;
        $this->assetName = $assetName;
        $this->changePositionSize($currentPosition);
        $this->changeSubStrategy($subStrategy);
    }
}