<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-08-11
 * Time: 5:18 PM
 */

namespace AlphaSelect;


class Stop {

    //Any Date is actually a date object, not a string. The input is a string but the output is a date...

    const TRIGGERED = 'Triggered';
    const ACTIVE = 'Active';
    const KILLED = 'Killed';
    const PENDING = 'Pending';

    private $dbName = 'AS';
    private $existingStop = false;
    private $updated = false;

    private $stop_id;
    private $dept_id;
    private $stype_id;
    private $startdate;
    private $triggeredon;
    private $status;
    private $tadjustment;
    private $rationale;
    private $killedon;
    private $deptname;
    private $filltype;//1 for Stop, -1 for Limit
    private $secID;

    //New fields in Sep 2015
    private $endts;
    private $startts;

    private $stopDetails;

    //key=>[type like real,quotes, date, in the table?]
    //truth table is [in final table, in insert, in update]

    //They are in db column order...
    private $keys = [
        'stop_id'=>['r', false, true, false],

        'dept_id'=>['r', false, true, true],
        'startdate'=>['d', true, true, true],
        'triggeredon'=>['d', true, true, true],
        'status'=>['q', true, true, true],

        'rationale'=>['q', true, true, true],
        'killedon'=>['d', true, true, true],

        'stype_id'=>['r', false, true, true],

        'tadjustment'=>['r', true, true, true],
        'filltype'=>['r', true, true,true],

        'deptname'=>['q', true, false, false],
        'editview'=>['q', true, false, false],

        'startts'=>['d', false, true, false],
        'endts'=>['d', false, true, false]
    ];

    private $useKeyDisplay = false;

    //constructor to build the stop either as blank or from DB.
    function __construct($stopID){
        //So we want to create a new Stop then we do it with $myStop.new

        //If it's a new stop then we just return the newStopID.
        $params = $this->setStopID($stopID);
        if (is_array($params)){
            //We set up the rest of the stop;
            $this->setStopParams($params[0]);
        }
    }

    /* Getters */

    public function getStartTS(){
        return $this->startts;
    }

    public function getEndTS(){
        return $this->endts;
    }

    public function getFillType(){
        return $this->filltype;
    }
    public function getStopID(){
        return $this->stop_id;
    }
    public function getDeptID(){
        return $this->dept_id;
    }
    public function getStypeID(){
        return $this->stype_id;
    }

    public function getStartDate(){
        //We simply return a date which we can then format later if needed.
        return $this->startdate;
    }
    public function getTriggeredOn(){
        //We simply return a date which we can then format later if needed.
        return $this->triggeredon;
    }
    /*public function getDrawDownFrom(){
        //We simply return a date which we can then format later if needed.
        return $this->drawdownfrom;
    }*/
    public function getKilledOn(){
        //We simply return a date which we can then format later if needed.
        return $this->killedon;
    }
    public function getStatus(){
        return $this->status;
    }

    public function getTotAdjustment(){
        return $this->tadjustment;
    }

    public function getRationale(){
        return $this->rationale;
    }
    public function getDeptName(){
        return $this->deptname;
    }
    public function getStopDetails(){
        return $this->stopDetails;
    }

    public function getStopParams(){
        $params = [];

        foreach($this->keys as $key=>$v){
            $params[$key] = $this->getMyKey($key);//Handles the 'd' objects.
        }

        return $params;
    }

    public function setFillType($filltype){
        $this->filltype = $filltype;
    }

    public function setNewStopParams($keyMap = false, $defaults = false){
        //We use the POSTed variables and if $keyMap not supplied use our own.

        if(!$keyMap){
            //Use this default: assume from NSTP command.
            $keyMap = array(
                'streamChoiceRadio'=>'stype_id',
                'streamListWrapper'=>'dept_id',
                'rationale'=>'rationale',
                'startdate'=>'startdate',
                'StopLimitRadio'=>'filltype'

            );

        }

        if(!$defaults){
            $defaults = array(
                'deptname'=>'New Stop',
                'status'=>'L',
                'filltype'=>1,
                'adjustment'=> 0,
                'triggeredon'=>null,
                'killedon'=>null
            );
        }

        //Populate the array to setup the stop.
        foreach($keyMap as $v=>$k){
                //The k and v are correct!
            $this->$k = $_POST[$v];
        }

        foreach ($defaults as $k=>$v){
            $this->$k = $v;
        }

        //And now the details part...

        $postKeys = array('secID'=>'asset_id', 'sAmt'=>'stopamount', 'stopPrice'=>'stopprice','adjustment'=>'adjustment');
        $rows=[];
        foreach ($_POST[$_POST['b']] as $row){
            $tempRow = [];
            foreach($postKeys as $k=>$v){
                if(!isset($row[$k])){
                    $tempVal = 0;//Mainly because the adjustment isn't always known or POSTED back...
                } else {
                    $tempVal = $row[$k];
                }
                $tempRow[$v] = $tempVal;
            }
            $rows[] = $tempRow;
        }

        //This is a critical line - if it's out then even objects that just need the top line of the stop (master line)
        //will still need the details.
        $this->setStopDetails($rows);

    }

    //This is where we populate a stop.
    //The constructor will use this to populate from DB if required.
    public function setStopParams($params, $updated = false, $reKeyMap = false){
        //Quick setter for all key params...

        //If we sent a key map then we must rebuild the params...
        if(isset($keyMap) && $reKeyMap != false){
           self::reKeyParams($params, $reKeyMap);
        }

        //$this->setAssetID($params['asset_id'], $params['asset_name']);

        $this->setDeptID($params['dept_id'], $params['stype_id'], $params['deptname']);

        $this->setStatus($params['status']);

        $this->setStartDate($params['startdate']);//Pass a string but creates a date.

        $this->setRationale($params['rationale']);

        $this->setFillType($params['filltype']);

        if (!isset($params['tadjustment'])){
            $params['tadjustment'] = null;
        }
        $this->setTotAdjustment($params['tadjustment']);

        //Must be set after the startDate.
        //$this->setDrawDownFrom($params['drawdownfrom']);//Pass a string but creates a date

        $this->setTriggeredOn($params['triggeredon']);//Pass a string but creates a date.

        $this->setKilledOn($params['killedon']);//Pass a string but creates a date.

        $this->setStartTS($params['startts']);

        //So now we have an array of asset_ids, stop amounts and drawdown weights.
        //These are handled in the stopDetails.
        $details = null;
        if (isset($params['details'])){
            $details = $params['details'];
        }

        $this->setStopDetails($details);

        //A bit of a fudge but we assume you haven't changed anything when the setParams is called, just populated
        $this->updated = $updated;

    }

    public function setStartTS($sts){
        $this->startts = $sts;
    }

    public function triggerStop($triggerDate = null, $status='T'){

        //So the Trigger Stop needs to :
        //1 Match the new view id with the stop id in the stop view map.
        $this->populateStopViewMap();

        //2 Initiate a trade - adjust an existing position or add a new one that matches the details in the stop.
        $timestamp = $this->initiateTriggerTrade($triggerDate);
        //3 Trigger the stop and remove it from the list -

        //Remember we may need to back date here...so we need to ensure the triggerDate here is a potentially backdated one.

        $this->updateKillTrigger($status, $triggerDate, 'triggeredon', $timestamp);

        return "The stop was triggered";
    }

    public function populateStopViewMap(){
        //Populate stopViewMap with new viewID.
        $mySQL = "insert into ccp_stopviewmap values (" . $this->getStopID() . ", (select max(view_id)+1 from ccp_strategies_holdings))";
        mxrAS_db_grabRows($this->dbName, $mySQL);
    }

    public function initiateTriggerTrade($triggerDate = null){
        //TODO ensure the triggerdate is brought in from the triggers page...July 2016
        //1-First grab the latest view.
        //We may wish to be smart and propagate retrospective triggers but for now we use the latest view as the view2use.
        //current viewID of latest positions.
        $latestViews = mxrAS_db_grabRows($this->dbName, "select view_id from ccp_strategies_holdings where dept_id = " . $this->getDeptID() . " order by timestamp desc");
        $currentVID = $latestViews[0][0];

        //The latest view.
        $SQLlatest = "select * from ccp_strategies_holdings_details where view_id = {$currentVID}";

        $latestViewDetails = mxrAS_db_grabRows($this->dbName, $SQLlatest);

        //2 - Add a row to the holdings with the new view_id for this stop and it picks up the rationale.
        $viewIDSQL = "(select view_id from ccp_stopviewmap where stop_id = {$this->getStopID()})";

        if($triggerDate==null) {
            $timestamp = date('Ymd-his');
            $triggerDate = date('Y-m-d');
        } else {
            $timestamp = substr($triggerDate, 0, 4) . substr($triggerDate, 5, 2) . substr($triggerDate, 8, 2) . '-' . date('his');
        }

        $insSQL =  "insert into ccp_strategies_holdings values ({$viewIDSQL}, " . $this->getDeptID() . ",'{$timestamp}','" . $this->getRationale() . "','{$triggerDate}', 'Nick Laxton')";
        mxrAS_db_grabRows($this->dbName, $insSQL);

        //3 - Now we need to get the stop details.
        //Prepare the insert statement.
        //First - do we already hold the asset?
        $stopList = $this->getStopDetails()->getDetailsList();
        $x = $stopList[0];
        $secID = $x->getAssetID();

        $tempIDs = [];
        foreach($latestViewDetails as $r){
            $tempIDs[] = $r['asset_id'];
        }

        $vID = mxrAS_db_grabRows($this->dbName, $viewIDSQL);
        if (in_array($secID, $tempIDs)) {
            // Yes? Then augment the model_weight only.
            $augFlag = true;

            //Which row has the secID and substrat_id = 0
            foreach($latestViewDetails as &$row){
                if($row['asset_id']==$secID && $row['substrat_id']==0){
                    //We have it!
                    $row['model_weight'] += $x->getStopAmount();
                    $augFlag = false;

                }
            }
            unset($row);
        } else {
            $augFlag = true;
        }


        if($augFlag){
            // No? Add a row to the array and then prepare.
            $latestViewDetails[] = array('view_id'=> $vID[0], 'asset_id'=> $secID, 'bmk_weight'=>0, 'model_weight'=>$x->getStopAmount(), 'date_created'=>$triggerDate, 'created_by'=>'Nick Laxton', 'substrat_id'=>0);
        }

        //Insert all the latestViewDetails rows.
        $sqlValues2Insert = [];
        foreach($latestViewDetails as $row){
            $insertValuesArray = array($vID[0][0], $row['asset_id'], $row['bmk_weight'], $row['model_weight'], "'{$triggerDate}'", "'Nick Laxton'", $row['substrat_id']);
            $sqlValues2Insert[] = "(" . implode(',', $insertValuesArray) . ")";
        }

        $insSQL = "insert into ccp_strategies_holdings_details values " . implode(",", $sqlValues2Insert);
        mxrAS_db_grabRows($this->dbName, $insSQL);

        //We can then fill the timestamp and endts in the stop table.
        return $timestamp;
    }

    //This is how we kill a stop. It's a soft delete.
    public function killStop($killDate = null, $status = 'K'){
        $this->updateKillTrigger($status, $killDate, 'killedon');
        return "The stop was killed";
    }

    private function updateKillTrigger($status, $nDate = null, $field, $ts = null){
        if (is_null($nDate)){
            $nDate = mxrAS_getRadioDate(0);
        }

        //We should have already set the start ts
        if (is_null($ts)) {
            $this->endts = mxrAS_getRadioDate(1);
        } else {
            $this->endts = $ts;
        }

        mxrAS_db_grabRows($this->dbName, "update ccp_stops set status = '{$status}', endts='{$this->endts}',{$field}='{$nDate}' where stop_id={$this->stop_id} and status='L'", true);

        $this->setStatus( ($status == 'K') ? self::KILLED : self::TRIGGERED);
        $this->$field = $nDate;
        return true;
    }

    private function checkiftriggered($priceArray){

        $triggeredFlag = false;

        if ($type==1 or $type==4){
            $triggeredFlag = (($priceArray(0)<$triggerLevel)&&($priceArray(1)>=$triggerLevel));
        }

        if ($type==2 or $type==3){
            $triggeredFlag = (($priceArray(0)>$triggerLevel)&&($priceArray(1)<=$triggerLevel));
        }

        return $triggeredFlag;
    }
    public function pendingKill($newStopID, $killDate = null){
        //We set the status to P_{stopIDof Underlying}
        $status = 'P_' . $newStopID;
        $this->killStop($killDate, $status);
    }

    public function triggerStop_old($triggeredon, $tadj){
        echo ('In Trigger Stop');
        $this->setStatus(self::TRIGGERED);
        $this->setTriggeredOn($triggeredon);
        $this->setTotAdjustment($tadj);
        //Now save to DB.
        $this->updateStop();
    }

    //Updates edits to the stop we working on.
    public function updateStop(){

        //TODO March 2015 - this needs a revisit on the pnl side?

        //So what we want to do is grab the parameters and put into a string...
        if ($this->updated && $this->existingStop){

            //We don't want the stop data
            $mySQL = "update ccp_stops set " . implode(",", $this->prepInsertsAndUpdates(false)) . " where stop_id = {$this->stop_id}";

            mxrAS_db_grabRows($this->dbName, $mySQL, true);
        }
    }

    //Where we add a stop to the db
    public function insertStop(){

        if (!$this->existingStop){
            $mySQL = "insert into ccp_stops values (" . implode(",", $this->prepInsertsAndUpdates()) . ")";
            mxrAS_db_grabRows($this->dbName, $mySQL, true);

            //You'll have to update the details part too...
            $tSQL = [];

            //TODO update for a pnl adjustment March 2015

            foreach ($this->stopDetails->detailsList as $tempDetailSingle){
                $tSQL[] = "(" . $this->stop_id . "," . $tempDetailSingle->getAssetID() . "," . $tempDetailSingle->getStopAmount() . "," . $tempDetailSingle->getStopPrice() . ")";
            }

            //Build out the rest.
            $myDetailsSQL = "insert into ccp_stops_details values " . implode(",", $tSQL);

            mxrAS_db_grabRows($this->dbName, $myDetailsSQL, true);
        }
    }

    public function getStopDetailsArray(){
        //We must grab the details for the Stop
        $SQL = "select d.asset_id, i.asset_name, d.stopamount, d.stopprice, d.adjustment
                    from ccp_stops_details d
                    join ccp_instruments i on d.asset_id=i.asset_id
                    where d.stop_id = {$this->stop_id}";
        return mxrAS_db_grabRows('AS', $SQL, false);

    }

    public function setStopDetails($stopDetailsArray = null){
        //So each row of the array is used to setup a stopDetails
        $this->stopDetails = new StopDetails(0);//A blank one.

        if(is_null($stopDetailsArray)){

            $stopDetailsArray = $this->getStopDetailsArray();
        }

        //Process the array.
        foreach($stopDetailsArray as $row){
            if (!isset($row['assetName'])){
                $row['assetName']='null';
            }

            //Think this duplicates part of the class elsewhere where we deal with stop details.
            $singleDetail = new StopDetailSingle($row['asset_id'], $row['assetName'], $row['stopamount'],$row['stopprice'], $row['adjustment']);
            $this->stopDetails->add2List($singleDetail);
        }

    }

    public function setDeptID($deptID, $stypeID, $deptname){
        $this->updated = true;
        $this->dept_id = $deptID;
        $this->stype_id = $stypeID;
        $this->deptname = $deptname;
    }

    public function setStatus($status){
        $this->updated = true;
        $this->status = $status;
    }

    public function setRationale($rationale){
        $this->updated = true;
        $this->rationale = $rationale;
    }

    //Dates setters.
    public function setStartDate($startDate){
        //Rule 1: Cannot update the startdate before the existing startdate
        $start = new \DateTime($startDate);
        $this->updated = true;

        $testDate = $this->getStartDate();

        if(!is_null($testDate)){
            //TODO is this causing the stop error on the StopSince.
            //$start = $testDate > $start ? $testDate : $start;
        }
        $this->startdate = $start;
    }

    public function setTriggeredOn($triggeredOn){

        //Convert to

        //Rule 1: We cannot trigger a killed stop.
        //Rule 2: We cannot trigger a stop on/before the startdate
        $this->updated = true;
        $tDate = is_null($triggeredOn) ? null : new \DateTime($triggeredOn);

        $this->triggeredon = $tDate;

        //TODO I'm not sure we need to do this because a separate algo sets the trigger data...
        $testDate = clone($this->getStartDate());
        if($this->triggeredon < $testDate){
            $this->triggeredon = $testDate->add(new \DateInterval('P1D'));//Needs to be a date...
        }
    }

    public function setKilledOn($killedon){
        //A string is usually passed - so convert to date then store.
        $this->killedon = $killedon;

        if (!is_null($killedon)){
            //if ($this->getStatus()==self::KILLED or $this->getStatus()==self::PENDING){
                $killedonDate = new \DateTime($killedon);
                $testDate = clone($this->getStartDate());
                $this->killedon = ($killedonDate < $testDate) ? $testDate : $killedonDate;
           // } else {
           //     $killedon = null;
           //     echo('Active');
           // }
        }
    }

    public function setTotAdjustment($tadj){
        //TODO March 2015 - should this add up the values from the stop list?
        if(is_null($tadj)){
            $tadj = '0.00';
        }
        $this->tadjustment = round($tadj,4);
    }

    public function getUpdateStopFormObject(){
        // We should now make the object to return with all the key data...
        $myJsonObj = [];

        //Basic stop data
        $myJsonObj['rationale'] = $this->rationale;
        $myJsonObj['startdate'] = $this->startdate->format('Y-m-d');
        $myJsonObj['stopid'] = $this->stop_id;
        $myJsonObj['status'] = $this->getStatus();
        $myJsonObj['filltype'] = $this->getFillType();

        $myJsonObj['add2StopL'] = $this->stopDetails->getDetailsListInArrayForOutput();//TODO - adjust for scaling of input and output of weights...
        return array('meta'=>mxrAS_HCMakeMeta('stopUpdateForm', '', '', '', '', ''), 'data'=>$myJsonObj);
    }

    //Private functions.
    //Pull in the params and populate object.

    private static function reKeyParams($paramsIn, $keyMap){

        foreach($keyMap as $k=>$v){
            $temp = $paramsIn[$k];
            unset($paramsIn[$k]);
            $paramsIn[$v] = $temp;
        }
    }

    private function getParamsFromID(){
        $this->existingStop = true;

        //Stop SQL - this is repeated in the stopList - so perhaps a new object that has the Stop Sql
        $sql = "select s.stop_id, s.dept_id, s.stype_id, s.startdate, s.startts, s.rationale, s.triggeredon, 'Fix Dept Name in Stop Class' as deptname,
            (case when s.status='L' then '" . self::ACTIVE . "' when s.status='T' then '" . self::TRIGGERED . "' when s.status='K' then '" . self::KILLED .
            "' when substring(s.status from 1 for 1)='P' then '" . self::PENDING . "' end) as status,
             s.filltype, s.killedon, 'editview' as editview
            from ccp_stops s
            where s.stop_id = {$this->stop_id}";

        $z =  mxrAS_db_grabRows('AS', $sql, true);
        return $z;
    }

    private function suppliedStopType($stopID){
        if($stopID > 0){
            $type = 'existing';
        } else if($stopID == 0){
            $type = 'new';
        } else {
            $type = 'empty';
        }
        return $type;
    }
    private function setStopID($stopID){
        //3 special cases.
        //1 - we supply a live stopID and populate from DB.
        //2 - we supply a 0 id to mean grab a new id from DB ready to store as new stop.
        //3 - supply -ve of actual stopID to mean just create a blank stop ready for us to populate.

        switch ($this->suppliedStopType($stopID)) {
            case 'existing':
                $this->stop_id = $stopID;
                $params = $this->getParamsFromID();
                $this->existingStop = true;

                //If we update a stop then need the endts
                //getRadio Date should check to put in the past...TODO
                $this->endts = mxrAS_getRadioDate(1);
               // $this->startts = $this->endts;

                break;

            case 'new' :

                $params = mxrAS_db_grabRows('AS', "select max(stop_id) from ccp_stops", true);
                $this->stop_id = $params[0]['max'] + 1;

                $params = $this->stop_id;
                $this->existingStop = false;

                $this->startts = mxrAS_getRadioDate(1);
                break;

            default :
                $this->stop_id = abs($stopID);
                $params = $this->stop_id;
                $this->existingStop = true;
        }

        return $params;
    }

    private function prepInsertsAndUpdates($insertStmt = true){
        $insData = [];

        //If we are looking at inserting then the 3 col of pArray i.e. index 2,
        //If we aren't inserting then the 4 col i.e. index 3.
        $idx = $insertStmt ? 2 : 3;

        //Downside is that it doesn't use getters and that's an issue for the date fields.
        //Getters may not return a string so the underlying has to be a string.
        foreach($this->keys as $key=>$pArray){
            if($pArray[$idx]){
                if(is_null($this->$key)){
                    $insData[] = $insertStmt ? 'null' : "{$key} = null";
                } else {
                    $myData = $this->$key;

                    //pArray like this 'r',true to mean show in the table and it's a real.
                    switch ($pArray[0]) {
                        case 'r': //real number
                            $insData[] = $insertStmt ? $myData : "{$key} = {$myData}";
                            break;

                        case 'q'://text field
                            $insData[] = $insertStmt ? "'{$myData}'" : "{$key} = '{$myData}'";
                            break;

                        case 'd'://date
                            //in this case the key needs to give us the function name to call dynamically
                            //from getMyKey...
                            $insData[] = $insertStmt ? "'{$myData}'" : "{$key} = '{$this->getMyKey($key)}'";

                            break;
                    }//End Switch
                }//End If isnull
            }//End IF is wanted.
        }//End For


        /*if(!$insertStmt){
            unset($insData[0]);
        }*/
        return $insData;
    }

    private function getMyKey($key){
        //calls the correct getter

        switch ($key){
            case 'startdate' :
                $myDate = $this->getStartDate();

                $out = $myDate->format('Y-m-d');
                break;
            case 'triggeredon':
                $stat = $this->getStatus();
                if($stat==self::TRIGGERED){
                    $myDate = $this->getTriggeredOn();
                    $out = $myDate->format('Y-m-d');
                } else {
                    //If the user is an administrator...
                    if(current_user_can('manage_options')){
                        $out = $out = "<button class='mxrAS_ajaxlinks' onclick = 'mxrAS_AjaxLinkClick' mxrAS_ajaxURL='mxrAS_TSTP' mxrAS_params='streamChoiceRadio snapshotDate streamListWrapper' mxrAS_XP='b-TSTP stop_id-{$this->stop_id}'>Trigger Stop</button>";
                    } else {
                        $out = '';
                    }
                }
                break;
            case 'drawdownfrom':
                $myDate = $this->getDrawDownFrom();
                $out = $myDate->format('Y-m-d');
                break;
            case 'killedon':
                //It should never get here if the answer is null...
                $stat = $this->getStatus();
                $out = '';

                if($stat==self::KILLED or $stat==self::PENDING){
                    $myDate = $this->getKilledOn();

                    if (!is_null($myDate)){
                        $out = $myDate->format('Y-m-d');
                    }
                } elseif($stat==self::ACTIVE) {
                    //Not sure if this should be here - seems a bit convoluted...
                    $out = "<button class='mxrAS_ajaxlinks' onclick = 'mxrAS_AjaxLinkClick' mxrAS_ajaxURL='mxrAS_KSTP' mxrAS_params='streamChoiceRadio snapshotDate streamListWrapper' mxrAS_XP='b-KSTP stop_id-{$this->stop_id}'>Kill Stop</button>";
                }
                break;

            case 'editview':
                $out = "<button class='mxrAS_ajaxlinks' onclick = 'mxrAS_AjaxLinkClick' mxrAS_ajaxURL='mxrAS_VDSTP' mxrAS_params='streamChoiceRadio streamListWrapper snapshotDate' mxrAS_XP='b-VDSTP stop_id-{$this->stop_id}'>Edit/View Stop</button>";
                break;

            case 'secID':
                $x = $this->getStopDetails();
                $out = $x[0]['asset_id'];
                break;

            default:
                //Do something with the others but not that important here for now.....
                $out = $this->$key;
                break;
        }

        return $out;

    }
} 