<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-09-02
 * Time: 1:43 PM
 */

namespace AlphaSelect;


 class StopDetailSingle {
    //One line of a stop details array

    private $asset_id;
    private $assetName;
    private $stopamount;
    private $stopprice;
    private $grouplike;
    private $adjustment;

    private $dbName = 'AS';

    function __construct($asset_id, $assetName, $stopamount, $stopprice, $adjustment = 0){
        $this->asset_id = $asset_id;
        $this->assetName = $assetName;
        $this->stopamount = $stopamount;
        $this->stopprice = $stopprice;
        $this->adjustment = $adjustment;

        $this->setGroupLikeString();

    }

    public function getAssetID(){
        return $this->asset_id;
    }
    public function getAssetName(){
        return $this->assetName;
    }
    public function getStopAmount(){
        return $this->stopamount;
    }
    public function getStopPrice(){
        return $this->stopprice;
    }

     public function getAdjustment(){
         $ret = 0;
         if (isset($this->adjustment)){
             $ret = $this->adjustment;
         }
         return $ret;
     }
    public function getGroupLikeString(){
        return $this->grouplike;
    }

    private function setGroupLikeString(){
        //So we know the asset_id and need to grab the grouplike string...
        $table = "ccp_instruments_tradegroups";
        $i = "ccp_instruments";

        $pick = "grouplike || '_' || asset_type";

        $select = "select {$pick} as id from {$table}";
        $from = "from {$i} where asset_id = {$this->asset_id}";

        $mega = "{$select} where asset_type = (select asset_type {$from}) and grouplike = ";

        $mySQL  = "{$mega} (select substring(iaa_aid from 9 for length(iaa_aid)-8) {$from})
                    union all {$mega} (select substring(iaa_aid from 5 for 3) || '%' {$from})
                    union all {$mega} 'XX'";


        //This may give us two rows, but we only ever want the top one. The union all means we only ever do 1 SQL.
        $groupLikeRows = mxrAS_db_grabRows($this->dbName, $mySQL, true);

        if(count($groupLikeRows) == 0){
            $this->grouplike = 'ALL_ALL';
        } else {
            $this->grouplike = $groupLikeRows[0]['id'];

        }
    }


}
