<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-08-13
 * Time: 10:51 AM
 */

namespace AlphaSelect;

//A StopList gets multiple stops for a given dept and puts them in an array...
class StopList {

    private $dept_id;//The dept_id or portfolio...
    private $deptname;//The name of the stream...
    private $streamType_id;//Portfolio, view or signal
    private $onBeforeDate;//Stops setup before/on this date.
    private $status;
    private $whereSQL;
    private $stopArray;
    private $joiner;

    function __construct($dept_id, $streamType_id, $sdate, $status){
        $this->setupList($dept_id, $streamType_id, $sdate, $status);

    }

    public function setDeptID($deptID, $streamType_id){

        //We must always have a streamType...
        $this->streamType_id = $streamType_id;
        $this->whereSQL['stype_id'] = "s.stype_id = {$this->streamType_id}";

        //the whereSQL helps us parameterise the list.
        if($deptID < 0){
            //ALL DEPTs.
            $this->whereSQL['dept_id'] = "dept_id > 0";
            $this->dept_id = 0;
        } else {
            $this->dept_id = $deptID;
            $this->whereSQL['dept_id'] = "s.dept_id = {$this->dept_id}";

            //We may have to change this for any stream.
            /*$sql = "select dept_name from ccp_strategies where dept_id = {$this->dept_id}";
            $r  = mxrAS_db_grabRows('AS', $sql, true);
            print_r($r);
            $this->deptname=$r['dept_name'];*/
        }

    }

    public function setTypes($status){
        //helps parameterise the stop list.
        $this->status = $status;
        $this->joiner = " LEFT ";//This isn;t pushed yet and needs to be generally a left join...

        switch($status){
            case 'A':
                break;
            case 'NK':
                $this->whereSQL['status'] = "(s.status = 'T' or s.status='L')";
                break;
            case 'Z':
                $this->whereSQL['status'] = "(s.status = 'L' or substring(s.status from 1 for 1) = 'P')";
                break;
            case 'T':
                $this->whereSQL['status'] = "(s.status = 'T')";
                //$this->whereSQL['adjustment']= "(s.tadjustment<>0)";
                $this->joiner = "";
                break;
            case 'UT':
                $this->whereSQL['status'] = "(s.status = 'T')";

                break;

            default:
                $this->whereSQL['status'] = "s.status = '{$status}'";
                break;
        }
    }

    public function setOnBeforeDate($sdate){
        $this->onBeforeDate = new \DateTime($sdate);
        //TODO We drop this for now NFL 21-Nov-2014
       // $this->whereSQL['onBefore'] = "s.startdate <= '{$this->onBeforeDate->format('Y-m-d')}'";
    }
    public function getStopList(){
        return $this->stopArray;
    }

    public function getNumStops(){
        return count($this->stopArray);
    }

    public function getDeptName(){
        return $this->deptname;
    }

    public function getAdjustmentDetails($fac = 0.01){
        // Step one we drill into the details themselves...
        $stopList = $this->getStopList();


        // We can grab the view_id in the stopList if necessary...

        $stopAdjs = array();
        //Grab the stop for each stoplist...
        if(count($stopList)>0){

            foreach ($stopList as $stopRow){
                //the stoplist is the list of master objects.
                //Get the details - I think this repeats calls already made in the class but not sure...


                //TODO This breaks if there is no row for the details, which can happen with the cross rate stops.
                // Check this Mar 1 2016
                //Also a problem if 2 dates have a stop in the same asset...we need to aggregate. Think this now
                // fixed below.
                if(isset($stopAdjs[$stopRow['triggeredon']][$stopRow['secID']])) {
                    $temp = $stopAdjs[$stopRow['triggeredon']][$stopRow['secID']];
                } else {
                    $temp = 0;
                }
                $stopAdjs[$stopRow['triggeredon']][$stopRow['secID']] = $temp + $stopRow['tadjustment']*$fac;

            }
        }

        return $stopAdjs;
    }

    private static function getDeptFields($stype){
        switch ($stype){
            case 1:
                $x = ['table' => "models", 'id'=> "portfolio_id", 'name'=> "portfolio_name"];
                break;

            case 2:
                $x = ['table' => "strategies", 'id'=> "dept_id", 'name'=> "dept_name"];
                break;

            case 3:
                $x = ['table' => "signals", 'id'=> "dept_id", 'name'=> "dept_name"];
                break;
            case 4:
                $x = [];//For instruments we do nothing.
                break;
        }
        return $x;
    }

    private function setupList($dept_id, $streamType_id, $sdate, $status){
        $this->setDeptID($dept_id, $streamType_id);
        $this->setOnBeforeDate($sdate);
        $this->setTypes($status);
        $this->makeStopList();
    }


    private function getDeptNameSQL(){
        $fields = self::getDeptFields($this->streamType_id);
        return "d.{$fields['id']} as dept_id, d.{$fields['name']} as deptname";
    }

    private function getDeptJoinSQL(){
        $fields = self::getDeptFields($this->streamType_id);
        return "ccp_{$fields['table']} as d on s.dept_id = d.{$fields['id']}";
    }
    private function makeStopList()
    {
        //The SQL we need...
        //We need a different list...

        //If we are using Views then we do things but otherwise there are no stops currently..
        if ($this->streamType_id != 2) {
            $this->stopArray = [];
        } else {

            // We need a query that will populate the adjustment column for triggered stops.
            // The SQL structure has a viewmap for triggered stops that match the view_id to the
            // triggered stops to make the adjustment calculations easier.

            $adjustFormula = "10000*ln(abs(closeT.close/closeT.stopprice))*(0.01*closeT.stopamount)*closeT.q as del";
            $newTableID = "adjust.";

            $myDate = "to_date( substring(v.timestamp from 1 for 4) || '-' || substring (v.timestamp from 5 for
            2) || '-' || substring(v.timestamp from 7 for 2) , 'yyyy-mm-dd')";

            $reuse = " SELECT l.dept_id,  map.stop_id, map.view_id, s.asset_id, v.timestamp, s.stopprice, s.stopamount, c.constituents,dat.ts,pow(dat.value,i.reversequote) as close, i.pnlquote as q
                FROM ccp_stopviewmap as map
                JOIN ccp_stops_details s ON s.stop_id = map.stop_id
                JOIN ccp_stops l ON s.stop_id = l.stop_id
                JOIN ccp_strategies_holdings v ON v.view_id = map.view_id
                JOIN ccp_instruments i ON i.asset_id = s.asset_id
                JOIN rets_series_desc r ON r.name = i.iaa_aid
                JOIN rets_series_constituents c ON r.series_id = c.series_id
                JOIN rets_series_data dat ON dat.series_id = c.constituents
                WHERE r.periodicity = 'D' AND r.groups = 33 AND c.comp_order = 0 AND dat.ts = ";

                // If the stops are triggered we need to add some SQL.
            $withSQL = "WITH keyStops as (
                SELECT s.stop_id, m.dept_name,s.stype_id, s.startdate, s.startts, s.rationale, s.triggeredon, sd.asset_id,
                sd.stopprice,
                (case when s.status='L' then 'Active' when s.status='T' then 'Triggered' when s.status='K' then
                'Killed'  when substring(s.status from 1 for 1)='P' then 'Pending' end) as status,
                s.filltype, s.killedon, 'editview' as editview, s.dept_id
                FROM ccp_stops s
                join ccp_stops_details sd on s.stop_id = sd.stop_id
                join ccp_strategies m on s.dept_id = m.dept_id WHERE " . implode(" AND ", $this->whereSQL) . "),

                closeT as ( {$reuse} {$myDate} AND i.reversequote IS NOT NULL),

                adjust as (
                SELECT closeT.dept_id, closeT.stop_id, closeT.timestamp, closeT.close, closeT.stopamount, closeT.stopprice,
                 {$adjustFormula}
                FROM closeT )";

            //TODO So we may have an issue as the adjust above may not have the reverse quote properly sorted...
            //Also the queries need to change if the stop relates to an increase in the position rather than a stop
            // (above). We need to change the reuse query...
            //1 change closeT1 to add 1 day and weekday changes...see closeP1
            //2 include a +day to account for Friday, see weekdayP1
            //TODO 3 include an adjustment adjustP1, change adjust to adjustT1 and then change the final query.
            // 4 we will also need to change the way they join and account for an existing position...lets do that in
            // the stopmap part...


            $mySQL = $withSQL . "SELECT s.stop_id, s.stype_id, s.startdate, s.startts, s.rationale, s.asset_id,
                (CASE WHEN adjust.timestamp is null THEN s.triggeredon else " . str_replace("v.", $newTableID, $myDate)
                . " END) as triggeredon, s.dept_id, s.dept_name as deptname, adjust.del
                 as tadjustment, s.status, s.filltype,
                s.killedon, 'editview' as editview
            FROM keyStops s {$this->joiner} JOIN adjust ON adjust.stop_id = s.stop_id
            WHERE s.stopprice<>0 ORDER BY s.startdate";

            //join {$this->getDeptJoinSQL()} - this was cut from above as didn't do anything.
            //Now pull in as a SQL transaction...
            //We don't pick up any identifier other than stop id - this can then be coded into any links etc.
           //echo ($mySQL);

            $stopArray = mxrAS_db_grabRows('AS', $mySQL, true);

           // print_r($stopArray);
            //Now make the stops...
            foreach ($stopArray as $stop) {
                //Foreach stop here we create a stop object.
                $newStop = new Stop(-$stop['stop_id']);//The -ve gives us the chance to build the stop with the info
                // we have, even though it exists to prevent multiple DB calls that we don't need.

                unset($stop['stop_id']);

                //We have to know the stopDetails
                if (!isset($stop['details'])) {
                    $stop['details'] = $newStop->getStopDetailsArray();
                }

                //TODO this adjusts the start date somehow...
                $newStop->setStopParams($stop);

                //This probably has happen in the stop itself
                $t = $newStop->getStopParams();
                $t['secID']=$stop['asset_id'];
                $this->stopArray[] = $t;
            }

            //Set the dept name...
            if (count($this->stopArray) > 0) {
                $this->deptname = $newStop->getDeptName();
            }
        }
    }
}