<?php
/**
 * Created by PhpStorm.
 * User: NLaxton
 * Date: 25/03/2015
 * Time: 4:01 PM
 */

namespace AlphaSelect;

//Helps define a stream and it's tables etc.
class StreamDetails {
    private $stype;
    private $alias;
    private $tableNameRoot;
    private $tableNameHolds;
    private $tableNameHolds2;
    private $fieldName;
    private $reportName;
    private $dateName;
    private $substratSQL;
    private $substratSQL2;
    private $joinStratSQL;
    private $joinStratSQL2;
    private $baseSQL;
    private $activeStreamSQL;

    private $deptID;
    private $deptName;

    function __construct($tempStype){
        $this->stype = $tempStype;
        $this->setParameters();
    }

    public function getStratTable(){
        return $this->tableNameRoot;
    }
    public function getStratHoldsTables($bool = false){
        return $bool ? $this->tableNameHolds2 : $this->tableNameHolds;
    }

    public function getHoldsDetails(){
        $r="";
        switch ($this->stype){
            case "1":
                $r = "holdings";
                break;
            case "2":
                $r = "ccp_strategies_holdings_details";
                break;
            case "3":
                $r = "holdings";
                break;
        }

        return $r;
    }

    public function otherFieldsForHoldings(){
        $r="";
        switch ($this->stype){
            case "1":
                $r = ", applicable_date, date_created";
                break;
            case "2":
                $r = "";
                break;
            case "3":
                $r = ", applicable_date, date_created";
                break;
        }

        return $r;
    }
    //Some items for trade Summary and Details queries.
    public function getSubstratForHoldings(){
        return ($this->stype == "2") ? "substrat_id" : "0";
    }
    public function getModelWeight(){
        return ($this->stype == "2") ? "model_weight" : "value";
    }
    public function getTSViewForHoldings(){
        return ($this->stype == "2") ? "view_id" : "timestamp";
    }
    //

    public function getTableRoot(){
        return $this->tableNameRoot;
    }
    public function getDeptIDName(){
        return $this->deptID;
    }
    public function getDeptFieldName(){
        return $this->deptName;
    }
    public function getDeptName(){
        $tmp = explode('_',$this->fieldName);
        return $tmp[0] . "_name";
    }

    public function getDeptNameID(){
        return $this->fieldName;
    }

    public function getAlias(){
        return $this->alias;
    }

    public function getTradeDetailsWithHeader(){
        $bool = $this->getAlias()=="View";

        if($bool){
            $H1 = "SELECT * FROM {$this->getStratHoldsTables($bool)}";
        } else {
            $H1 = "SELECT {$this->getDeptIDName()} AS dept_id,
                    asset_id, {$this->getModelWeight()} as model_weight,
                    {$this->getTSViewForHoldings()} AS view_id,
                    {$this->getSubstratForHoldings()} as substrat_id,
                    timestamp
                    {$this->otherFieldsForHoldings()}
              FROM {$this->getStratHoldsTables($bool)}";
        }

        $H2 = "SELECT * FROM " . $this->getHoldsDetails();

        return  "holdings AS ({$H1}), holdingsDetails AS ({$H2}),";
    }

    private function setParameters(){
        switch ($this->stype){
            case "1":
                $this->alias = "Portfolio";
                $this->tableNameRoot = "ccp_models";
                $this->tableNameHolds = "ccp_models_holdings";
                $this->tableNameHolds2 = "";
                $this->fieldName = "portfolio_id";

                $this->deptID = "portfolio_id";
                $this->deptName = "portfolio_name";

                $this->reportName = "Portfolios";
                $this->dateName = "timestamp";
                $this->substratSQL = ", -1 as sid, 'Single Position' as sname ";
                $this->substratSQL2 = ", -1 as sid, 'Single Position' as sname ";
                $this->joinStratSQL = " ";
                $this->joinStratSQL2 = " ";

                $this->baseSQL = "select textvalue as bFX from ccp_models_params where param='homeCurrency' and portfolio_id=";
                $this->activeStreamSQL = "active = 'Y'";



                break;

            case "2":
                $this->alias="View";
                $this->tableNameRoot="ccp_strategies";
                $this->tableNameHolds="ccp_strategies_original_weights_vw";
                $this->tableNameHolds2 = "ccp_strategies_holdings";

                $this->fieldName="dept_id";

                $this->deptID = "dept_id";
                $this->deptName = "dept_name";

                $this->reportName="Views";
                $this->dateName = "timestamp";
                $this->substratSQL = ",h.substrat_id sid, substrats.desc as sname ";
                $this->substratSQL2 = ",wl.stratID sid, substrats.desc as sname ";
                $this->joinStratSQL = " JOIN ccp_substrategies_desc substrats ON substrats.substratid = h.substrat_id ";
                $this->joinStratSQL2 = " JOIN ccp_substrategies_desc substrats ON substrats.substratid = wl.stratID ";

                $this->baseSQL = "select textvalue as bFX from ccp_strategies_params where param='basePerspective' and dept_id=";

                $this->activeStreamSQL = "dept_status = 'L'";

                break;

            case "3":
                $this->alias ="Strategy";
                $this->tableNameRoot = "ccp_signals";
                $this->tableNameHolds = "ccp_signals_holdings_adjusted";
                $this->tableNameHolds2 = "";

                $this->fieldName = "dept_id";

                $this->deptID = "dept_id";
                $this->deptName = "dept_name";

                $this->reportName = "Strategies";
                $this->dateName = "timestamp";
                $this->substratSQL = ", -1 as sid, 'Single Position' as sname ";
                $this->substratSQL2 = ", -1 as sid, 'Single Position' as sname ";
                $this->joinStratSQL = " ";
                $this->joinStratSQL2 = " ";
                $this->activeStreamSQL = "dept_status = 'L'";

                $this->baseSQL = "select textvalue as bFX from ccp_signals_params where param='basePerspective' and dept_id=";

                break;

            case "4":
                //Instruments
                $this->alias = "Security";
                $this->tableNameRoot = "ccp_instruments";
                $this->tableNameHolds = "";
                $this->tableNameHolds2 = "";
                $this->fieldName = "asset_id";
                $this->reportName="Securities";
                $this->dateName = "";
                $this->substratSQL = "";
                $this->substratSQL2 = "";
                $this->joinStratSQL = " ";
                $this->joinStratSQL2 = " ";
                $this->activeStreamSQL = "enabled = 'Y'";

                $this->baseSQL ="select currency as bFX from ccp_instruments where asset_id=";
                break;

            default:
                $this->alias = "Portfolio";
                $this->tableNameRoot = "models";
                $this->tableNameHolds = "models_holdings";
                $this->fieldName = "portfolio_id";
                $this->reportName = "Portfolios";
                $this->dateName = "timestamp";
                $this->substratSQL = ", -1 as sid, 'Single Position' as sname ";
                $this->substratSQL2 = ", -1 as sid, 'Single Position' as sname ";
                $this->joinStratSQL = " ";
                $this->joinStratSQL2 = " ";
                $this->activeStreamSQL = "active = 'Y'";
                $this->baseSQL = "select textvalue as bFX from ccp_models_params where param='homeCurrency' and portfolio_id=";


        }
    }

    public function getHistoricalHoldingsSQL(){
        $SQLArray = [];

        switch ($this->stype){
            case "2":
                $sstrat = "S.desc";
                $sjoin = "ccp_substrategies_desc S on S.substratid = H.substrat_id";
                $sdate = "date_created";
                $sdesc = "S.desc,";
                break;

            case "1":
                //Fall through
            case "3":
                $sdesc="";
                $sdate = "applicable_date";
                $sjoin = "{$this->tableNameRoot} S on S.{$this->deptID} = H.{$this->deptID}";
                $sstrat = "S.{$this->deptName}";
                break;
        }

        $SQLArray[0] ="select H.{$sdate} as applicable_date, H.timestamp,  I.asset_type, {$sstrat} as strategy, I.asset_name, round
(H.value*10000)*.01 as model_weight
                        from {$this->tableNameHolds} as H
                        join {$sjoin}
                        join ccp_instruments I on H.asset_id = I.asset_id
                        where H.{$this->deptID} = ";

        $SQLArray[1] = " and H.value <> 0 order by H.timestamp desc, " . $sdesc . "I.asset_name, H.value";

        return $SQLArray;
    }
}