<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-06-10
 * Time: 1:57 PM
 */

namespace AlphaSelect;


abstract class Stream {
    private $streamInputChoice;
    protected $streamSQL;
    protected $streamName;
    protected $perfStartDate;

    public abstract function getPerfStartDateSQL();

    public function setInputs(StreamInputChoice $streamInputChoice)
    {
        //Implement setInputs() method.
        $this->streamInputChoice = $streamInputChoice;
    }

    public function getStreamSQL(){
        return $this->streamSQL;
    }
    public function getStreamInputChoice(){
        return $this->streamInputChoice;
    }

    public function setPerfStartDate($requestDate){

        //requestDate logic needs to be modified to force a max-window of requestDate - 5 years, unless there's another
        //switch to switch it off i.e. get the full history.

        //I see it operating : if the startDate found earlier than the 5 years ago (according to the requestDate) then 5 year history is set.
        //If full history flag is set then we just get the earliest possible date...

        //TODO We may wish to change this one per stream...because we want to add instruments as a stream and not have any conditional statements.

        if ($this->getStreamSQL()->getAlias() != 'Instrument'){
            //Not an instrument
            $mySQL = $this->getPerfStartDateSQL();

            //Go get it...
            $dDates =  mxrAS_db_grabRows('AS',$mySQL,false);
            if(count($dDates)>0){
                //Use it as the start date
                $startDate = "{$dDates[0][0]}";
            } else {
                //Set it to be 5 years ago (relative to the rDate which is off form yyyy-mm-dd)
                if(!isset($requestDate)){
                    $requestDate = date('Y-m-d');
                }
                $startDate = (substr($requestDate,0,4)*1-5) . substr($requestDate,4);
            }
        } else {
            //Is an instrument - i.e. no parameters table to worry about.
            $startDate = "1900-01-01";
        }

        //Set the startdate
        $this->perfStartDate = $startDate;
    }

    public function getPerfStartDate(){
        return $this->perfStartDate;
    }

    public function getStreamName(){

        if(!isset($this->streamName)){
            $this->setStreamName();
        }
        return $this->streamName;
    }

    protected function setStreamName(){
        $sic = $this->getStreamInputChoice();
        $mySQL = "SELECT m.{$sic->getFieldName()}_name pid FROM ccp_{$sic->getTableRoot()} as m WHERE m.{$sic->getFieldName()}_id = {$sic->getStreamID()}";

        //Make the database request for all the rows.
        $rows = mxrAS_db_grabRows('AS', $mySQL, true);
        $this->streamName = $rows[0]['pid'];
    }

} 