<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-05-28
 * Time: 2:38 PM
 *
 * The StreamFactory builds you the right Stream and uses the abstract abstractStream class and the various ViewStream, PortfolioStream etc
 * subclasses...
 */

namespace AlphaSelect;


abstract class StreamCreator {

    //Implementing classes must have a creation option.
    protected abstract function createStream(IStream $stream);
    protected abstract function createStreamFromParams($snapshotDate, $streamID, $typeID);

    //Now manufacture the stream - from an instantiated object
    public function buildStream($_stream){
        $myStream = $this->createStream($_stream);
        return $myStream;
    }

    //Or you can use the factory to build from params
    public function buildStreamFromParams($_snapshotDate, $_streamID, $_typeID){
        $myStream = $this->createStreamFromParams($_snapshotDate, $_streamID, $_typeID);
        return $myStream;
    }
}
