<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-06-09
 * Time: 9:57 AM
 */

namespace AlphaSelect;


class StreamInputChoice {

    //This class simply takes the inputs and builds an object with an htmlEntities clean up in cleanUpProperties....
    //You would typically call this with $_POST inputs.
    const CLASSSUFFIX = 'Stream';

    private $snapShotDate;
    private $streamID;
    private $typeID;

    //The problem with classnames is that it needs to be maintained non-centrally...
    //Perhaps a look up to populate it.
    private static $CLASSNAMES = ["1"=>'Portfolio', "2"=>'View', "3"=>'Strategy', "4"=>'Instrument'];

    private static $VARS = ['snapShotDate', 'streamID', 'typeID'];

    function __construct($_date, $_streamID, $_typeID){
        //It does no real work.
        $this->setUpProperties($_date, $_streamID, $_typeID);
    }

    //Set up the properties...
    public function setUpProperties($_date, $_streamID, $_typeID){

        $this->snapShotDate = $_date;
        $this->streamID = $_streamID;
        $this->typeID = $_typeID;

        $this->cleanUpProperties();

    }

    //Get the member variables
    public function getSnapShotDate(){
        return $this->snapShotDate;
    }

    public function getStreamID(){
        return $this->streamID;
    }

    public function getClassName(){
        return '\\' . __NAMESPACE__ . '\\' . self::$CLASSNAMES["" . $this->getTypeID()] . self::CLASSSUFFIX;
    }

    public function getTypeID(){
        return $this->typeID;
    }

    //Clean up the variables that may have been POSTED
    private function cleanUpProperties(){
        foreach(self::$VARS as $v){
            $this->$v = htmlentities($this->$v);
        }
    }

} 