<?php
/**
 * Created by PhpStorm.
 * User: NLaxton
 * Date: 30/03/2015
 * Time: 11:40 AM
 */

namespace AlphaSelect;

//We store the details of a particular trade.
class TradeDetails {
    //We want to get the changes in the portfolio which is handled in SQL...
    //We get all the rows we want as preTrade, postTrade and Trade categories.

    private $sqlDetails;
    private $dept_id;
    private $stype_id;
    private $streamDetails;
    private $positionList;
    public $nTrades;
    private $namesArray;
    private $partialWITHStatement;

    private function addDeptSQL($bool = true){
        $dep = "AND dept_id = {$this->dept_id}";

        if ($bool) {
            //We compare the alias to get the SQL
            $SQL = ($this->streamDetails->getAlias()=="View") ? "" : $dep;
        } else {
            $SQL = $dep;
        }
        return $SQL;
    }
    private function setPartial(){

        //The SQL here is pretty abstract and we have the SQL that relies on the
        //Dept type else where in this class.

        //There are view dependant SQL entries
        $this->partialWITHStatement = "
        currentHoldings AS
	            (SELECT * FROM holdingsDetails
	            WHERE view_id =
                    (SELECT view_id FROM currentViewIDTSFromDate) AND model_weight<>0 {$this->addDeptSQL()}),

	    previousHoldings AS
	            (SELECT * FROM holdingsDetails
	            WHERE view_id =
                    (SELECT view_id FROM previousViewIDTSFromDate) AND model_weight<>0 {$this->addDeptSQL()}),

	    allTrades AS (
                SELECT (select distinct view_id from currentHoldings) as view_id, asset_id, 'trade' as Htype,
                -1*model_weight as
                model_weight,0 as substrat_id
                FROM previousHoldings
                UNION ALL
                SELECT view_id, asset_id, 'trade' as Htype, model_weight, 0 as substrat_id
                FROM currentHoldings),

	    sumTrades AS (
                SELECT view_id,asset_id,Htype,SUM(model_weight) as model_weight,substrat_id
                FROM allTrades
                GROUP BY asset_id,view_id,htype,substrat_id),

        finalTrades AS (
                SELECT view_id, asset_id, 'currentH' as Htype, model_weight,substrat_id
                FROM currentHoldings
                UNION
                SELECT view_id, asset_id, 'previousH' as Htype, model_weight, substrat_id
                FROM previousHoldings
                UNION
                SELECT * FROM sumTrades
                WHERE model_weight <>0)

        SELECT F.view_id, F.substrat_id, I.asset_id, I.asset_name, D.desc, I.asset_type, I.iaa_aid, F.htype, F.model_weight
        FROM finalTrades F
        JOIN ccp_instruments I on I.asset_id = F.asset_id
        JOIN ccp_substrategies_desc D on F.substrat_id = D.substratid
        ORDER BY F.Htype, F.substrat_id, F.model_weight, I.asset_id";
    }

    function __construct($tradeID = null, $deptID = null, $stype = null){


        $this->namesArray = ['currentH'=>'Current Position', 'previousH'=>'Previous Position', 'trade'=>'Trade'];

        $this->dept_id = $deptID;
        $this->stype_id = $stype;

        $this->streamDetails = new StreamDetails($this->stype_id);

        $this->setPartial();//relies on dept_id

        //Now we check tradeID. It could be the viewID OR a ts.
        if($this->streamDetails->getAlias()=="View"){
            $this->viewID = $tradeID;
            $this->setSQLDetailsWithCurrentViewID();

        } else {

            $this->ts = $tradeID;
            $this->setSQLDetailsWithTS();
        }

        $this->setFullPositionList();
    }

    private function setSQLDetailsWithTS(){

        //There's a distinction with different stream types.


        $this->sqlDetails = "WITH " . $this->streamDetails->getTradeDetailsWithHeader() . "
        currentViewIDTSFromDate AS
	            (SELECT DISTINCT ON  (dept_id) view_id,timestamp
	             FROM holdings
	             WHERE timestamp<='{$this->ts}' {$this->addDeptSQL(false)}
                 ORDER BY dept_id,timestamp DESC),

	    previousViewIDTSFromDate AS
	            (SELECT DISTINCT ON (dept_id) view_id,timestamp
	            FROM holdings
                WHERE timestamp<
                    (SELECT timestamp FROM currentViewIDTSFromDate) {$this->addDeptSQL(false)}
                ORDER BY dept_id, timestamp DESC)," . $this->partialWITHStatement;
    }

    private function getViewID(){
        return $this->viewID;
    }

    public function getRationale(){
        //So we adapt this for the differing details etc.
        $rationale = "Alpha Select Trades";
        if ($this->streamDetails->getAlias() == "View") {
            $sql = "select rationale from ccp_strategies_holdings where view_id = {$this->getViewID()}";
            $rows = mxrAS_db_grabRows('AS', $sql, true);
            $rationale = $rows[0]['rationale'];
        }

        if($this->nTrades==0){
            $rationale = $rationale . " : No trades found, this was a model update only.";
        }
        return $rationale;
    }

    public function getDeptName(){
        //We adapt this for differing details etc.
        $localName = $this->streamDetails->getDeptName();
        $sql = "select {$localName} from {$this->streamDetails->getTableRoot()} where
        {$this->streamDetails->getDeptIDName()} = {$this->dept_id}";

        //$sql = "select dept_name from ccp_strategies where dept_id = {$this->dept_id}";
        $rows = mxrAS_db_grabRows('AS', $sql, true);
        return $rows[0]["{$localName}"];
    }
    private function setSQLDetailsWithCurrentViewID(){
        //If we have the viewID then we could use the same type of sql but we could look up the ts, deptid we need?
        $tmpSQL = "SELECT dept_id, timestamp from ccp_strategies_holdings where view_id = {$this->viewID}";
        $row = mxrAS_db_grabRows('AS', $tmpSQL, true);

        $this->dept_id = $row[0]['dept_id'];
        $this->ts = $row[0]['timestamp'];

        $this->setSQLDetailsWithTS();
    }

    private function setFullPositionList(){
        //echo $this->sqlDetails;
        $this->positionList = mxrAS_db_grabRows('AS', $this->sqlDetails, true);

        $this->viewID = $this->positionList[0]['view_id'];
    }

    public function getFullPositionList(){
        return $this->positionList;
    }

    public function getTradeList(){
        $tmp = [];

        $hasTrades = false;

        foreach($this->getFullPositionList() as $posRow){
            if ($posRow['htype']=='trade'){
                $tmp[] = $posRow;
                $hasTrades = true;
            }
        }

        if(!$hasTrades){
            $tmp[] = [];
        }
        return $tmp;
    }

    public function createHCJson(){
        //$namesArray = ['currentH'=>'Current Position', 'previousH'=>'Previous Position', 'trade'=>'Trade'];
        $keyData = $this->refactorPositionList();

        $jSonSeries = [];

        $riskData = [];

        //'z1'=>$this->namesArray[$k] . ": " .(double)(number_format($isoRisk*$keyData['data'][$k][$cat],2))
        //'z1'=>$this->namesArray[$k] . ": 0.00"
        foreach($this->namesArray as $k=>$name){
            $data = [];
            foreach($keyData['cats'] as $x=>$cat){
                //$isoRisk = 0;//sqrt(mxrAS_getCovar($riskData, $k, $k));

                if(isset($keyData['data'][$k][$cat])){
                    $data[] = array(
                            'y'=>(double)(number_format($keyData['data'][$k][$cat]*1,2))
                    );
                } else {
                    $data[] = array(
                        'y'=>(double)(number_format(0,2))
                    );
                }
            }
            $jSonSeries[]=array('name'=>$name, 'data'=>$data);
        }

       return $jSonSeries;
    }

    private function getChartTitle(){
        $localName = $this->streamDetails->getDeptName();
        $sql = "select {$localName} from {$this->streamDetails->getStratTable()} where
        {$this->streamDetails->getDeptNameID()} = {$this->dept_id}";
        $deptName = mxrAS_db_grabRows('AS', $sql, true);

        $fDate = substr($this->ts, 0, 4) . "-" . substr($this->ts, 4, 2) . "-" . substr($this->ts, 6, 2);

        return "Trades For " . $deptName[0]["{$localName}"] . " With Trade Timestamp {$fDate}";
    }

   // 'tooltip'=> mxrAS_HCSetTableTooltipArray("Position %",["Isolated Risk %"])
    public function createChart(){
        $keyData = $this->refactorPositionList();

        return array(
            'chartOptions' => array(
                'chart' => array('type' => 'bar'),
                'title' => array('text' => $this->getChartTitle()),
                'xAxis' => array('categories'=> $keyData['cats']),
                'yAxis'=> array('title'=>array('text'=>'Position/Trade %')),
                'credits' => mxrAS_HCGetCredits(),
                'exporting' => mxrAS_HCGetExporting(),
                'tooltip'=>array('valueSuffix'=>' %')
            ),
            'chartData' => $this->createHCJson()
        );
    }

    private function refactorPositionList(){
        $pos = $this->getFullPositionList();
        $tmp = [];
        $ids = [];
        foreach($pos as $p) {
            $k = $p['htype'];
            $n = $p['asset_name'];
            $tmp[$k][$n] = number_format($p['model_weight'],2);

            $tid = $p['asset_id'];
            if (!isset($ids[$tid])) {
                $ids[$n] = $tid;
            }

            $cats[]=$n;
        }

        $z = array_unique($cats);
        $cats = [];
        foreach($z as $k=>$v){
            $cats[]=$v;
        }

        //print_r($cats);
        return array('cats'=>$cats, 'data'=>$tmp, 'idMap'=>$ids);
    }

    public function getTradeRowsForTable($cat = 'trade'){
        //Put each line of the tables into a 3 way table...
        $keyData = $this->refactorPositionList();

       //Grab the fills for these ids.  idMap[name]=id
        $fills = $this->getFills($keyData['idMap']);


        //Grab the data
        $trades = array();

        //We may have no trades here - so need to handle it.
        if(!empty($keyData['data'][$cat])) {
            foreach ($keyData['data'][$cat] as $k => $v) {
                //set the fill and close.
                $tid = $keyData['idMap'][$k];

                $close = (isset($fills[$tid]['close'])) ? $fills[$tid]['close'] : "N/A";
                $stopprice = (isset($fills[$tid]['stopprice'])) ? $fills[$tid]['stopprice'] : "N/A";

                $trades[] = array('asset_name' => $k, 'model_weight' => $v, 'close' => $close, 'stopFill' => $stopprice);
            }

            $this->nTrades = count($trades);
        } else {
            $this->nTrades = 0;
        }

        return $trades;
    }

    private function getTStoDate(){
        return substr($this->ts,0,4) . "-" . substr($this->ts,4,2) . "-" . substr($this->ts,6,2);
    }

    private function getFills($assetArray){
        //We can grab fills for any asset_id group.

        $ids = "(" . implode(",", $assetArray) . ")";

        $SQL = "WITH
                    closePrices AS (
                        SELECT I.asset_id, R.value, I.reversequote
                        FROM ccp_strategies_holdings_details det
                        join ccp_strategies_holdings h on h.view_id = det.view_id
                        join ccp_instruments I on det.asset_id = I.asset_id
                        join rets_series_desc D on i.iaa_aid = D.name
                        JOIN rets_series_constituents C on C.series_id = D.series_id
                        JOIN rets_series_data R on R.series_id = C.constituents
                        WHERE D.periodicity = 'D' AND C.comp_order = 0
                        and R.ts = to_date(substring(h.timestamp from 1 for 4) ||'-'||substring(h.timestamp from 5
                        for 2) ||'-' || substring(h.timestamp from 7 for 2),'yyyy-mm-dd')
                        and det.view_id ={$this->getViewID()}),

                    stopPrices AS (
                        SELECT l.dept_id,map.stop_id, map.view_id,s.asset_id,v.timestamp,s.stopprice,s.stopamount
                        from ccp_stopviewmap as map
                        join ccp_stops_details s on s.stop_id = map.stop_id
                        join ccp_stops l on s.stop_id = l.stop_id
                        join ccp_strategies_holdings v on v.view_id = map.view_id
                        join ccp_instruments i on i.asset_id = s.asset_id
                        where i.reversequote is not null and v.view_id = {$this->getViewID()})

                    SELECT distinct closePrices.asset_id, closePrices.value, (
                            CASE WHEN stopPrices.stopprice IS NULL THEN -closePrices.value
                            ELSE stopPrices.stopprice
                            END), closePrices.reversequote
                    FROM closePrices
                    LEFT OUTER JOIN stopPrices on closePrices.asset_id = stopPrices.asset_id
                    where closePrices.asset_id in {$ids}";

        $rawFills = mxrAS_db_grabRows('AS', $SQL, true);
        $fillOutput = [];

        if (count($rawFills)>0) {
            $nsf = 4;//Number of significant figures.

            //So the fills are of form id, close, fill (which may be empty).
            foreach ($rawFills as $fill) {
                $idFill = $fill['asset_id'];

                $flag = ($fill['reversequote'] < 0) ? -1 : 1;
                $fillOutput[$idFill]['close'] = number_format(pow($fill['value'], $flag), $nsf);

                $wasNull = ($fill['stopprice']<0) ? $flag: 1;
                $fillOutput[$idFill]['stopprice'] = number_format(pow(abs($fill['stopprice']), $wasNull), $nsf);
            }
        }

        return $fillOutput;
    }
}