<?php
/***************************************************
* Commands Library
* mxr AlphaSelect 2013
****************************************************/
//Existing Charts
function mxrAS_HP(){
	echo ('Generates a historical NAV for a particular alpha stream or security?');
}
function mxrAS_IRAT(){
	echo ('Information ratios by asset for a given alpha stream and date period.');
}
function mxrAS_LL(){
	echo ('Lead/Lag IR for alphastream.');
}
function mxrAS_RA(){
	echo ('Rolling Alpha Chart');
}

//Add a new view or portfolio
add_action("wp_ajax_mxrAS_ANV", "mxrAS_ANV");
function mxrAS_ANV(){
	//First parse the post variables...
	$streamChoice = $_POST['streamChoiceRadio'];
	$baseFX = $_POST['fxList'];
	$dispName = $_POST['displayName'];
	$shortName = $_POST['shortName'];
	$location = $_POST['location'];
	$perfStart = $_POST['snapshotDate'];
	$desc = $_POST['desc'];
	$weightList = $_POST['weightList'];
	
	//Create the new view...
	$msg = mxrAS_AddNewStream($streamChoice,$baseFX,$dispName,$shortName,$perfStart,$location,$desc,$weightList);
	
	//Report out the message...
	echo (json_encode(array('meta'=>mxrAS_HCMakeMeta('message', '',array(),array(),0,$msg))));
	die();
}




add_action("wp_ajax_mxrAS_ANI","mxrAS_ANI");
function mxrAS_ANI(){
	//Add new instrument
	$ANIpacket = array('dsCode'=>$_POST['dsCode'],
					   'group'=>$_POST['group'],
					   'source'=>$_POST['source'],
					   'desc'=>$_POST['rawName'],
					   'period'=>$_POST['periodicity'],
					   'shortName'=>$_POST['instrumentCode'],
					   'calcGroup'=>$_POST['calc'],
					   'base'=>$_POST['fxList'],
					   'insType'=>$_POST['atype']
					   );
	
	$success = mxrAS_addNewInstrument($ANIpacket);
	echo (json_encode(array('meta'=>mxrAS_HCMakeMeta('message', '',array(),array(),0,$success ? "New Instrument Added" : "Something went wrong - please check DB"))));
	die();
}


add_action("wp_ajax_mxrAS_TESTSTREAMFACTORY", "mxrAS_TESTSTREAMFACTORY");
function mxrAS_TESTSTREAMFACTORY(){

    //We use a streamFactory to build the stream from the POSTed inputs - which automatically get cleaned...
    $myStreamFactory = new \AlphaSelect\StreamFactory();
    $desiredReturnStream = $myStreamFactory->buildStreamFromParams('2014-06-10',6,1);//($_POST['snapshotDate'], $_POST['streamListWrapper'], $_POST['streamChoiceRadio']);

    //Let's do a quick check of any data...
    $sic = $desiredReturnStream->getStreamInputChoice();

    //Why not create a holdings object
    $holdings = new \AlphaSelect\Holdings($desiredReturnStream);


    $pParams = array('snapshotDate'=>$sic->getSnapShotDate(),'streamChoiceRadio'=>$sic->getStreamID(),'streamListWrapper'=>$sic->getTypeID());

    if($holdings->hasHolds()){
        //How do we chose the start date?
        //Monthly returns and monthly attribution but no stats.

        $retsArray = mxrAS_getMonthlyAttribution($sic->getSnapShotDate(),$sic->getTypeID(),$sic->getStreamID());
        //Why not just change the function to accept a streamInputChoice...
        //$retsArray = mxrAS_getMonthlyAttribution($streamInputChoice->getSnapShotDate(), $streamInputChoice->getTypeID(), $streamInputChoice->getStreamID());

        //Lets make a chart from it too... Mar 2014 - change for cumulative too
        $pName = mxrAS_getPortfolioName($sic->getTypeID(), $sic->getStreamID());


        $charts = mxrAS_makeDrillDownAttChart($retsArray, array('main'=>"Monthly Attribution Totals and Drilldown For {$pName}." , 'y'=>'% Return', 'x'=>'Date'));

        //Lets make a table to display it all in...
        //$pParams = array('snapshotDate'=>$radioDate,'streamChoiceRadio'=>$streamChoice,'streamListWrapper'=>$streamID);
        echo(
        json_encode(
            array(
                'meta'=>mxrAS_HCMakeMeta('chart_tableArray','chart',$pParams,$charts,1,"Found Data..."),
                'charts'=>$charts,
                'table'=>mxrAS_makePSATTableArray($retsArray,$sic->getTypeID(),$sic->getStreamID(),$pName,'PSAT')
            )
        )
        );
    } else {
        echo(json_encode(array('meta'=>mxrAS_HCMakeMeta('error','error',$pParams,[],1,"<h3><font color='red'>No Holdings Found For This Stream</font></h3>"))));
    }
    die();
}
add_action("wp_ajax_mxrAS_UL", "mxrAS_UL");
function mxrAS_UL(){
    //Are you admin?
    global $wpdb;
    $myList = "";

    if(current_user_can('manage_options')){
        //print a list of users and their ids.
        $wp_user_search = $wpdb->get_results("SELECT ID, display_name FROM $wpdb->users ORDER BY ID");
        foreach( $wp_user_search as $uid){
            $myList .= "\t" . '<li>' . (int)$uid->ID . ' : ' . stripslashes($uid->user_login) . ' : ' . stripslashes($uid->display_name) . "\n";
        }
    } else {
        $myList = 'Sorry - only admins can view this data...';
    }

    echo($myList);
    die();
}
add_action("wp_ajax_mxrAS_OC", "mxrAS_OC");
function mxrAS_OC(){

	//So we should clean the post data
	mxrAS_cleanPOSTvars();

    //Create the option from the database and price the history.
	$myOption = new AlphaSelect\Option($_POST['streamListWrapper'], '2014-03-01', $_POST['snapshotDate']);

	//Prepare the output with a Table Object
	//$myTable = new AlphaSelect\Table(
	$metaData = mxrAS_HCMakeMeta('chart_tableArray', 'StockChart', array('snapshotDate'=>$_POST['snapshotDate'], 'streamListWrapper'=>$_POST['streamListWrapper']), '', 0,
	     "<h3>Processed {$myOption->db_desc}</h3>", " For " . $myOption->db_desc);
	echo(json_encode(
		array('meta'=> $metaData,
			  'charts'=> $myOption->getPriceChart('OC'),
			  'table'=> array( $myOption->getParamsTable('OC'), $myOption->getPriceGreeksTable('OC'))
			 )
		   )
		);
	die();
}

add_action("wp_ajax_mxrAS_OCR", "mxrAS_OCR");
function mxrAS_OCR()
{
    //So this is a post that does what OC does except it injects it's own parameters into the option details.

    //So we just need a way to include the various items into the DBParams of the option...

    //Don't forget that the setup js will need to change too. Dec 2015
    die();
}

add_action("wp_ajax_mxrAS_AAS","mxrAS_AAS");
function mxrAS_AAS(){
	//Adds a new view or alpha stream to the database...

	//Is it a portfolio/view/or strategy?
	$streamChoice = $_POST['streamChoiceRadio'];
	$name = $_POST['streamName'];
	$desc = $_POST['desc'];
	$base = $_POST['fx']; //From a dropdown.
	$perfStDate = $_POST['perfSt'];
	$loc = $_POST['loc']; //From a dropdown.

	//First task is to define the new strat etc in a table...
	//So we send the name,description,base_perspective,perf_inception_date,location.
	//Returns the new dept_id or portfolio_id.

    //TODO the below function needs to be built?
	$ID = mxrAS_createNewAlphaStream($streamChoice,$name,$desc,$base,$perfStDate,$loc);

	//Now we need to assign some parameters...
	//Basic version just pairs things up...

	$paramsArray = $_POST['params'];
	$pStDate = $_POST['paramSt'];

	mxrAS_createNewParams($streamChoice,$ID,$pStDate,$name,$paramsArray);

	//Now go grab the summary from the database and report it back...
	//However for now - we just say yippee and die
	echo(json_encode(
			array('meta'=>
				array('infoMsg'=>'Request was successful',
					  'type'=>'success',
					  'controlType'=>'msg')
					)
				)
			);
	die();
}

//Performance Commands
add_action("wp_ajax_mxrAS_ALV", "mxrAS_ALV");
function mxrAS_ALV(){
	//Produce a line chart for the Average Leverage.

	//Pick up the post-ed data
	$streamID = $_POST['streamListWrapper'];
	$streamChoice = $_POST['streamChoiceRadio'];
	$radioDate = $_POST['snapshotDate'];

	$perfTypeID = 12;//Av Leverage

    //Have a query to on the fly produce the Gross, Net and Directional Leverage
    /*select applicable_date, sum(abs(value)) as GrossLeverage, sum(value) as NetLeverage,
sum((case when value >=0 then 1 else 0 end)*value)/sum((case when value<0 then -1 else 0 end)*value) as DirectionalRisk
from ccp_models_holdings where portfolio_id = 4 and asset_id<>207
group by applicable_date
order by applicable_date*/

    //This would be a multiple series chart...


	//Send back to client.
	echo json_encode(mxrAS_timeSeriesFromPerfTable($streamID,$streamChoice,$radioDate,$perfTypeID));
	die();
}

//TODO
function mxrAS_RDIS(){
	echo('Return Distirbution for a given stream');
}
function mxrAS_PCA(){
	echo ('PCA Analysis for given alphastream.');
}
function mxrAS_RCON(){
	echo ('Top contributions to risk budget.');
}

//Not currently generated...
function mxrAS_HPTF(){
	echo ('Generates a historical NAV with trade Flags');
}
function mxrAS_HPA(){
	echo ('Historical NAV of an asset for a given AlphaStream');
}
function mxrAS_HPATF(){
	echo ('Historical NAV of an asset with Trade Flags for a given AlphaStream');
}
