<?php
/***************************************************
* General Functions Library
* mxr AlphaSelect 2013
****************************************************/

function mxrAS_uniqueByKeyName($array,$key){
	foreach($array as $row){
		$uvals[] = $row[$key];
	}
	return array_unique($uvals);
}

function mxrAS_checkLoad_capcat($defaultCapability='zas_view_gen'){
	//Simply checks if logged in for now...
	return ( is_user_logged_in() ) ;
}

function mxrAS_checkCapabilities(){
	
	//Grab the user meta data
	$thisUserID = get_current_user_id();
	$thisUserInfo = get_userdata($thisUserID);
	
	//Now pick up the capabilities
	$myCaps = $thisUserInfo->allcaps;
	
	//Then filter them on the zas capabilities...
	//Just filter on caps == 1 - just in case something slips through the net. 
	$capsOnKeys = array_keys(array_filter($myCaps,"mxrAS_isOneCallback"));
	
	//Now filter the keys on zasmg and zas
	$megaCaps = array();
	$gCaps = array();
	foreach($capsOnKeys as $key){
		if (substr($key,0,5) == 'zasmg'){
			$megaCaps[] = $key;
		} elseif (substr($key,0,3)== 'zas'){
			$gCaps[] = $key;
		}	
	}
	
	return (array('megaGroup'=>$megaCaps,'gGroup'=>$gCaps));
}

function mxrAS_isOneCallback($var){
	return $var==1;
}
function mxrAS_groupArrayResults($dataRows,$keys,$streamDetails){
	//Take a database query - and loop over the results grouping them into an array indexed on the nth column or property...
    //Get the unique Column Names in the data...i.e. the pivots.
	$uniqueColNames=array();
	$uniqueRowNames=array();
	
	$pCol = $keys['pivotCol'];
	$pRow = $keys['pivotRow'];
	
	foreach($dataRows as $row){
		$uniqueColNames[]=$row[$pCol];
		$uniqueRowNames[]=$row[$pRow];
	}
	$uniqueColNames=array_unique($uniqueColNames);
	$uniqueRowNames=array_unique($uniqueRowNames);
	
	//Now for every row in the series we can fill in a new table
	$outputTable=array();
	$vCol = $keys['valueCol'];
	$fCol = $keys['formatCol'];
	
	if ($fCol!=-1){
		foreach($dataRows as $row){
			$c=$row[$pCol];
			$r=$row[$pRow];
			
			//Format the output according to the format data in the format column. 
			$myFormat=explode("%",$row[$fCol]);
			$ps='';
			switch($myFormat[0]){
				case "p":
					$row[$vCol] = 100*$row[$vCol];
					$ps='%';
					break;
			}
			
			$outputTable[$r][$c]=sprintf('%' . $myFormat[1],$row[$vCol]) . $ps;
			
		}
	} else {
		foreach($dataRows as $row){
			$c=$row[$pCol];
			$r=$row[$pRow];
			$outputTable[$r][$c]=$row[$vCol];
		}
	}
	
	//Insert the 'pivotRow name at the beginning of the column names
	array_splice($uniqueColNames,0,0,$streamDetails['reportName']);
	
	return array('rowHeader'=>$uniqueRowNames, 'colHeader'=>$uniqueColNames,'table'=>$outputTable);
}

function mxrAS_hasStopsTriggers($stype, $deptid){
    $SQL = "select count(stop_id) from ccp_stops where stype_id={$stype} and dept_id = {$deptid}";

    $rows = mxrAS_db_grabRows('AS', $SQL, true);
    if($rows[0]>0){
        $tmp = 1;
    } else {
        $tmp = 0;
    }
    return $tmp;
}

function mxrAS_reformatDate($rd,$tokIn,$tokOut,$idx){
	$rdEx=explode($tokIn,$rd);
	return $rdEx[$idx[0]] . $tokOut . $rdEx[$idx[1]] . $tokOut . $rdEx[$idx[2]];
}

function mxrAS_prepareStopListOutput($wrapper, $radio, $date, $type = 'Z', $premsg=""){

    $myStopList = new AlphaSelect\StopList($wrapper, $radio, $date, $type);

    $divID = "mxrAS_dStoptable";
    $tDOM = "mxrAS_stopListTable";
    //Build a table from the list...we expect some of the html to be there already...
    //So now we build a datatable object?
    if($myStopList->getNumStops()>0){
        //There are some to show...

        $outputTable = new AlphaSelect\Table(
            $myStopList->getStopList(),
            $divID,
            $tDOM,
            $premsg . "List built for {$myStopList->getDeptName()} on {$date} : Found {$myStopList->getNumStops()} Stops."
        );

        //Now we set the meta Params
        $outputTable->setMeta('tableArray', [$date, $radio]);

        //Set the cols (we go for all of them);
        $cols = [
            'rationale'=>'Rationale',
            'startdate'=>'Stop Since',
			'startts'=>'Timestamp (GMT)',
            'status'=>'Status',
            'triggeredon'=>'Triggered On',
            'tadjustment'=>'PnL Adjustment bp',
            'killedon'=>'Killed On',
            'editview'=>'Edit/View'
        ];

        $outputTable->setCols($cols);

        $output =  $outputTable->getFullTable();

    } else {
        $output =  array("meta"=>array('astype'=>"success", 'clear'=>"{$divID}", 'controlType'=>"message", 'preMsg'=>"<h4>No Stops Found</h4>"));
    }

    return $output;
}

function mxrAS_getStreamDetails($streamChoice){
	//This is reused many times makes sense to put into separate function.
	
	switch($streamChoice){
		case "1":
			$alias = "Portfolio";
			$tableNameRoot = "models";
			$tableNameHolds = "models_holdings";
			$fieldName = "portfolio";
			$reportName = "Portfolios";
			$dateName = "timestamp";
			$substratSQL = ", -1 as sid, 'Single Position' as sname ";
			$substratSQL2 = $substratSQL;
			$joinStratSQL = " ";
			$joinStratSQL2 = " ";
			
			$baseSQL = "select textvalue as bFX from ccp_models_params where param='homeCurrency' and portfolio_id=";
			$activeStreamSQL = "active = 'Y'";
			$tblAppend = "_holdings";

			break;
			
		case "2":
			$alias="View";
			$tableNameRoot="strategies";
			$tableNameHolds="strategies_original_weights_vw";
			$fieldName="dept";
			$reportName="Views";
			$dateName = "timestamp";
			$substratSQL = ",h.substrat_id sid, substrats.desc as sname ";
			$substratSQL2 = ",wl.stratID sid, substrats.desc as sname ";
			$joinStratSQL = " JOIN ccp_substrategies_desc substrats ON substrats.substratid = h.substrat_id ";
			$joinStratSQL2 = " JOIN ccp_substrategies_desc substrats ON substrats.substratid = wl.stratID ";
			
			$baseSQL = "select textvalue as bFX from ccp_strategies_params where param='basePerspective' and dept_id=";
			
			$activeStreamSQL = "dept_status = 'L'";
			$tblAppend = "";

			break;

		case "3":
			$alias="Strategy";
			$tableNameRoot="signals";
			$tableNameHolds="signals_holdings_adjusted";
			$fieldName="dept";
			$reportName="Strategies";
			$dateName = "timestamp";
			$substratSQL = ", -1 as sid, 'Single Position' as sname ";
			$substratSQL2 = $substratSQL;
			$joinStratSQL = " ";
			$joinStratSQL2 = " ";	
			$activeStreamSQL = "dept_status = 'L'";
			
			$baseSQL = "select textvalue as bFX from ccp_signals_params where param='basePerspective' and dept_id=";
			$tblAppend = "_holdings_adjusted";

			break;
		
		case "4":
			//Instruments
			$alias = "Security";
			$tableNameRoot = "instruments";
			$tableNameHolds = "";
			$fieldName = "asset";
			$reportName="Securities";
			$dateName = "";
			$substratSQL = "";
			$substratSQL2 = "";
			$joinStratSQL = " ";
			$joinStratSQL2 = " ";
			$activeStreamSQL = "enabled = 'Y'";
			
			$baseSQL ="select currency as bFX from ccp_instruments where asset_id=";
			break;

		case "5":
			//NAV and Managed FH Funds
			$alias = "Fieldhouse Pro Funds";
			$tableNameRoot = "fhc_classes";
			$tableNameHolds = "fhc_pms";
			$fieldName = "classdescshort";
			$reportName = "FHC Pro Funds Inc.";
			$dateName = "ts";//In fhc_monthlyreport
			$substratSQL = "";
			$substratSQL2 = "";
			$joinStratSQL = "";
			$joinStratSQL2 = "";
			$activeStreamSQL = "";
			$baseSQL = 'select basefx as bFX from fhc_classes where classid = ';
			break;
		
		default:
			$alias="Portfolio";
			$tableNameRoot="models";
			$tableNameHolds="models_holdings";
			$fieldName="portfolio";
			$reportName="Portfolios";
			$dateName = "timestamp";
			$substratSQL = ", -1 as sid, 'Single Position' as sname ";
			$substratSQL2 = $substratSQL;
			$joinStratSQL = " ";
			$joinStratSQL2 = " ";
			$activeStreamSQL = "active = 'Y'";
			$baseSQL = $baseSQL = "select textvalue as bFX from ccp_models_params where param='homeCurrency' and portfolio_id=";
			
			
	}
	
	return array('alias'=>$alias, 
				'tableNameRoot'=>$tableNameRoot, 
				'tableNameHolds'=>$tableNameHolds, 
				'fieldName'=>$fieldName, 
				'reportName'=>$reportName,
				'dateName'=>$dateName,
				'subID'=>$substratSQL,
				'joinStratSQL'=>$joinStratSQL,
				'activeStreamSQL'=>$activeStreamSQL,
				'joinStratSQL2'=>$joinStratSQL2,
				'subID2'=>$substratSQL2,
				'baseSQL'=>$baseSQL);
}

function mxrAS_buildDropDown($id, $rows, $selRow, $keys = ['opValue'=>'k', 'opLabel'=>'v']){

    $listStr="<select id='" . $id . "'>";
	
	for($i=0;$i<count($rows);$i++){
		$listStr .= '<option value="' . $rows[$i][0] . '"';
		if($i==$selRow){
			$listStr .=  ' selected="selected">';
		}else{
			$listStr .= '">' ;
		}
		$listStr.= $rows[$i][1] . '</option>';
	}
	return $listStr;
}

function mxrAS_buildDropDownWithNames($id, $rows, $selRow, $keys = ['opValue'=>'k', 'opLabel'=>'v']){

    //We could pass a selVal and check if the value has a particular value - if it does then we select it otherwise we pick the first value.

    $listStr = "<select id='{$id}'>";

    $i = 0;
    foreach ($rows as $thisRow){

        //Build the option html
        $listStr .= '<option value = "' . $thisRow[$keys['opValue']] . '"';
        $valueStr = $thisRow[$keys['opLabel']];

        //Add an attribute if necessary
        if(isset($keys['opAtts'])){
            $valueStr .=" (";
            $vArray = [];
            foreach($keys['opAtts'] as $k=>$v){
                $listStr .= " mxrAS_{$k} = '{$thisRow[$k]}'";
                $kWord = ucfirst($k);
                $vArray[] = " {$kWord}: {$thisRow[$k]} {$v} ";
            }
            $valueStr .= implode("::",$vArray) . ")";
        }

        $listStr .= ( ($i++ == $selRow) ? ' selected = "selected">' : '">') . $valueStr . '</option>' ;

    }

    return $listStr;
}

function mxrAS_timeSeriesForRSCAT($streamID, $streamChoice,$rd,$pTypeID, $cType = 'StockChart', $scalar = 1){
	$perfName = "";


}


function mxrAS_timeSeriesFromPerfTable($streamID, $streamChoice, $radioDate, $perfTypeID, $chartType='StockChart', $scalar = 1, $rscat = 0){
	//Grab the chart
	$perfName = "";

    //We probably need to have a bank of SQL to get the things we want...
	//Check if we have been sent an array of perfTypeIDs...
	if (is_array($perfTypeID)){
		//Do multi-series;
		
		//Can we adapt for an instrument? Jan 2014 NFL

		$charts = mxrAS_MultiTSeriesByTypeID($radioDate, $streamChoice, $streamID, $perfTypeID, $perfName,true, $chartType, $rscat);
		$mSeries = 1;
	} else {

		//Can we adapt for a Instrument? Jan 2014 NFL

		$charts = mxrAS_SQL_TSeriesByTypeID($radioDate, $streamChoice, $streamID, $perfTypeID, $perfName, $scalar);
		$mSeries = 0;
	}
	//Export the chart.
	$pParams = array('snapshotDate'=>$radioDate, 'streamChoiceRadio'=>$streamChoice, 'streamListWrapper'=>$streamID);
	$metaData = mxrAS_HCMakeMeta('chart',$chartType, $pParams, $charts, $mSeries, $perfName);
	
	return (array('meta'=> $metaData,'charts'=>$charts));
}

function mxrAS_getCalcTypeDetails($calcType){
	switch ($calcType){
		case 'pos':
			$calcTypeDetails=array(
								'titleText'=> 'Positions',
								'yAxisLabel'=> 'Exposures %');
			break;
			
		case 'iso':
			$calcTypeDetails=array(
								'titleText'=> 'Isolated Risk',
								'yAxisLabel'=> 'Annual Risk %');
			
			break;
		
		case 'dv1':
			$calcTypeDetails=array(
								'titleText'=> '1bp Position Change',
								'yAxisLabel'=> 'Annual Risk %');
			
			break;
		
		case 'mcr':
			$calcTypeDetails=array(
								'titleText'=> 'Marginal Contribution To Risk',
								'yAxisLabel'=> 'Annual Risk %',
								'subtitleText'=> 'Click columns to view sub-report. Click again to view master.');
			break;
        case 'dur':
            $calcTypeDetails = array(
                'titleText'=> 'Durations',
                'yAxisLabel'=> 'Years'
            );
            break;
	
	}
	return $calcTypeDetails;
}


?>