<?php
/***************************************************
* Risk Calculations
* mxr AlphaSelect 2013
****************************************************/

function mxrAS_getMC2R($positions,$riskData,$type){
	//Depending on type we perform various calculations

	$results=array();

	switch($type){
		case 'iso':
			//Isolated risks

			// So we need the diagonal of the risk matrix - i.e. where id1=id2 and fill our output matrix
			// We only need the risk tenors for the positions.
			$uniqueRiskTenors = $positions['dTypes'];
			$tok = $positions['dTok'];

			//For each of these we need the risk matrix entry (variance) sqrt * weight as the iso risk.
			foreach($positions['dRows'] as $row){
				$key = $row[$tok];
				$secID = $row[6];

				$var = $riskData[$secID][$secID];
				$isoRisk = $row[5]*sqrt($var)*100;

				$results[$key]['chartOptions']['xAxis']['categories'][]=$row[3];
				$results[$key]['chartData']['data'][]=(double)(number_format($isoRisk,2));
			}

			break;

		case 'dv1':
			//DV 01 approach...
			//Bit different as results come back for the whole risk model, not subset based on positions.
			break;
		case 'mcr':
			//Marginal Contribution To Risk
			break;

	}
	return $results;
}

function mxrAS_getRiskTable(&$riskDate,$streamChoice,$streamID,$myIDs){
	// So we pull in all the risk pairs
	// The data is organised such that we only have the upper echelon and diagonal stored.
	// We must build the whole matrix for ourselves here as we go along.


	$subSQLCommon = "(	SELECT MAX(d.applicable_date)
	          			FROM ccp_exantecovar d
	          		    WHERE d.applicable_date<='" . $riskDate . "')";

	$selectSQLCommon = "SELECT r.applicable_date as rdate, r.secid1, r.secid2, r.var
	          	  	  	FROM ccp_exantecovar r";

	$orderSQLCommon = " ORDER BY r.secid1,r.secid2";

	//This may need to be overwritten in the switch statment.
	$sqlInject = " JOIN idTable id1 ON r.secid1 = id1.secid1
					       JOIN idTable id2 ON r.secid2 = id2.secid1
	                       WHERE r.applicable_date = ";

	//This may be overkill for now as if we have an empty portfolio

	switch ($streamChoice){
		case null:
			//Get everything...
			$sqlInject = " WHERE r.applicable_date = ";
			$myWith = "";
	        break;

	    case -1:
	    	//We passed $myIDs as array
	    	if(count($myIDs)>0){

	    		$myWith = "WITH idTable AS (
					SELECT DISTINCT i.asset_id as secid1
					FROM ccp_instruments i
					WHERE i.asset_id IN (" . implode(',',$myIDs) . ")) ";
			} else {
				$myWith = "";
				$sqlInject = " WHERE r.applicable_date = ";
			}
			break;

	    default :
	      //Get only the secIDs in the stream we want...
            //TODO but this should use the same option logic elsewhere in the program - i.e. reuse that code...
	      $streamDetails = mxrAS_getStreamDetails($streamChoice);
	      $myWith = "WITH idTable AS (
						SELECT DISTINCT x.asset_id as secid1
						FROM ccp_" . $streamDetails['tableNameHolds'] . " x
						JOIN ccp_instruments i on i.asset_id=x.asset_id
						JOIN ccp_" . $streamDetails['tableNameRoot'] . " m on m." . $streamDetails['fieldName']. "_id = x." . $streamDetails['fieldName'] . "_id
						WHERE x.applicable_date = (
							SELECT MAX(x.applicable_date) mdate
							FROM ccp_" . $streamDetails['tableNameHolds'] . " x
							WHERE x.applicable_date <='" . $riskDate ."' AND x." . $streamDetails['fieldName'] . "_id=" . $streamID .")
	 						AND x." . $streamDetails['fieldName'] . "_id=" . $streamID . ") " ;
	 				/* " AND i.iaa_aid <> (m.base_perspective || '_USD_30DFWD')
					) "; */
	}


	$mySQL = $myWith . $selectSQLCommon . $sqlInject . $subSQLCommon . $orderSQLCommon;
    //echo ($mySQL);
    //Get the data and return matrix
	$rows = mxrAS_db_grabRows('AS',$mySQL,false);

	$riskMatrix = array();
	// Update the radioDate
	if (count($rows)>0) {
		$riskDate = $rows[0][0];

		// And build the risk matrix using the asset ids as keys...
		$riskMatrix = array();
		foreach($rows as $r){
			$id1=(string)$r[1];
			$id2=(string)$r[2];

			$riskMatrix[$id1][$id2]=$r[3];

			// Copies into lower echelon - we could just do it and have some duplicated copying
			// instead of the if statement. Not sure if N if statements quicker than N copies.

			if ($r[1]<$r[2]){
				$riskMatrix[$id2][$id1]=$r[3];
			}
		}
	}
	// And send it back to be used - in this case we do not know the assets involved...but
	// we could look up the unique key values and then run a query to get them...

	return $riskMatrix;
}

function mxrAS_riskCalcByPos($type,$askedForDate,$streamChoice,$streamID,$sView=true){
	// 1 - Go get the risk data for this askedForDate...which will modulate the $riskDate too...
	$riskDate = $askedForDate;
	$riskData = mxrAS_getRiskTable($riskDate,$streamChoice,$streamID,array());

	switch ($type){
		case 'iso':
			$msg = "Isolated Risks";
			break;
		case 'mcr':
			$msg = "Marginal Contributions To Risk";
			break;
		case 'dv1':
			$msg = "Change in Risk By Buying 1bp";
			break;
		case 'pos':
			$msg = "Current Positions";
			break;
        case 'dur':
            $msg = "Current Durations";
            break;
	}

	// 3 - Now do the calculations...
	$charts = mxrAS_SQL_CPOS($askedForDate,$streamChoice,$streamID,$type,$riskData,$sView);
	$pParams = array('snapshotDate'=>$askedForDate,'streamChoiceRadio'=>$streamChoice,'streamListWrapper'=>$streamID,'riskModelDate'=>$riskDate);
	$metaData = mxrAS_HCMakeMeta('chart','chart', $pParams,$charts,0,"Found " . count($charts) . " asset class carve outs. " . $msg . " shown, different charts plotted for clarity. ", mxrAS_getPortfolioName($streamChoice,$streamID));

	return array('meta'=> $metaData,'charts'=>$charts);
}


function mxrAS_getCovar($riskData,$secID1,$secID2,$riskGuess=0){
	if(!isset($riskData[$secID1][$secID2])){
		$r = $riskGuess;
	} else {
		$r = $riskData[$secID1][$secID2];
	}
	return $r;
}
function mxrAS_doRiskCalcs($results, $riskData, $calcType){

	/* Several calcTypes : ISOlated risk, Marginal Cont 2 Risk, DV01, Positions and finally TE */

	// We need to get access to the deltas - so we multiply by delta of the instrument...
	//And handle multiple ids for non-dv01 instruments....



	//We let non-risk model securities be included as zero...

	$cashID = 207;

	//TE is common and reported back with all types:
    $TE = mxrAS_getTE($results, $riskData);

	//Now decided the calcs we need to perform:
	switch ($calcType){
		case'dur':
        case 'pos':
		case 'iso':
			//We should filter the risk data and position data -
			//like an intersect of sec id and $r[6];
			foreach($results['dRows'] as $r){
				$secID = (string)$r['aid'];
				$stratID = (string)$r['sid'];

				$posData[$secID][$stratID]=$r['val'] * $r['delta'];

				//This works on unaggregated data - but we lose the strat details which we should add now...
				//Allows for non-risk asset
                $thisIsoRisk = sqrt(mxrAS_getCovar($riskData, $secID,$secID))*$r['delta'];
				$posRisk[$secID][$stratID] = ($thisIsoRisk/$r['delta']) * $posData[$secID][$stratID];
                $isoRisk[$secID][$stratID] = $thisIsoRisk;
			}
			break;

		case 'mcr':

			if($TE!=0){

				//Probably a great way to tidy this lot up but it's broken down for debug ease...
				//SigmaW needs is on the aggregated data...i.e only nAssets in size.
				foreach($results['dRiskIDs'] as $i){
					$idx=(string)$i;
					$sigmaW[$idx]=0;

					foreach($results['dRows'] as $j){
						$secID = (string)$j['aid'];
						$sigmaW[$idx] += mxrAS_getCovar($riskData,$idx,$secID) * $j['val'] * $j['delta'];
					}
				}

				// Now deduce Marginals on all data...
				foreach($results['dRows'] as $i){
					$secID=(string)$i['aid'];
					$stratID = (string)$i['sid'];

					$posData[$secID][$stratID] = $i['val'];
                    $isoRisk[$secID][$stratID] = sqrt(mxrAS_getCovar($riskData, $secID, $secID)) * $i['delta'];
					$posRisk[$secID][$stratID] = $sigmaW[$secID]*$posData[$secID][$stratID]/$TE;
				}

			} else {
				foreach($results['dRows'] as $i){
					$secID = (string)$i['aid'];
					$stratID = (string)$i['sid'];

					$posData[$secID][$stratID] = $i['val'] * $i['delta'];
					$posRisk[$secID][$stratID] = 0;

                    $isoRisk[$secID][$stratID] = sqrt(mxrAS_getCovar($riskData, $secID, $secID)) * $i['delta'];

				}
			}
			break;

		case 'dv1':

			//This may need some work for the unaggregated data...

			$dChange= 0.01;//1% change (buy)
			foreach($results['dRows'] as $i){
				$secID=(string)$i['aid'];
				//The change in variance is
				$d1 = mxrAS_getCovar($riskData,$secID,$secID)*$dChange*$dChange;
				$d2=0;
				foreach($results['dRows'] as $j){
					$jID=(string)$j['aid'];
					$d2 += $j['val'] * mxrAS_getCovar($riskData,$secID,$jID) * $j['delta'];
				}

                $posData[$secID] = $i['val'];
			    $posRisk[$secID] = sqrt($TE*$TE + $d1+$d2*$dChange*2) - $TE;

                $isoRisk[$secID][$stratID] = sqrt(mxrAS_getCovar($riskData, $secID, $secID)) * $i['delta'];

			}
			break;

	}

	return array('posData'=>$posData,'posRisk'=>$posRisk,'TE'=>$TE, 'isoRisk'=>$isoRisk);

}


function mxrAS_getTE($results, $riskData){
	//This should work with/without aggregation as we simply add every possible combination...

    //print_r($results);
	//TE Check
	$TE = 0;

	//We essentially calc. w1*w2*s1*s2 with risk data being a fully expressed (not U echelon) matrix.

	/* We now need to get the dv01setup part of the array included...
		This means that when we have a row it could have several constituent parts - we could re-engineer
		this section to handle factors and then have a factor matrix but at May 2014 we will not do this.

		So we inspect the dv01setup and look up the components to include in the risk calc.
	*/
	// Outer loop
	foreach($results['dRows'] as $outerRow){
		//Each row has potentially multiple risk ids with it's own weight scheme.
        $w1 = $outerRow['val']*$outerRow['delta'];

        //Loop over the multiple securities in the weightScheme
        foreach ($outerRow['dv01Setup'] as $id1=>$weightScheme1){
            //The id
            $s1 = (string)$id1;//$outerRow['aid'];

		    // Now the inner loop if s1 set of course...
		    if(isset($riskData[$s1])){

                //Loop the inner row
                foreach($results['dRows'] as $innerRow){

                    //Preset the weight
                    $w2 = $innerRow['val']*$innerRow['delta'];

                    //loop over the multiple securities in the weightScheme
                    foreach($innerRow['dv01Setup'] as $id2=>$weightScheme2){
                        //The second id
                        $s2 = (string)$id2;//$s2 = (string)$innerRow['aid'];

                        //Now complete the calculation if the row is set.
                        if(isset($riskData[$s2])){
                           $TE += $riskData[$s1][$s2]*$w1*$w2*$weightScheme1*$weightScheme2;
                        }
                    }//End inner multiple
                }//End inner
            }//End if s2
		}//End outer multiple
	}//End outer

	return sqrt($TE);
}

function mxrAS_buildExAnteStreamCov($radioDate, $alphaStreamArray,$correl,$getUnderlying){
	//1 for each alpha stream array go get the positions.
	$uniqueRiskIDs = array(); //Passed by reference below.
	$streams = mxrAS_getStreamWeightsFromStreamArray($radioDate, $alphaStreamArray,$uniqueRiskIDs);

	//1a - just added -
	if($getUnderlying){
		//We create a unique list of underlying securities from the streams - i.e. array_unique($allRiskIDs)
		//Each one is added as a new stream and get the names...
		//This also hits the database for every instrument so a lot of calls - could be neater...
		$instrumentClassID = 4;
		foreach($uniqueRiskIDs as $asset_id){
			$tempWgts = mxrAS_getPortfolioWeights($radioDate,$instrumentClassID,$asset_id);
			$myName = $instrumentClassID . ":" . $tempWgts['pid'];
			$streams[$myName] = $tempWgts; //Should have added a "portfolio" of one asset with weight 1.
		}
	}

	//2 Get the riskdata with all the unique ids in the streams we found...
	$riskData = mxrAS_getRiskTable($radioDate,-1,0,$uniqueRiskIDs);

	//3 for each position pair we call the exanteCov but only once for each pair...
	$myCov = array();
	foreach($streams as $k1=>$stream1){
		foreach($streams as $k2=>$stream2){
			if(!isset($myCov[$k1][$k2])){
				$myCov[$k1][$k2] = mxrAS_exanteCovar($stream1,$stream2,$riskData,$correl);
				$myCov[$k2][$k1] = $myCov[$k1][$k2];
			}
		}
	}
	return $myCov;
}

function mxrAS_getSecNames($secIDs,$asKeyArray = false, $trimNames = false){

    //only do the numeric ones.
    $nSecIDs = [];
    foreach($secIDs as $i){
        if(is_numeric($i)){
            $nSecIDs[] = $i;
        }
    }

    $results = [];
    if(count($nSecIDs)>0){
	    $mySQL = "select asset_id, graphLabel from ccp_instruments where asset_id in (" . implode( "," , $nSecIDs) . ")";

	    //Grab the results of the query to get the names...
	    $results = mxrAS_db_grabRows('AS',$mySQL,false);

	    //Trim the names?
	    if($trimNames){
		    foreach($results as &$res){
			    $trimmer = explode(" ",$res[1]);
			    unset($trimmer[0]);
			    $res[1] = implode(" ", $trimmer);
		    }
	    }
    }

	//Build an array with id as secid and value as name...
	if ($asKeyArray) {
		$outputs = array();
		foreach($secIDs as $secID){
			$outputs["{$secID}"] = "{$secID}";
		}
		//Now fill in the results data
		foreach($results as $r){
			$outputs["{$r[0]}"]=$r[1];
		}
	} else {
		$outputs = $results;
	}

	return $outputs;
}

function mxrAS_getStreamWeightsFromStreamArray($radioDate,$streamArray,&$uniqueIDs){
	$streams = array();
	$allRiskIDs = array();

	$thisDate = $radioDate;
	foreach($streamArray as $p){
		$tempWgts = mxrAS_getPortfolioWeights($radioDate,$p['streamChoice'],$p['streamID']);
		$myName = $p['streamID'] . ":" . $tempWgts['pid'];
		$streams[$myName] = $tempWgts;

		//Find the unique set of ids
		if($tempWgts['pop']){
			//Handle the ever growing list of riskIDs...
			$allRiskIDs = array_merge($allRiskIDs,$tempWgts['dRiskIDs']);
		}

		//Reset the radioDate...
		$radioDate = $thisDate;
	}

	//Return the unique IDs
	$uniqueIDs = array_unique($allRiskIDs);

	//Send back the streamWeights...
	return $streams;
}

function mxrAS_buildExPostStreamCov($radioDate,$alphaStreamArray,$nMinMonths = 6,$correl,$getUnderlying){

	$thisDate = $radioDate;
	//0 for each alpha stream array go get the positions.
	if ($getUnderlying){
	    $uniqueRiskIDs = array(); //Passed by reference below.
		mxrAS_getStreamWeightsFromStreamArray($radioDate, $alphaStreamArray,$uniqueRiskIDs);

		//We should probably stich uniqueIDs to the alphaStreamArray

		$excludedSecurities = array(207,132);

		foreach($uniqueRiskIDs as $asset_id){
			if(!in_array($asset_id,$excludedSecurities)){
				$alphaStreamArray[]=array('streamChoice'=>'4','streamID'=>"{$asset_id}");
			}
		}

	}

	//1 Go grab all the portfolioReturns (monthly) for each choice.
	$streams = array();
	foreach($alphaStreamArray as $p){
		$mData = mxrAS_getMonthlyReturns($radioDate,$p['streamChoice'],$p['streamID']);
		$radioDate = $thisDate;//As it's passed by reference above...
		$name = $p['streamID'] . ":" . mxrAS_getPortfolioName($p['streamChoice'],$p['streamID']);
		$streams[$name]=$mData;
	}

	//2 then figure out what we need to do with all the streams...
	//...We do pairwise as default...
	//If data series < nMinMonths then we display a NED (not enough data).
	$myCov = array();
	foreach($streams as $k1=>$stream1){
		foreach($streams as $k2=>$stream2){
			if(!isset($myCov[$k1][$k2])){
				if($k1==$k2){
					$myCov[$k1][$k2] = 1;
				} else {
					$myCov[$k1][$k2] = mxrAS_expostCovar($stream1,$stream2,$nMinMonths,$correl);
					$myCov[$k2][$k1] = $myCov[$k1][$k2];
				}
			}
		}
	}
	return $myCov;
}

function mxrAS_expostCovar($rets1,$rets2,$nMonths = 6, $correl = true){
	//We deduce the ex-post cov/correl between between 2 return streams
	$cov = 0;

	//Line up the two series...
	$xRet1 = mxrAS_adjustMonthlyNavSeries($rets1,'plotDate','mRet');
	$xRet2 = mxrAS_adjustMonthlyNavSeries($rets2,'plotDate','mRet');

	$nRets = array(count($xRet1),count($xRet2));

	$xRet1 = array_intersect_key($xRet1,$xRet2); //All the items in xRet1 that are in xret2.
	$xRet2 = array_intersect_key($xRet2,$xRet1); //And now the corresponding items in xret1;

	//print_r($xRet2);
	//Quick check if we go anything...
	if (count($xRet1)<$nMonths || count($xRet2)<$nMonths){
		$cov = 'NED';
	} else {
		//We got something...
		$samples = array (count($xRet1)!=$nRets[0] ? true : false, count($xRet2)!=$nRets[1] ? true : false);
		$s1 = $correl ? mxrAS_stdDev($xRet1,$samples[0]) : 1;
		$s2 = $correl ? mxrAS_stdDev($xRet2,$samples[1]) : 1;

		if(($s1==0) || ($s2==0)){
			$cov = 'NED';
		} else {
			$cov = mxrAS_covar($xRet1,$xRet2)/$s1/$s2;
			if(is_nan($cov)){
				$cov = 'NED';
			}
		}
	}

	return $cov;
}

function mxrAS_stdDev($rets,$sample = false){
//Simple loop to deduce a population standard deviation.
// If sample is true then assumes a sample and alters the 1/(n-1) part.

	$sumSq = 0;
	$sqSum = 0;
	$n = count($rets);

//Loop over the rets.
	foreach($rets as $r){
		$sumSq += pow($r,2);
		$sqSum += $r;
	}
	$offSet = ($sample ? 0 : 1);

	return sqrt(($sumSq - pow($sqSum,2)/$n)/($n - $offSet));
}


function mxrAS_covar($rets1,$rets2){
//Gets the covariance of 2 securities.
	$sX = 0;
	$sY = 0;
	$sXY = 0;
	$n = count($rets1);

//$rets1 and 2 may not have numeric indices
//but are assumed to be same length and have same keys...
	foreach($rets1 as $k=>$r){
		$sX += $r;
		$sY += $rets2[$k];
		$sXY += $r*$rets2[$k];
	}

//Return the output.
	return  ($sXY - $sX*$sY/$n)/$n;
}


function mxrAS_adjustMonthlyNavSeries($monthlyNavSeries,$key,$field){
//Pick off the field from a monthly nav series object and use $key as the key...
	$xRet = array();
	foreach($monthlyNavSeries as $m){
		$k = $m[$key];
		$xRet[$k] = $m[$field];
	}
	return $xRet;
}

function mxrAS_exanteCovar($wgt1,$wgt2,$riskData,$correl = true){
	//This deduces the ex-ante covariance between two portfolios...
	$cov = 0;

	if($wgt1['pop'] && $wgt2['pop']){
		//we assume a correlation is required - send false otherwise...
		$te1 = $correl ? mxrAS_getTE($wgt1,$riskData) : 1;
		$te2 = $correl ? mxrAS_getTE($wgt2,$riskData) : 1;

		//In te we deduce w(t)*sig*w
		//Here we deduce wi(t)*sig*wj

		foreach($wgt1['dRows'] as $wi){
			foreach($wgt2['dRows'] as $wj){
					$cov += $wi['val']*$wj['val'] * mxrAS_getCovar($riskData,(string)$wi['aid'],(string)$wj['aid']);
			}
		}

		if($te1==0||$te2==0){
			$cov='NED';
		}else{
			$cov = $cov/$te1/$te2;
		}

	} else {
		$cov = 'NED';
	}
	return $cov;
}