<?php

/*
Plugin Name: AlphaSelect
Plugin URI: http://alphaselect.marketxray.com/
Description: Control, monitor and manage multiple sources of alpha in one effective risk managed framework.
Version: 2.2
Author: Nick Laxton, Market X-Ray Limited.
Author URI : http://www.marketxray.net
License: Private
*/

/* Copyright 2003-2022 Market X-Ray Limited UK (nick.laxton@marketxray.com)
	This software is for licensed users only and you should have a written agreement with Market X-Ray Limited to use it. The use
	of AlphaSelect without a license agreement is copyright theft. For the avoidance of doubt you should check with the author if your 
	license is in order before using the software. 
*/

/**************************************************
* Global Variables
***************************************************/

$mxrAS_prefix='mxrAS_';
$mxrAS_pluginName='AlphaSelect WP Plugin';

/**************************************************
* Includes
***************************************************/

//All my classes in the following directories
$classArray = [
        ['path'=>"includes/lib/",
            'files'=>array('Option', 'Position', 'RiskMatrix', 'Table', 'Stop', 'StopList', 'StopDetails', 'StopDetailSingle', 'StreamDetails', 'TradeRow', 'TradeSummary', 'TradeDetails')],
        ['path'=>"includes/lib/Commands/",
            "files"=>array("DropDownCmds", "WatchListCmds", "ExposureCmds", "PerformanceCmds", "RiskChartCmds", "StopCommands", "TradeSummaryCmds","DashboardCmds")],
        ['path'=>"includes/lib/HoldingsPattern/",
            'files'=>array('Holdings')],
        ['path'=>"includes/lib/StreamFactoryPattern/",
            'files'=>array('IStream', 'IStreamSQL')],
        ['path'=>"includes/lib/StreamFactoryPattern/BaseClasses/",
            'files'=>array('Stream', 'StreamCreator', 'StreamFactory', 'StreamInputChoice', 'StreamSQL', 'StreamSQLCreator', 'StreamSQLFactory')],
        ['path'=>"includes/lib/StreamFactoryPattern/Products/",
            'files'=>array('PortfolioStream', 'PortfolioStreamSQL', 'StrategyStream', 'StrategyStreamSQL', 'ViewStream', 'ViewStreamSQL')]
];

foreach($classArray as $folderList){
    $path = $folderList['path'];
    $files = $folderList['files'];
    foreach($files as $includeFile){
        include_once($path . $includeFile . ".php");
    }
}

include_once('includes/lib/PHPStats.phar');//External Library

//All the function libraries too
$functionalArray = array('mxrAS_General_Functions', 'mxrAS_JS_CSS_Scripts', 'mxrAS_Data_Processing', 
						 'mxrAS_HTML_Builders', 'mxrAS_Commands', 'mxrAS_CustomTypes', 
						 'mxrAS_WatchListExtensions', 'mxrAS_RiskCalcExtensions', 'mxrAS_HighCharts',
						 'mxrAS_DropDowns', 'mxrAS_Instruments', 'mxrAS_Performance',
                         'mxrAS_WP_Directives');

foreach($functionalArray as $f){
	include("includes/{$f}.php");
}

error_reporting(-1);