<?php
/**
 * Template Name: AS-RiskPage
 *
 * Description: The AlphaSelect full-width risk output page.
 * Author: Nick Laxton May 2013
 */

get_header(); 
?>
		
<div id="primary" class="site-content">
	<h4>AlphaSelect Summary</h4><br/>
		
		<div id='mxrAS_choiceArea'>
			<!-- So radio choices must be wrapped in a div = mxrAS_GROUPID and then the inputs name=mxrAS_GROUPID match the id. Any control picking the data has a param with GROUPID-->
			<div id='mxrAS_streamChoiceRadio' class='mxrAS_radioButtons hidden' mxrAS_type='radio'>
   				<input type='radio' id='mxrAS_streamChoiceRadio-1' value=1 name='mxrAS_streamChoiceRadio' mxrAS_type='streamChoiceRadio'/><label for='mxrAS_streamChoiceRadio-1'>Portfolios</label>
   				<input type='radio' id='mxrAS_streamChoiceRadio-2' value=2 name='mxrAS_streamChoiceRadio' mxrAS_type='streamChoiceRadio'/><label for='mxrAS_streamChoiceRadio-2'>Views</label>
   				<input type='radio' id='mxrAS_streamChoiceRadio-3' value=3 name='mxrAS_streamChoiceRadio' mxrAS_type='streamChoiceRadio'/><label for='mxrAS_streamChoiceRadio-3'>Strategies</label>
   			</div> 
			<br/>

			<!--Dates must be <span id=mxrAS_YOURID /> then <input name=mxrAS_YOURID/> with param as YOURID-->
			<span id='mxrAS_snapshotDate' class='mxrAS_snapshotDate hidden' mxrAS_type='date'>
				Snapshot Date (on or before): <input name='mxrAS_snapshotDate' type="text" class='mxrAS_snapshotDate mxrAS_dateRange mxrAS_today' id='mxrAS_Summary_snapshotDate'/>
			</span>
			
			<div id='mxrAS_updateButtonDiv' class='mxrAS_updateButton hidden' mxrAS_type='button'>
				<input type="submit" id='mxrAS_CMD_updateButton' mxrAS_ajaxURL='mxrAS_CMD' class='mxrAS_updateButton mxrAS_CMD' mxrAS_params='streamChoiceRadio snapshotDate' mxrAS_XP='b-sent' value="Rebuild Summary"/>
			</div>

			<span id='mxrAS_streamListWrapper' class='mxrAS_dropDown hidden' mxrAS_type='dropDown' mxrAS_ajaxURL='mxrAS_DD' mxrAS_XP='dd-streams ddName-mxrAS_streamList' mxrAS_params='streamChoiceRadio snapshotDate'>
				Choose Alpha Stream ?
			</span>
                 	
		</div><!--choice area-->	

	<div id="content" role="main">
	
		<?php while ( have_posts() ) : the_post(); ?>
		<?php get_template_part( 'content', 'page' ); ?>
		<?php comments_template( '', true ); ?>
		<?php endwhile; // end of the loop. ?>

		


		<div id='mxrAS_CMD_outputArea' class='mxrAS_CMD'>
		
		<div id='mxrAS_CMD_infoMessage' class='mxrAS_CMD mxrAS_infoMessage'>Message Area</div>
			
		</div><!--outputArea-->	
		
	</div><!-- #content -->
	
</div><!-- #primary -->


<?php get_footer(); ?>