<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Variables are used in function scope.
$current = $this->get_field_value( 'style_selection' );
$styles  = get_theme_support( 'genesis-style-selector' );
?>
<table class="form-table">
<tbody>

	<tr valign="top">
		<th scope="row"><label for="<?php $this->field_id( 'style_selection' ); ?>"><?php esc_html_e( 'Color Style:', 'genesis' ); ?></label></th>
		<td>
			<p><select name="<?php $this->field_name( 'style_selection' ); ?>" id="<?php $this->field_id( 'style_selection' ); ?>">
				<option value=""><?php esc_html_e( 'Default', 'genesis' ); ?></option>
				<?php
				if ( ! empty( $styles ) ) {
					$styles = array_shift( $styles );
					foreach ( (array) $styles as $style => $style_title ) {
						?>
						<option value="<?php echo esc_attr( $style ); ?>"<?php selected( $current, $style ); ?>><?php echo esc_html( $style_title ); ?></option>
						<?php
					}
				}
				?>
			</select></p>

			<p><span class="description"><?php esc_html_e( 'Please select the color style from the drop down list and save your settings.', 'genesis' ); ?></span></p>
		</td>
	</tr>

</tbody>
</table>
